/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object with details the status of an Amazon Web Services account within your Amazon Inspector environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountState implements SdkPojo, Serializable, ToCopyableBuilder<AccountState.Builder, AccountState> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AccountState::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<State> STATE_FIELD = SdkField.<State> builder(MarshallingType.SDK_POJO).memberName("state")
            .getter(getter(AccountState::state)).setter(setter(Builder::state)).constructor(State::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<ResourceState> RESOURCE_STATE_FIELD = SdkField
            .<ResourceState> builder(MarshallingType.SDK_POJO).memberName("resourceState")
            .getter(getter(AccountState::resourceState)).setter(setter(Builder::resourceState))
            .constructor(ResourceState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, STATE_FIELD,
            RESOURCE_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final State state;

    private final ResourceState resourceState;

    private AccountState(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.state = builder.state;
        this.resourceState = builder.resourceState;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * An object detailing the status of Amazon Inspector for the account.
     * </p>
     * 
     * @return An object detailing the status of Amazon Inspector for the account.
     */
    public final State state() {
        return state;
    }

    /**
     * <p>
     * An object detailing which resources Amazon Inspector is enabled to scan for the account.
     * </p>
     * 
     * @return An object detailing which resources Amazon Inspector is enabled to scan for the account.
     */
    public final ResourceState resourceState() {
        return resourceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(resourceState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountState)) {
            return false;
        }
        AccountState other = (AccountState) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(state(), other.state())
                && Objects.equals(resourceState(), other.resourceState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountState").add("AccountId", accountId()).add("State", state())
                .add("ResourceState", resourceState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "resourceState":
            return Optional.ofNullable(clazz.cast(resourceState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("resourceState", RESOURCE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountState, T> g) {
        return obj -> g.apply((AccountState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountState> {
        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An object detailing the status of Amazon Inspector for the account.
         * </p>
         * 
         * @param state
         *        An object detailing the status of Amazon Inspector for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(State state);

        /**
         * <p>
         * An object detailing the status of Amazon Inspector for the account.
         * </p>
         * This is a convenience method that creates an instance of the {@link State.Builder} avoiding the need to
         * create one manually via {@link State#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link State.Builder#build()} is called immediately and its result is
         * passed to {@link #state(State)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link State.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(State)
         */
        default Builder state(Consumer<State.Builder> state) {
            return state(State.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * An object detailing which resources Amazon Inspector is enabled to scan for the account.
         * </p>
         * 
         * @param resourceState
         *        An object detailing which resources Amazon Inspector is enabled to scan for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceState(ResourceState resourceState);

        /**
         * <p>
         * An object detailing which resources Amazon Inspector is enabled to scan for the account.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceState.Builder} avoiding the need
         * to create one manually via {@link ResourceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceState.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceState(ResourceState)}.
         * 
         * @param resourceState
         *        a consumer that will call methods on {@link ResourceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceState(ResourceState)
         */
        default Builder resourceState(Consumer<ResourceState.Builder> resourceState) {
            return resourceState(ResourceState.builder().applyMutation(resourceState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private State state;

        private ResourceState resourceState;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountState model) {
            accountId(model.accountId);
            state(model.state);
            resourceState(model.resourceState);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final State.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(State.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(State state) {
            this.state = state;
            return this;
        }

        public final ResourceState.Builder getResourceState() {
            return resourceState != null ? resourceState.toBuilder() : null;
        }

        public final void setResourceState(ResourceState.BuilderImpl resourceState) {
            this.resourceState = resourceState != null ? resourceState.build() : null;
        }

        @Override
        public final Builder resourceState(ResourceState resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public AccountState build() {
            return new AccountState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
