/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response that contains the results of a finding aggregation by AMI.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmiAggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<AmiAggregationResponse.Builder, AmiAggregationResponse> {
    private static final SdkField<String> AMI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ami")
            .getter(getter(AmiAggregationResponse::ami)).setter(setter(Builder::ami))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ami").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AmiAggregationResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(AmiAggregationResponse::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final SdkField<Long> AFFECTED_INSTANCES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("affectedInstances").getter(getter(AmiAggregationResponse::affectedInstances))
            .setter(setter(Builder::affectedInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("affectedInstances").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMI_FIELD, ACCOUNT_ID_FIELD,
            SEVERITY_COUNTS_FIELD, AFFECTED_INSTANCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ami;

    private final String accountId;

    private final SeverityCounts severityCounts;

    private final Long affectedInstances;

    private AmiAggregationResponse(BuilderImpl builder) {
        this.ami = builder.ami;
        this.accountId = builder.accountId;
        this.severityCounts = builder.severityCounts;
        this.affectedInstances = builder.affectedInstances;
    }

    /**
     * <p>
     * The ID of the AMI that findings were aggregated for.
     * </p>
     * 
     * @return The ID of the AMI that findings were aggregated for.
     */
    public final String ami() {
        return ami;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the AMI.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the AMI.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * An object that contains the count of matched findings per severity.
     * </p>
     * 
     * @return An object that contains the count of matched findings per severity.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    /**
     * <p>
     * The IDs of Amazon EC2 instances using this AMI.
     * </p>
     * 
     * @return The IDs of Amazon EC2 instances using this AMI.
     */
    public final Long affectedInstances() {
        return affectedInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ami());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        hashCode = 31 * hashCode + Objects.hashCode(affectedInstances());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiAggregationResponse)) {
            return false;
        }
        AmiAggregationResponse other = (AmiAggregationResponse) obj;
        return Objects.equals(ami(), other.ami()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(severityCounts(), other.severityCounts())
                && Objects.equals(affectedInstances(), other.affectedInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmiAggregationResponse").add("Ami", ami()).add("AccountId", accountId())
                .add("SeverityCounts", severityCounts()).add("AffectedInstances", affectedInstances()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ami":
            return Optional.ofNullable(clazz.cast(ami()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        case "affectedInstances":
            return Optional.ofNullable(clazz.cast(affectedInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ami", AMI_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        map.put("affectedInstances", AFFECTED_INSTANCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmiAggregationResponse, T> g) {
        return obj -> g.apply((AmiAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmiAggregationResponse> {
        /**
         * <p>
         * The ID of the AMI that findings were aggregated for.
         * </p>
         * 
         * @param ami
         *        The ID of the AMI that findings were aggregated for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ami(String ami);

        /**
         * <p>
         * The Amazon Web Services account ID for the AMI.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An object that contains the count of matched findings per severity.
         * </p>
         * 
         * @param severityCounts
         *        An object that contains the count of matched findings per severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * <p>
         * An object that contains the count of matched findings per severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }

        /**
         * <p>
         * The IDs of Amazon EC2 instances using this AMI.
         * </p>
         * 
         * @param affectedInstances
         *        The IDs of Amazon EC2 instances using this AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedInstances(Long affectedInstances);
    }

    static final class BuilderImpl implements Builder {
        private String ami;

        private String accountId;

        private SeverityCounts severityCounts;

        private Long affectedInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(AmiAggregationResponse model) {
            ami(model.ami);
            accountId(model.accountId);
            severityCounts(model.severityCounts);
            affectedInstances(model.affectedInstances);
        }

        public final String getAmi() {
            return ami;
        }

        public final void setAmi(String ami) {
            this.ami = ami;
        }

        @Override
        public final Builder ami(String ami) {
            this.ami = ami;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public final Long getAffectedInstances() {
            return affectedInstances;
        }

        public final void setAffectedInstances(Long affectedInstances) {
            this.affectedInstances = affectedInstances;
        }

        @Override
        public final Builder affectedInstances(Long affectedInstances) {
            this.affectedInstances = affectedInstances;
            return this;
        }

        @Override
        public AmiAggregationResponse build() {
            return new AmiAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
