/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata about tasks where an image was in use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsMetadataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsMetadataDetails.Builder, AwsEcsMetadataDetails> {
    private static final SdkField<String> DETAILS_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detailsGroup").getter(getter(AwsEcsMetadataDetails::detailsGroup)).setter(setter(Builder::detailsGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailsGroup").build()).build();

    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskDefinitionArn").getter(getter(AwsEcsMetadataDetails::taskDefinitionArn))
            .setter(setter(Builder::taskDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILS_GROUP_FIELD,
            TASK_DEFINITION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String detailsGroup;

    private final String taskDefinitionArn;

    private AwsEcsMetadataDetails(BuilderImpl builder) {
        this.detailsGroup = builder.detailsGroup;
        this.taskDefinitionArn = builder.taskDefinitionArn;
    }

    /**
     * <p>
     * The details group information for a task in a cluster.
     * </p>
     * 
     * @return The details group information for a task in a cluster.
     */
    public final String detailsGroup() {
        return detailsGroup;
    }

    /**
     * <p>
     * The task definition ARN.
     * </p>
     * 
     * @return The task definition ARN.
     */
    public final String taskDefinitionArn() {
        return taskDefinitionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detailsGroup());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinitionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsMetadataDetails)) {
            return false;
        }
        AwsEcsMetadataDetails other = (AwsEcsMetadataDetails) obj;
        return Objects.equals(detailsGroup(), other.detailsGroup())
                && Objects.equals(taskDefinitionArn(), other.taskDefinitionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsMetadataDetails").add("DetailsGroup", detailsGroup())
                .add("TaskDefinitionArn", taskDefinitionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detailsGroup":
            return Optional.ofNullable(clazz.cast(detailsGroup()));
        case "taskDefinitionArn":
            return Optional.ofNullable(clazz.cast(taskDefinitionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("detailsGroup", DETAILS_GROUP_FIELD);
        map.put("taskDefinitionArn", TASK_DEFINITION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsMetadataDetails, T> g) {
        return obj -> g.apply((AwsEcsMetadataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsMetadataDetails> {
        /**
         * <p>
         * The details group information for a task in a cluster.
         * </p>
         * 
         * @param detailsGroup
         *        The details group information for a task in a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailsGroup(String detailsGroup);

        /**
         * <p>
         * The task definition ARN.
         * </p>
         * 
         * @param taskDefinitionArn
         *        The task definition ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinitionArn(String taskDefinitionArn);
    }

    static final class BuilderImpl implements Builder {
        private String detailsGroup;

        private String taskDefinitionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsMetadataDetails model) {
            detailsGroup(model.detailsGroup);
            taskDefinitionArn(model.taskDefinitionArn);
        }

        public final String getDetailsGroup() {
            return detailsGroup;
        }

        public final void setDetailsGroup(String detailsGroup) {
            this.detailsGroup = detailsGroup;
        }

        @Override
        public final Builder detailsGroup(String detailsGroup) {
            this.detailsGroup = detailsGroup;
            return this;
        }

        public final String getTaskDefinitionArn() {
            return taskDefinitionArn;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        @Override
        public AwsEcsMetadataDetails build() {
            return new AwsEcsMetadataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
