/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about the Amazon Web Services Lambda function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsLambdaFunctionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsLambdaFunctionDetails.Builder, AwsLambdaFunctionDetails> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("functionName").getter(getter(AwsLambdaFunctionDetails::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runtime")
            .getter(getter(AwsLambdaFunctionDetails::runtimeAsString)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()).build();

    private static final SdkField<String> CODE_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeSha256").getter(getter(AwsLambdaFunctionDetails::codeSha256)).setter(setter(Builder::codeSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeSha256").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(AwsLambdaFunctionDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(AwsLambdaFunctionDetails::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<List<String>> LAYERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("layers")
            .getter(getter(AwsLambdaFunctionDetails::layers))
            .setter(setter(Builder::layers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LambdaVpcConfig> VPC_CONFIG_FIELD = SdkField
            .<LambdaVpcConfig> builder(MarshallingType.SDK_POJO).memberName("vpcConfig")
            .getter(getter(AwsLambdaFunctionDetails::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(LambdaVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageType").getter(getter(AwsLambdaFunctionDetails::packageTypeAsString))
            .setter(setter(Builder::packageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageType").build()).build();

    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("architectures")
            .getter(getter(AwsLambdaFunctionDetails::architecturesAsStrings))
            .setter(setter(Builder::architecturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(AwsLambdaFunctionDetails::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            RUNTIME_FIELD, CODE_SHA256_FIELD, VERSION_FIELD, EXECUTION_ROLE_ARN_FIELD, LAYERS_FIELD, VPC_CONFIG_FIELD,
            PACKAGE_TYPE_FIELD, ARCHITECTURES_FIELD, LAST_MODIFIED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String functionName;

    private final String runtime;

    private final String codeSha256;

    private final String version;

    private final String executionRoleArn;

    private final List<String> layers;

    private final LambdaVpcConfig vpcConfig;

    private final String packageType;

    private final List<String> architectures;

    private final Instant lastModifiedAt;

    private AwsLambdaFunctionDetails(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.runtime = builder.runtime;
        this.codeSha256 = builder.codeSha256;
        this.version = builder.version;
        this.executionRoleArn = builder.executionRoleArn;
        this.layers = builder.layers;
        this.vpcConfig = builder.vpcConfig;
        this.packageType = builder.packageType;
        this.architectures = builder.architectures;
        this.lastModifiedAt = builder.lastModifiedAt;
    }

    /**
     * <p>
     * The name of the Amazon Web Services Lambda function.
     * </p>
     * 
     * @return The name of the Amazon Web Services Lambda function.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The runtime environment for the Amazon Web Services Lambda function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The runtime environment for the Amazon Web Services Lambda function.
     * @see Runtime
     */
    public final Runtime runtime() {
        return Runtime.fromValue(runtime);
    }

    /**
     * <p>
     * The runtime environment for the Amazon Web Services Lambda function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The runtime environment for the Amazon Web Services Lambda function.
     * @see Runtime
     */
    public final String runtimeAsString() {
        return runtime;
    }

    /**
     * <p>
     * The SHA256 hash of the Amazon Web Services Lambda function's deployment package.
     * </p>
     * 
     * @return The SHA256 hash of the Amazon Web Services Lambda function's deployment package.
     */
    public final String codeSha256() {
        return codeSha256;
    }

    /**
     * <p>
     * The version of the Amazon Web Services Lambda function.
     * </p>
     * 
     * @return The version of the Amazon Web Services Lambda function.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The Amazon Web Services Lambda function's execution role.
     * </p>
     * 
     * @return The Amazon Web Services Lambda function's execution role.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Layers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLayers() {
        return layers != null && !(layers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Lambda function's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>. A Lambda function can
     * have up to five layers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLayers} method.
     * </p>
     * 
     * @return The Amazon Web Services Lambda function's <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>. A Lambda
     *         function can have up to five layers.
     */
    public final List<String> layers() {
        return layers;
    }

    /**
     * <p>
     * The Amazon Web Services Lambda function's networking configuration.
     * </p>
     * 
     * @return The Amazon Web Services Lambda function's networking configuration.
     */
    public final LambdaVpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip
     * file archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
     *         for .zip file archive.
     * @see PackageType
     */
    public final PackageType packageType() {
        return PackageType.fromValue(packageType);
    }

    /**
     * <p>
     * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for .zip
     * file archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
     *         for .zip file archive.
     * @see PackageType
     */
    public final String packageTypeAsString() {
        return packageType;
    }

    /**
     * <p>
     * The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture is a string
     * array with one of the valid values. The default architecture value is <code>x86_64</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectures} method.
     * </p>
     * 
     * @return The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture is a
     *         string array with one of the valid values. The default architecture value is <code>x86_64</code>.
     */
    public final List<Architecture> architectures() {
        return ArchitectureListCopier.copyStringToEnum(architectures);
    }

    /**
     * For responses, this returns true if the service returned a value for the Architectures property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArchitectures() {
        return architectures != null && !(architectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture is a string
     * array with one of the valid values. The default architecture value is <code>x86_64</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectures} method.
     * </p>
     * 
     * @return The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture is a
     *         string array with one of the valid values. The default architecture value is <code>x86_64</code>.
     */
    public final List<String> architecturesAsStrings() {
        return architectures;
    }

    /**
     * <p>
     * The date and time that a user last updated the configuration, in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>
     * </p>
     * 
     * @return The date and time that a user last updated the configuration, in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasLayers() ? layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasArchitectures() ? architecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLambdaFunctionDetails)) {
            return false;
        }
        AwsLambdaFunctionDetails other = (AwsLambdaFunctionDetails) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(runtimeAsString(), other.runtimeAsString())
                && Objects.equals(codeSha256(), other.codeSha256()) && Objects.equals(version(), other.version())
                && Objects.equals(executionRoleArn(), other.executionRoleArn()) && hasLayers() == other.hasLayers()
                && Objects.equals(layers(), other.layers()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(packageTypeAsString(), other.packageTypeAsString())
                && hasArchitectures() == other.hasArchitectures()
                && Objects.equals(architecturesAsStrings(), other.architecturesAsStrings())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsLambdaFunctionDetails").add("FunctionName", functionName()).add("Runtime", runtimeAsString())
                .add("CodeSha256", codeSha256()).add("Version", version()).add("ExecutionRoleArn", executionRoleArn())
                .add("Layers", hasLayers() ? layers() : null).add("VpcConfig", vpcConfig())
                .add("PackageType", packageTypeAsString())
                .add("Architectures", hasArchitectures() ? architecturesAsStrings() : null)
                .add("LastModifiedAt", lastModifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "functionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "runtime":
            return Optional.ofNullable(clazz.cast(runtimeAsString()));
        case "codeSha256":
            return Optional.ofNullable(clazz.cast(codeSha256()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "layers":
            return Optional.ofNullable(clazz.cast(layers()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "packageType":
            return Optional.ofNullable(clazz.cast(packageTypeAsString()));
        case "architectures":
            return Optional.ofNullable(clazz.cast(architecturesAsStrings()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("functionName", FUNCTION_NAME_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        map.put("codeSha256", CODE_SHA256_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("layers", LAYERS_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("packageType", PACKAGE_TYPE_FIELD);
        map.put("architectures", ARCHITECTURES_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsLambdaFunctionDetails, T> g) {
        return obj -> g.apply((AwsLambdaFunctionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsLambdaFunctionDetails> {
        /**
         * <p>
         * The name of the Amazon Web Services Lambda function.
         * </p>
         * 
         * @param functionName
         *        The name of the Amazon Web Services Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The runtime environment for the Amazon Web Services Lambda function.
         * </p>
         * 
         * @param runtime
         *        The runtime environment for the Amazon Web Services Lambda function.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * The runtime environment for the Amazon Web Services Lambda function.
         * </p>
         * 
         * @param runtime
         *        The runtime environment for the Amazon Web Services Lambda function.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(Runtime runtime);

        /**
         * <p>
         * The SHA256 hash of the Amazon Web Services Lambda function's deployment package.
         * </p>
         * 
         * @param codeSha256
         *        The SHA256 hash of the Amazon Web Services Lambda function's deployment package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSha256(String codeSha256);

        /**
         * <p>
         * The version of the Amazon Web Services Lambda function.
         * </p>
         * 
         * @param version
         *        The version of the Amazon Web Services Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The Amazon Web Services Lambda function's execution role.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Web Services Lambda function's execution role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The Amazon Web Services Lambda function's <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>. A Lambda function
         * can have up to five layers.
         * </p>
         * 
         * @param layers
         *        The Amazon Web Services Lambda function's <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>. A Lambda
         *        function can have up to five layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<String> layers);

        /**
         * <p>
         * The Amazon Web Services Lambda function's <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>. A Lambda function
         * can have up to five layers.
         * </p>
         * 
         * @param layers
         *        The Amazon Web Services Lambda function's <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html"> layers</a>. A Lambda
         *        function can have up to five layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(String... layers);

        /**
         * <p>
         * The Amazon Web Services Lambda function's networking configuration.
         * </p>
         * 
         * @param vpcConfig
         *        The Amazon Web Services Lambda function's networking configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(LambdaVpcConfig vpcConfig);

        /**
         * <p>
         * The Amazon Web Services Lambda function's networking configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaVpcConfig.Builder} avoiding the
         * need to create one manually via {@link LambdaVpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaVpcConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfig(LambdaVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link LambdaVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(LambdaVpcConfig)
         */
        default Builder vpcConfig(Consumer<LambdaVpcConfig.Builder> vpcConfig) {
            return vpcConfig(LambdaVpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for
         * .zip file archive.
         * </p>
         * 
         * @param packageType
         *        The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
         *        for .zip file archive.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(String packageType);

        /**
         * <p>
         * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for
         * .zip file archive.
         * </p>
         * 
         * @param packageType
         *        The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
         *        for .zip file archive.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(PackageType packageType);

        /**
         * <p>
         * The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture is a
         * string array with one of the valid values. The default architecture value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture
         *        is a string array with one of the valid values. The default architecture value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecturesWithStrings(Collection<String> architectures);

        /**
         * <p>
         * The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture is a
         * string array with one of the valid values. The default architecture value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture
         *        is a string array with one of the valid values. The default architecture value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecturesWithStrings(String... architectures);

        /**
         * <p>
         * The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture is a
         * string array with one of the valid values. The default architecture value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture
         *        is a string array with one of the valid values. The default architecture value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(Collection<Architecture> architectures);

        /**
         * <p>
         * The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture is a
         * string array with one of the valid values. The default architecture value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture
         *        is a string array with one of the valid values. The default architecture value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(Architecture... architectures);

        /**
         * <p>
         * The date and time that a user last updated the configuration, in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>
         * </p>
         * 
         * @param lastModifiedAt
         *        The date and time that a user last updated the configuration, in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601 format</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);
    }

    static final class BuilderImpl implements Builder {
        private String functionName;

        private String runtime;

        private String codeSha256;

        private String version;

        private String executionRoleArn;

        private List<String> layers = DefaultSdkAutoConstructList.getInstance();

        private LambdaVpcConfig vpcConfig;

        private String packageType;

        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();

        private Instant lastModifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLambdaFunctionDetails model) {
            functionName(model.functionName);
            runtime(model.runtime);
            codeSha256(model.codeSha256);
            version(model.version);
            executionRoleArn(model.executionRoleArn);
            layers(model.layers);
            vpcConfig(model.vpcConfig);
            packageType(model.packageType);
            architecturesWithStrings(model.architectures);
            lastModifiedAt(model.lastModifiedAt);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getRuntime() {
            return runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final String getCodeSha256() {
            return codeSha256;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final Collection<String> getLayers() {
            if (layers instanceof SdkAutoConstructList) {
                return null;
            }
            return layers;
        }

        public final void setLayers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
        }

        @Override
        public final Builder layers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(String... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        public final LambdaVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(LambdaVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(LambdaVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getPackageType() {
            return packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final Collection<String> getArchitectures() {
            if (architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return architectures;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
        }

        @Override
        public final Builder architecturesWithStrings(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architecturesWithStrings(String... architectures) {
            architecturesWithStrings(Arrays.asList(architectures));
            return this;
        }

        @Override
        public final Builder architectures(Collection<Architecture> architectures) {
            this.architectures = ArchitectureListCopier.copyEnumToString(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(Architecture... architectures) {
            architectures(Arrays.asList(architectures));
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        @Override
        public AwsLambdaFunctionDetails build() {
            return new AwsLambdaFunctionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
