/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateCodeSecurityScanConfigurationResponse extends Inspector2Response
        implements
        ToCopyableBuilder<BatchAssociateCodeSecurityScanConfigurationResponse.Builder, BatchAssociateCodeSecurityScanConfigurationResponse> {
    private static final SdkField<List<FailedAssociationResult>> FAILED_ASSOCIATIONS_FIELD = SdkField
            .<List<FailedAssociationResult>> builder(MarshallingType.LIST)
            .memberName("failedAssociations")
            .getter(getter(BatchAssociateCodeSecurityScanConfigurationResponse::failedAssociations))
            .setter(setter(Builder::failedAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedAssociationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedAssociationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SuccessfulAssociationResult>> SUCCESSFUL_ASSOCIATIONS_FIELD = SdkField
            .<List<SuccessfulAssociationResult>> builder(MarshallingType.LIST)
            .memberName("successfulAssociations")
            .getter(getter(BatchAssociateCodeSecurityScanConfigurationResponse::successfulAssociations))
            .setter(setter(Builder::successfulAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SuccessfulAssociationResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(SuccessfulAssociationResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_ASSOCIATIONS_FIELD,
            SUCCESSFUL_ASSOCIATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FailedAssociationResult> failedAssociations;

    private final List<SuccessfulAssociationResult> successfulAssociations;

    private BatchAssociateCodeSecurityScanConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.failedAssociations = builder.failedAssociations;
        this.successfulAssociations = builder.successfulAssociations;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedAssociations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedAssociations() {
        return failedAssociations != null && !(failedAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of any code repositories that failed to be associated with the scan configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedAssociations} method.
     * </p>
     * 
     * @return Details of any code repositories that failed to be associated with the scan configuration.
     */
    public final List<FailedAssociationResult> failedAssociations() {
        return failedAssociations;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessfulAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSuccessfulAssociations() {
        return successfulAssociations != null && !(successfulAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of code repositories that were successfully associated with the scan configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessfulAssociations} method.
     * </p>
     * 
     * @return Details of code repositories that were successfully associated with the scan configuration.
     */
    public final List<SuccessfulAssociationResult> successfulAssociations() {
        return successfulAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedAssociations() ? failedAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessfulAssociations() ? successfulAssociations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateCodeSecurityScanConfigurationResponse)) {
            return false;
        }
        BatchAssociateCodeSecurityScanConfigurationResponse other = (BatchAssociateCodeSecurityScanConfigurationResponse) obj;
        return hasFailedAssociations() == other.hasFailedAssociations()
                && Objects.equals(failedAssociations(), other.failedAssociations())
                && hasSuccessfulAssociations() == other.hasSuccessfulAssociations()
                && Objects.equals(successfulAssociations(), other.successfulAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateCodeSecurityScanConfigurationResponse")
                .add("FailedAssociations", hasFailedAssociations() ? failedAssociations() : null)
                .add("SuccessfulAssociations", hasSuccessfulAssociations() ? successfulAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failedAssociations":
            return Optional.ofNullable(clazz.cast(failedAssociations()));
        case "successfulAssociations":
            return Optional.ofNullable(clazz.cast(successfulAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("failedAssociations", FAILED_ASSOCIATIONS_FIELD);
        map.put("successfulAssociations", SUCCESSFUL_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateCodeSecurityScanConfigurationResponse, T> g) {
        return obj -> g.apply((BatchAssociateCodeSecurityScanConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateCodeSecurityScanConfigurationResponse> {
        /**
         * <p>
         * Details of any code repositories that failed to be associated with the scan configuration.
         * </p>
         * 
         * @param failedAssociations
         *        Details of any code repositories that failed to be associated with the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedAssociations(Collection<FailedAssociationResult> failedAssociations);

        /**
         * <p>
         * Details of any code repositories that failed to be associated with the scan configuration.
         * </p>
         * 
         * @param failedAssociations
         *        Details of any code repositories that failed to be associated with the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedAssociations(FailedAssociationResult... failedAssociations);

        /**
         * <p>
         * Details of any code repositories that failed to be associated with the scan configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.FailedAssociationResult.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.FailedAssociationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.FailedAssociationResult.Builder#build()} is called
         * immediately and its result is passed to {@link #failedAssociations(List<FailedAssociationResult>)}.
         * 
         * @param failedAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.FailedAssociationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedAssociations(java.util.Collection<FailedAssociationResult>)
         */
        Builder failedAssociations(Consumer<FailedAssociationResult.Builder>... failedAssociations);

        /**
         * <p>
         * Details of code repositories that were successfully associated with the scan configuration.
         * </p>
         * 
         * @param successfulAssociations
         *        Details of code repositories that were successfully associated with the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulAssociations(Collection<SuccessfulAssociationResult> successfulAssociations);

        /**
         * <p>
         * Details of code repositories that were successfully associated with the scan configuration.
         * </p>
         * 
         * @param successfulAssociations
         *        Details of code repositories that were successfully associated with the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfulAssociations(SuccessfulAssociationResult... successfulAssociations);

        /**
         * <p>
         * Details of code repositories that were successfully associated with the scan configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.SuccessfulAssociationResult.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.SuccessfulAssociationResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.SuccessfulAssociationResult.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #successfulAssociations(List<SuccessfulAssociationResult>)}.
         * 
         * @param successfulAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.SuccessfulAssociationResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfulAssociations(java.util.Collection<SuccessfulAssociationResult>)
         */
        Builder successfulAssociations(Consumer<SuccessfulAssociationResult.Builder>... successfulAssociations);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private List<FailedAssociationResult> failedAssociations = DefaultSdkAutoConstructList.getInstance();

        private List<SuccessfulAssociationResult> successfulAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateCodeSecurityScanConfigurationResponse model) {
            super(model);
            failedAssociations(model.failedAssociations);
            successfulAssociations(model.successfulAssociations);
        }

        public final List<FailedAssociationResult.Builder> getFailedAssociations() {
            List<FailedAssociationResult.Builder> result = FailedAssociationResultListCopier
                    .copyToBuilder(this.failedAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAssociations(Collection<FailedAssociationResult.BuilderImpl> failedAssociations) {
            this.failedAssociations = FailedAssociationResultListCopier.copyFromBuilder(failedAssociations);
        }

        @Override
        public final Builder failedAssociations(Collection<FailedAssociationResult> failedAssociations) {
            this.failedAssociations = FailedAssociationResultListCopier.copy(failedAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAssociations(FailedAssociationResult... failedAssociations) {
            failedAssociations(Arrays.asList(failedAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAssociations(Consumer<FailedAssociationResult.Builder>... failedAssociations) {
            failedAssociations(Stream.of(failedAssociations).map(c -> FailedAssociationResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SuccessfulAssociationResult.Builder> getSuccessfulAssociations() {
            List<SuccessfulAssociationResult.Builder> result = SuccessfulAssociationResultListCopier
                    .copyToBuilder(this.successfulAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulAssociations(Collection<SuccessfulAssociationResult.BuilderImpl> successfulAssociations) {
            this.successfulAssociations = SuccessfulAssociationResultListCopier.copyFromBuilder(successfulAssociations);
        }

        @Override
        public final Builder successfulAssociations(Collection<SuccessfulAssociationResult> successfulAssociations) {
            this.successfulAssociations = SuccessfulAssociationResultListCopier.copy(successfulAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulAssociations(SuccessfulAssociationResult... successfulAssociations) {
            successfulAssociations(Arrays.asList(successfulAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulAssociations(Consumer<SuccessfulAssociationResult.Builder>... successfulAssociations) {
            successfulAssociations(Stream.of(successfulAssociations)
                    .map(c -> SuccessfulAssociationResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAssociateCodeSecurityScanConfigurationResponse build() {
            return new BatchAssociateCodeSecurityScanConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
