/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetFreeTrialInfoResponse extends Inspector2Response implements
        ToCopyableBuilder<BatchGetFreeTrialInfoResponse.Builder, BatchGetFreeTrialInfoResponse> {
    private static final SdkField<List<FreeTrialAccountInfo>> ACCOUNTS_FIELD = SdkField
            .<List<FreeTrialAccountInfo>> builder(MarshallingType.LIST)
            .memberName("accounts")
            .getter(getter(BatchGetFreeTrialInfoResponse::accounts))
            .setter(setter(Builder::accounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FreeTrialAccountInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(FreeTrialAccountInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FreeTrialInfoError>> FAILED_ACCOUNTS_FIELD = SdkField
            .<List<FreeTrialInfoError>> builder(MarshallingType.LIST)
            .memberName("failedAccounts")
            .getter(getter(BatchGetFreeTrialInfoResponse::failedAccounts))
            .setter(setter(Builder::failedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FreeTrialInfoError> builder(MarshallingType.SDK_POJO)
                                            .constructor(FreeTrialInfoError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNTS_FIELD,
            FAILED_ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FreeTrialAccountInfo> accounts;

    private final List<FreeTrialInfoError> failedAccounts;

    private BatchGetFreeTrialInfoResponse(BuilderImpl builder) {
        super(builder);
        this.accounts = builder.accounts;
        this.failedAccounts = builder.failedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Accounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccounts() {
        return accounts != null && !(accounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccounts} method.
     * </p>
     * 
     * @return An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
     */
    public final List<FreeTrialAccountInfo> accounts() {
        return accounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedAccounts() {
        return failedAccounts != null && !(failedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects detailing any accounts that free trial data could not be returned for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedAccounts} method.
     * </p>
     * 
     * @return An array of objects detailing any accounts that free trial data could not be returned for.
     */
    public final List<FreeTrialInfoError> failedAccounts() {
        return failedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccounts() ? accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedAccounts() ? failedAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFreeTrialInfoResponse)) {
            return false;
        }
        BatchGetFreeTrialInfoResponse other = (BatchGetFreeTrialInfoResponse) obj;
        return hasAccounts() == other.hasAccounts() && Objects.equals(accounts(), other.accounts())
                && hasFailedAccounts() == other.hasFailedAccounts() && Objects.equals(failedAccounts(), other.failedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetFreeTrialInfoResponse").add("Accounts", hasAccounts() ? accounts() : null)
                .add("FailedAccounts", hasFailedAccounts() ? failedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accounts":
            return Optional.ofNullable(clazz.cast(accounts()));
        case "failedAccounts":
            return Optional.ofNullable(clazz.cast(failedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accounts", ACCOUNTS_FIELD);
        map.put("failedAccounts", FAILED_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFreeTrialInfoResponse, T> g) {
        return obj -> g.apply((BatchGetFreeTrialInfoResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Response.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetFreeTrialInfoResponse> {
        /**
         * <p>
         * An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
         * </p>
         * 
         * @param accounts
         *        An array of objects that provide Amazon Inspector free trial details for each of the requested
         *        accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(Collection<FreeTrialAccountInfo> accounts);

        /**
         * <p>
         * An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
         * </p>
         * 
         * @param accounts
         *        An array of objects that provide Amazon Inspector free trial details for each of the requested
         *        accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accounts(FreeTrialAccountInfo... accounts);

        /**
         * <p>
         * An array of objects that provide Amazon Inspector free trial details for each of the requested accounts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.FreeTrialAccountInfo.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.FreeTrialAccountInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.FreeTrialAccountInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #accounts(List<FreeTrialAccountInfo>)}.
         * 
         * @param accounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.FreeTrialAccountInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accounts(java.util.Collection<FreeTrialAccountInfo>)
         */
        Builder accounts(Consumer<FreeTrialAccountInfo.Builder>... accounts);

        /**
         * <p>
         * An array of objects detailing any accounts that free trial data could not be returned for.
         * </p>
         * 
         * @param failedAccounts
         *        An array of objects detailing any accounts that free trial data could not be returned for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedAccounts(Collection<FreeTrialInfoError> failedAccounts);

        /**
         * <p>
         * An array of objects detailing any accounts that free trial data could not be returned for.
         * </p>
         * 
         * @param failedAccounts
         *        An array of objects detailing any accounts that free trial data could not be returned for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedAccounts(FreeTrialInfoError... failedAccounts);

        /**
         * <p>
         * An array of objects detailing any accounts that free trial data could not be returned for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.FreeTrialInfoError.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.FreeTrialInfoError#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.FreeTrialInfoError.Builder#build()} is called
         * immediately and its result is passed to {@link #failedAccounts(List<FreeTrialInfoError>)}.
         * 
         * @param failedAccounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.FreeTrialInfoError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedAccounts(java.util.Collection<FreeTrialInfoError>)
         */
        Builder failedAccounts(Consumer<FreeTrialInfoError.Builder>... failedAccounts);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private List<FreeTrialAccountInfo> accounts = DefaultSdkAutoConstructList.getInstance();

        private List<FreeTrialInfoError> failedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFreeTrialInfoResponse model) {
            super(model);
            accounts(model.accounts);
            failedAccounts(model.failedAccounts);
        }

        public final List<FreeTrialAccountInfo.Builder> getAccounts() {
            List<FreeTrialAccountInfo.Builder> result = FreeTrialAccountInfoListCopier.copyToBuilder(this.accounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccounts(Collection<FreeTrialAccountInfo.BuilderImpl> accounts) {
            this.accounts = FreeTrialAccountInfoListCopier.copyFromBuilder(accounts);
        }

        @Override
        public final Builder accounts(Collection<FreeTrialAccountInfo> accounts) {
            this.accounts = FreeTrialAccountInfoListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(FreeTrialAccountInfo... accounts) {
            accounts(Arrays.asList(accounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(Consumer<FreeTrialAccountInfo.Builder>... accounts) {
            accounts(Stream.of(accounts).map(c -> FreeTrialAccountInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FreeTrialInfoError.Builder> getFailedAccounts() {
            List<FreeTrialInfoError.Builder> result = FreeTrialInfoErrorListCopier.copyToBuilder(this.failedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAccounts(Collection<FreeTrialInfoError.BuilderImpl> failedAccounts) {
            this.failedAccounts = FreeTrialInfoErrorListCopier.copyFromBuilder(failedAccounts);
        }

        @Override
        public final Builder failedAccounts(Collection<FreeTrialInfoError> failedAccounts) {
            this.failedAccounts = FreeTrialInfoErrorListCopier.copy(failedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAccounts(FreeTrialInfoError... failedAccounts) {
            failedAccounts(Arrays.asList(failedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAccounts(Consumer<FreeTrialInfoError.Builder>... failedAccounts) {
            failedAccounts(Stream.of(failedAccounts).map(c -> FreeTrialInfoError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetFreeTrialInfoResponse build() {
            return new BatchGetFreeTrialInfoResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
