/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A CIS check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisCheckAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<CisCheckAggregation.Builder, CisCheckAggregation> {
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanArn").getter(getter(CisCheckAggregation::scanArn)).setter(setter(Builder::scanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()).build();

    private static final SdkField<String> CHECK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checkId").getter(getter(CisCheckAggregation::checkId)).setter(setter(Builder::checkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(CisCheckAggregation::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> CHECK_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checkDescription").getter(getter(CisCheckAggregation::checkDescription))
            .setter(setter(Builder::checkDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkDescription").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("level")
            .getter(getter(CisCheckAggregation::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(CisCheckAggregation::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<StatusCounts> STATUS_COUNTS_FIELD = SdkField.<StatusCounts> builder(MarshallingType.SDK_POJO)
            .memberName("statusCounts").getter(getter(CisCheckAggregation::statusCounts)).setter(setter(Builder::statusCounts))
            .constructor(StatusCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCounts").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(CisCheckAggregation::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ARN_FIELD,
            CHECK_ID_FIELD, TITLE_FIELD, CHECK_DESCRIPTION_FIELD, LEVEL_FIELD, ACCOUNT_ID_FIELD, STATUS_COUNTS_FIELD,
            PLATFORM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scanArn;

    private final String checkId;

    private final String title;

    private final String checkDescription;

    private final String level;

    private final String accountId;

    private final StatusCounts statusCounts;

    private final String platform;

    private CisCheckAggregation(BuilderImpl builder) {
        this.scanArn = builder.scanArn;
        this.checkId = builder.checkId;
        this.title = builder.title;
        this.checkDescription = builder.checkDescription;
        this.level = builder.level;
        this.accountId = builder.accountId;
        this.statusCounts = builder.statusCounts;
        this.platform = builder.platform;
    }

    /**
     * <p>
     * The scan ARN for the CIS check scan ARN.
     * </p>
     * 
     * @return The scan ARN for the CIS check scan ARN.
     */
    public final String scanArn() {
        return scanArn;
    }

    /**
     * <p>
     * The check ID for the CIS check.
     * </p>
     * 
     * @return The check ID for the CIS check.
     */
    public final String checkId() {
        return checkId;
    }

    /**
     * <p>
     * The CIS check title.
     * </p>
     * 
     * @return The CIS check title.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The description for the CIS check.
     * </p>
     * 
     * @return The description for the CIS check.
     */
    public final String checkDescription() {
        return checkDescription;
    }

    /**
     * <p>
     * The CIS check level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The CIS check level.
     * @see CisSecurityLevel
     */
    public final CisSecurityLevel level() {
        return CisSecurityLevel.fromValue(level);
    }

    /**
     * <p>
     * The CIS check level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The CIS check level.
     * @see CisSecurityLevel
     */
    public final String levelAsString() {
        return level;
    }

    /**
     * <p>
     * The account ID for the CIS check.
     * </p>
     * 
     * @return The account ID for the CIS check.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The CIS check status counts.
     * </p>
     * 
     * @return The CIS check status counts.
     */
    public final StatusCounts statusCounts() {
        return statusCounts;
    }

    /**
     * <p>
     * The CIS check platform.
     * </p>
     * 
     * @return The CIS check platform.
     */
    public final String platform() {
        return platform;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(checkId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(checkDescription());
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(statusCounts());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisCheckAggregation)) {
            return false;
        }
        CisCheckAggregation other = (CisCheckAggregation) obj;
        return Objects.equals(scanArn(), other.scanArn()) && Objects.equals(checkId(), other.checkId())
                && Objects.equals(title(), other.title()) && Objects.equals(checkDescription(), other.checkDescription())
                && Objects.equals(levelAsString(), other.levelAsString()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(statusCounts(), other.statusCounts()) && Objects.equals(platform(), other.platform());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisCheckAggregation").add("ScanArn", scanArn()).add("CheckId", checkId()).add("Title", title())
                .add("CheckDescription", checkDescription()).add("Level", levelAsString()).add("AccountId", accountId())
                .add("StatusCounts", statusCounts()).add("Platform", platform()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanArn":
            return Optional.ofNullable(clazz.cast(scanArn()));
        case "checkId":
            return Optional.ofNullable(clazz.cast(checkId()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "checkDescription":
            return Optional.ofNullable(clazz.cast(checkDescription()));
        case "level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "statusCounts":
            return Optional.ofNullable(clazz.cast(statusCounts()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanArn", SCAN_ARN_FIELD);
        map.put("checkId", CHECK_ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("checkDescription", CHECK_DESCRIPTION_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("statusCounts", STATUS_COUNTS_FIELD);
        map.put("platform", PLATFORM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisCheckAggregation, T> g) {
        return obj -> g.apply((CisCheckAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisCheckAggregation> {
        /**
         * <p>
         * The scan ARN for the CIS check scan ARN.
         * </p>
         * 
         * @param scanArn
         *        The scan ARN for the CIS check scan ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanArn(String scanArn);

        /**
         * <p>
         * The check ID for the CIS check.
         * </p>
         * 
         * @param checkId
         *        The check ID for the CIS check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkId(String checkId);

        /**
         * <p>
         * The CIS check title.
         * </p>
         * 
         * @param title
         *        The CIS check title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description for the CIS check.
         * </p>
         * 
         * @param checkDescription
         *        The description for the CIS check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkDescription(String checkDescription);

        /**
         * <p>
         * The CIS check level.
         * </p>
         * 
         * @param level
         *        The CIS check level.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder level(String level);

        /**
         * <p>
         * The CIS check level.
         * </p>
         * 
         * @param level
         *        The CIS check level.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder level(CisSecurityLevel level);

        /**
         * <p>
         * The account ID for the CIS check.
         * </p>
         * 
         * @param accountId
         *        The account ID for the CIS check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The CIS check status counts.
         * </p>
         * 
         * @param statusCounts
         *        The CIS check status counts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCounts(StatusCounts statusCounts);

        /**
         * <p>
         * The CIS check status counts.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatusCounts.Builder} avoiding the need
         * to create one manually via {@link StatusCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #statusCounts(StatusCounts)}.
         * 
         * @param statusCounts
         *        a consumer that will call methods on {@link StatusCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusCounts(StatusCounts)
         */
        default Builder statusCounts(Consumer<StatusCounts.Builder> statusCounts) {
            return statusCounts(StatusCounts.builder().applyMutation(statusCounts).build());
        }

        /**
         * <p>
         * The CIS check platform.
         * </p>
         * 
         * @param platform
         *        The CIS check platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);
    }

    static final class BuilderImpl implements Builder {
        private String scanArn;

        private String checkId;

        private String title;

        private String checkDescription;

        private String level;

        private String accountId;

        private StatusCounts statusCounts;

        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(CisCheckAggregation model) {
            scanArn(model.scanArn);
            checkId(model.checkId);
            title(model.title);
            checkDescription(model.checkDescription);
            level(model.level);
            accountId(model.accountId);
            statusCounts(model.statusCounts);
            platform(model.platform);
        }

        public final String getScanArn() {
            return scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final String getCheckId() {
            return checkId;
        }

        public final void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        @Override
        public final Builder checkId(String checkId) {
            this.checkId = checkId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getCheckDescription() {
            return checkDescription;
        }

        public final void setCheckDescription(String checkDescription) {
            this.checkDescription = checkDescription;
        }

        @Override
        public final Builder checkDescription(String checkDescription) {
            this.checkDescription = checkDescription;
            return this;
        }

        public final String getLevel() {
            return level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(CisSecurityLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final StatusCounts.Builder getStatusCounts() {
            return statusCounts != null ? statusCounts.toBuilder() : null;
        }

        public final void setStatusCounts(StatusCounts.BuilderImpl statusCounts) {
            this.statusCounts = statusCounts != null ? statusCounts.build() : null;
        }

        @Override
        public final Builder statusCounts(StatusCounts statusCounts) {
            this.statusCounts = statusCounts;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public CisCheckAggregation build() {
            return new CisCheckAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
