/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CIS date filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisDateFilter implements SdkPojo, Serializable, ToCopyableBuilder<CisDateFilter.Builder, CisDateFilter> {
    private static final SdkField<Instant> EARLIEST_SCAN_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("earliestScanStartTime").getter(getter(CisDateFilter::earliestScanStartTime))
            .setter(setter(Builder::earliestScanStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("earliestScanStartTime").build())
            .build();

    private static final SdkField<Instant> LATEST_SCAN_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("latestScanStartTime").getter(getter(CisDateFilter::latestScanStartTime))
            .setter(setter(Builder::latestScanStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestScanStartTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EARLIEST_SCAN_START_TIME_FIELD, LATEST_SCAN_START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant earliestScanStartTime;

    private final Instant latestScanStartTime;

    private CisDateFilter(BuilderImpl builder) {
        this.earliestScanStartTime = builder.earliestScanStartTime;
        this.latestScanStartTime = builder.latestScanStartTime;
    }

    /**
     * <p>
     * The CIS date filter's earliest scan start time.
     * </p>
     * 
     * @return The CIS date filter's earliest scan start time.
     */
    public final Instant earliestScanStartTime() {
        return earliestScanStartTime;
    }

    /**
     * <p>
     * The CIS date filter's latest scan start time.
     * </p>
     * 
     * @return The CIS date filter's latest scan start time.
     */
    public final Instant latestScanStartTime() {
        return latestScanStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(earliestScanStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestScanStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisDateFilter)) {
            return false;
        }
        CisDateFilter other = (CisDateFilter) obj;
        return Objects.equals(earliestScanStartTime(), other.earliestScanStartTime())
                && Objects.equals(latestScanStartTime(), other.latestScanStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisDateFilter").add("EarliestScanStartTime", earliestScanStartTime())
                .add("LatestScanStartTime", latestScanStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "earliestScanStartTime":
            return Optional.ofNullable(clazz.cast(earliestScanStartTime()));
        case "latestScanStartTime":
            return Optional.ofNullable(clazz.cast(latestScanStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("earliestScanStartTime", EARLIEST_SCAN_START_TIME_FIELD);
        map.put("latestScanStartTime", LATEST_SCAN_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisDateFilter, T> g) {
        return obj -> g.apply((CisDateFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisDateFilter> {
        /**
         * <p>
         * The CIS date filter's earliest scan start time.
         * </p>
         * 
         * @param earliestScanStartTime
         *        The CIS date filter's earliest scan start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earliestScanStartTime(Instant earliestScanStartTime);

        /**
         * <p>
         * The CIS date filter's latest scan start time.
         * </p>
         * 
         * @param latestScanStartTime
         *        The CIS date filter's latest scan start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestScanStartTime(Instant latestScanStartTime);
    }

    static final class BuilderImpl implements Builder {
        private Instant earliestScanStartTime;

        private Instant latestScanStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CisDateFilter model) {
            earliestScanStartTime(model.earliestScanStartTime);
            latestScanStartTime(model.latestScanStartTime);
        }

        public final Instant getEarliestScanStartTime() {
            return earliestScanStartTime;
        }

        public final void setEarliestScanStartTime(Instant earliestScanStartTime) {
            this.earliestScanStartTime = earliestScanStartTime;
        }

        @Override
        public final Builder earliestScanStartTime(Instant earliestScanStartTime) {
            this.earliestScanStartTime = earliestScanStartTime;
            return this;
        }

        public final Instant getLatestScanStartTime() {
            return latestScanStartTime;
        }

        public final void setLatestScanStartTime(Instant latestScanStartTime) {
            this.latestScanStartTime = latestScanStartTime;
        }

        @Override
        public final Builder latestScanStartTime(Instant latestScanStartTime) {
            this.latestScanStartTime = latestScanStartTime;
            return this;
        }

        @Override
        public CisDateFilter build() {
            return new CisDateFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
