/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CIS scan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisScan implements SdkPojo, Serializable, ToCopyableBuilder<CisScan.Builder, CisScan> {
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanArn").getter(getter(CisScan::scanArn)).setter(setter(Builder::scanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()).build();

    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanConfigurationArn").getter(getter(CisScan::scanConfigurationArn))
            .setter(setter(Builder::scanConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CisScan::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanName").getter(getter(CisScan::scanName)).setter(setter(Builder::scanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()).build();

    private static final SdkField<Instant> SCAN_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("scanDate").getter(getter(CisScan::scanDate)).setter(setter(Builder::scanDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanDate").build()).build();

    private static final SdkField<Integer> FAILED_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("failedChecks").getter(getter(CisScan::failedChecks)).setter(setter(Builder::failedChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedChecks").build()).build();

    private static final SdkField<Integer> TOTAL_CHECKS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalChecks").getter(getter(CisScan::totalChecks)).setter(setter(Builder::totalChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalChecks").build()).build();

    private static final SdkField<CisTargets> TARGETS_FIELD = SdkField.<CisTargets> builder(MarshallingType.SDK_POJO)
            .memberName("targets").getter(getter(CisScan::targets)).setter(setter(Builder::targets))
            .constructor(CisTargets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build()).build();

    private static final SdkField<String> SCHEDULED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduledBy").getter(getter(CisScan::scheduledBy)).setter(setter(Builder::scheduledBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledBy").build()).build();

    private static final SdkField<String> SECURITY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityLevel").getter(getter(CisScan::securityLevelAsString)).setter(setter(Builder::securityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ARN_FIELD,
            SCAN_CONFIGURATION_ARN_FIELD, STATUS_FIELD, SCAN_NAME_FIELD, SCAN_DATE_FIELD, FAILED_CHECKS_FIELD,
            TOTAL_CHECKS_FIELD, TARGETS_FIELD, SCHEDULED_BY_FIELD, SECURITY_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scanArn;

    private final String scanConfigurationArn;

    private final String status;

    private final String scanName;

    private final Instant scanDate;

    private final Integer failedChecks;

    private final Integer totalChecks;

    private final CisTargets targets;

    private final String scheduledBy;

    private final String securityLevel;

    private CisScan(BuilderImpl builder) {
        this.scanArn = builder.scanArn;
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.status = builder.status;
        this.scanName = builder.scanName;
        this.scanDate = builder.scanDate;
        this.failedChecks = builder.failedChecks;
        this.totalChecks = builder.totalChecks;
        this.targets = builder.targets;
        this.scheduledBy = builder.scheduledBy;
        this.securityLevel = builder.securityLevel;
    }

    /**
     * <p>
     * The CIS scan's ARN.
     * </p>
     * 
     * @return The CIS scan's ARN.
     */
    public final String scanArn() {
        return scanArn;
    }

    /**
     * <p>
     * The CIS scan's configuration ARN.
     * </p>
     * 
     * @return The CIS scan's configuration ARN.
     */
    public final String scanConfigurationArn() {
        return scanConfigurationArn;
    }

    /**
     * <p>
     * The CIS scan's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CisScanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The CIS scan's status.
     * @see CisScanStatus
     */
    public final CisScanStatus status() {
        return CisScanStatus.fromValue(status);
    }

    /**
     * <p>
     * The CIS scan's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CisScanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The CIS scan's status.
     * @see CisScanStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The the name of the scan configuration that's associated with this scan.
     * </p>
     * 
     * @return The the name of the scan configuration that's associated with this scan.
     */
    public final String scanName() {
        return scanName;
    }

    /**
     * <p>
     * The CIS scan's date.
     * </p>
     * 
     * @return The CIS scan's date.
     */
    public final Instant scanDate() {
        return scanDate;
    }

    /**
     * <p>
     * The CIS scan's failed checks.
     * </p>
     * 
     * @return The CIS scan's failed checks.
     */
    public final Integer failedChecks() {
        return failedChecks;
    }

    /**
     * <p>
     * The CIS scan's total checks.
     * </p>
     * 
     * @return The CIS scan's total checks.
     */
    public final Integer totalChecks() {
        return totalChecks;
    }

    /**
     * <p>
     * The CIS scan's targets.
     * </p>
     * 
     * @return The CIS scan's targets.
     */
    public final CisTargets targets() {
        return targets;
    }

    /**
     * <p>
     * The account or organization that schedules the CIS scan.
     * </p>
     * 
     * @return The account or organization that schedules the CIS scan.
     */
    public final String scheduledBy() {
        return scheduledBy;
    }

    /**
     * <p>
     * The security level for the CIS scan. Security level refers to the Benchmark levels that CIS assigns to a profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityLevel}
     * will return {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityLevelAsString}.
     * </p>
     * 
     * @return The security level for the CIS scan. Security level refers to the Benchmark levels that CIS assigns to a
     *         profile.
     * @see CisSecurityLevel
     */
    public final CisSecurityLevel securityLevel() {
        return CisSecurityLevel.fromValue(securityLevel);
    }

    /**
     * <p>
     * The security level for the CIS scan. Security level refers to the Benchmark levels that CIS assigns to a profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityLevel}
     * will return {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityLevelAsString}.
     * </p>
     * 
     * @return The security level for the CIS scan. Security level refers to the Benchmark levels that CIS assigns to a
     *         profile.
     * @see CisSecurityLevel
     */
    public final String securityLevelAsString() {
        return securityLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanName());
        hashCode = 31 * hashCode + Objects.hashCode(scanDate());
        hashCode = 31 * hashCode + Objects.hashCode(failedChecks());
        hashCode = 31 * hashCode + Objects.hashCode(totalChecks());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledBy());
        hashCode = 31 * hashCode + Objects.hashCode(securityLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisScan)) {
            return false;
        }
        CisScan other = (CisScan) obj;
        return Objects.equals(scanArn(), other.scanArn()) && Objects.equals(scanConfigurationArn(), other.scanConfigurationArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(scanName(), other.scanName())
                && Objects.equals(scanDate(), other.scanDate()) && Objects.equals(failedChecks(), other.failedChecks())
                && Objects.equals(totalChecks(), other.totalChecks()) && Objects.equals(targets(), other.targets())
                && Objects.equals(scheduledBy(), other.scheduledBy())
                && Objects.equals(securityLevelAsString(), other.securityLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisScan").add("ScanArn", scanArn()).add("ScanConfigurationArn", scanConfigurationArn())
                .add("Status", statusAsString()).add("ScanName", scanName()).add("ScanDate", scanDate())
                .add("FailedChecks", failedChecks()).add("TotalChecks", totalChecks()).add("Targets", targets())
                .add("ScheduledBy", scheduledBy()).add("SecurityLevel", securityLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanArn":
            return Optional.ofNullable(clazz.cast(scanArn()));
        case "scanConfigurationArn":
            return Optional.ofNullable(clazz.cast(scanConfigurationArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "scanName":
            return Optional.ofNullable(clazz.cast(scanName()));
        case "scanDate":
            return Optional.ofNullable(clazz.cast(scanDate()));
        case "failedChecks":
            return Optional.ofNullable(clazz.cast(failedChecks()));
        case "totalChecks":
            return Optional.ofNullable(clazz.cast(totalChecks()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "scheduledBy":
            return Optional.ofNullable(clazz.cast(scheduledBy()));
        case "securityLevel":
            return Optional.ofNullable(clazz.cast(securityLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanArn", SCAN_ARN_FIELD);
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("scanName", SCAN_NAME_FIELD);
        map.put("scanDate", SCAN_DATE_FIELD);
        map.put("failedChecks", FAILED_CHECKS_FIELD);
        map.put("totalChecks", TOTAL_CHECKS_FIELD);
        map.put("targets", TARGETS_FIELD);
        map.put("scheduledBy", SCHEDULED_BY_FIELD);
        map.put("securityLevel", SECURITY_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisScan, T> g) {
        return obj -> g.apply((CisScan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisScan> {
        /**
         * <p>
         * The CIS scan's ARN.
         * </p>
         * 
         * @param scanArn
         *        The CIS scan's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanArn(String scanArn);

        /**
         * <p>
         * The CIS scan's configuration ARN.
         * </p>
         * 
         * @param scanConfigurationArn
         *        The CIS scan's configuration ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArn(String scanConfigurationArn);

        /**
         * <p>
         * The CIS scan's status.
         * </p>
         * 
         * @param status
         *        The CIS scan's status.
         * @see CisScanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisScanStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The CIS scan's status.
         * </p>
         * 
         * @param status
         *        The CIS scan's status.
         * @see CisScanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisScanStatus
         */
        Builder status(CisScanStatus status);

        /**
         * <p>
         * The the name of the scan configuration that's associated with this scan.
         * </p>
         * 
         * @param scanName
         *        The the name of the scan configuration that's associated with this scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanName(String scanName);

        /**
         * <p>
         * The CIS scan's date.
         * </p>
         * 
         * @param scanDate
         *        The CIS scan's date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanDate(Instant scanDate);

        /**
         * <p>
         * The CIS scan's failed checks.
         * </p>
         * 
         * @param failedChecks
         *        The CIS scan's failed checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedChecks(Integer failedChecks);

        /**
         * <p>
         * The CIS scan's total checks.
         * </p>
         * 
         * @param totalChecks
         *        The CIS scan's total checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalChecks(Integer totalChecks);

        /**
         * <p>
         * The CIS scan's targets.
         * </p>
         * 
         * @param targets
         *        The CIS scan's targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(CisTargets targets);

        /**
         * <p>
         * The CIS scan's targets.
         * </p>
         * This is a convenience method that creates an instance of the {@link CisTargets.Builder} avoiding the need to
         * create one manually via {@link CisTargets#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CisTargets.Builder#build()} is called immediately and its result
         * is passed to {@link #targets(CisTargets)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link CisTargets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(CisTargets)
         */
        default Builder targets(Consumer<CisTargets.Builder> targets) {
            return targets(CisTargets.builder().applyMutation(targets).build());
        }

        /**
         * <p>
         * The account or organization that schedules the CIS scan.
         * </p>
         * 
         * @param scheduledBy
         *        The account or organization that schedules the CIS scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledBy(String scheduledBy);

        /**
         * <p>
         * The security level for the CIS scan. Security level refers to the Benchmark levels that CIS assigns to a
         * profile.
         * </p>
         * 
         * @param securityLevel
         *        The security level for the CIS scan. Security level refers to the Benchmark levels that CIS assigns to
         *        a profile.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder securityLevel(String securityLevel);

        /**
         * <p>
         * The security level for the CIS scan. Security level refers to the Benchmark levels that CIS assigns to a
         * profile.
         * </p>
         * 
         * @param securityLevel
         *        The security level for the CIS scan. Security level refers to the Benchmark levels that CIS assigns to
         *        a profile.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder securityLevel(CisSecurityLevel securityLevel);
    }

    static final class BuilderImpl implements Builder {
        private String scanArn;

        private String scanConfigurationArn;

        private String status;

        private String scanName;

        private Instant scanDate;

        private Integer failedChecks;

        private Integer totalChecks;

        private CisTargets targets;

        private String scheduledBy;

        private String securityLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(CisScan model) {
            scanArn(model.scanArn);
            scanConfigurationArn(model.scanConfigurationArn);
            status(model.status);
            scanName(model.scanName);
            scanDate(model.scanDate);
            failedChecks(model.failedChecks);
            totalChecks(model.totalChecks);
            targets(model.targets);
            scheduledBy(model.scheduledBy);
            securityLevel(model.securityLevel);
        }

        public final String getScanArn() {
            return scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final String getScanConfigurationArn() {
            return scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CisScanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getScanName() {
            return scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final Instant getScanDate() {
            return scanDate;
        }

        public final void setScanDate(Instant scanDate) {
            this.scanDate = scanDate;
        }

        @Override
        public final Builder scanDate(Instant scanDate) {
            this.scanDate = scanDate;
            return this;
        }

        public final Integer getFailedChecks() {
            return failedChecks;
        }

        public final void setFailedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
        }

        @Override
        public final Builder failedChecks(Integer failedChecks) {
            this.failedChecks = failedChecks;
            return this;
        }

        public final Integer getTotalChecks() {
            return totalChecks;
        }

        public final void setTotalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
        }

        @Override
        public final Builder totalChecks(Integer totalChecks) {
            this.totalChecks = totalChecks;
            return this;
        }

        public final CisTargets.Builder getTargets() {
            return targets != null ? targets.toBuilder() : null;
        }

        public final void setTargets(CisTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        @Override
        public final Builder targets(CisTargets targets) {
            this.targets = targets;
            return this;
        }

        public final String getScheduledBy() {
            return scheduledBy;
        }

        public final void setScheduledBy(String scheduledBy) {
            this.scheduledBy = scheduledBy;
        }

        @Override
        public final Builder scheduledBy(String scheduledBy) {
            this.scheduledBy = scheduledBy;
            return this;
        }

        public final String getSecurityLevel() {
            return securityLevel;
        }

        public final void setSecurityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
        }

        @Override
        public final Builder securityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        @Override
        public final Builder securityLevel(CisSecurityLevel securityLevel) {
            this.securityLevel(securityLevel == null ? null : securityLevel.toString());
            return this;
        }

        @Override
        public CisScan build() {
            return new CisScan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
