/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scan results aggregated by target resource filter criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisScanResultsAggregatedByTargetResourceFilterCriteria
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<CisScanResultsAggregatedByTargetResourceFilterCriteria.Builder, CisScanResultsAggregatedByTargetResourceFilterCriteria> {
    private static final SdkField<List<CisStringFilter>> ACCOUNT_ID_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("accountIdFilters")
            .getter(getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::accountIdFilters))
            .setter(setter(Builder::accountIdFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIdFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisResultStatusFilter>> STATUS_FILTERS_FIELD = SdkField
            .<List<CisResultStatusFilter>> builder(MarshallingType.LIST)
            .memberName("statusFilters")
            .getter(getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::statusFilters))
            .setter(setter(Builder::statusFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisResultStatusFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisResultStatusFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> CHECK_ID_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("checkIdFilters")
            .getter(getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::checkIdFilters))
            .setter(setter(Builder::checkIdFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkIdFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> TARGET_RESOURCE_ID_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("targetResourceIdFilters")
            .getter(getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::targetResourceIdFilters))
            .setter(setter(Builder::targetResourceIdFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceIdFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TagFilter>> TARGET_RESOURCE_TAG_FILTERS_FIELD = SdkField
            .<List<TagFilter>> builder(MarshallingType.LIST)
            .memberName("targetResourceTagFilters")
            .getter(getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::targetResourceTagFilters))
            .setter(setter(Builder::targetResourceTagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceTagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisStringFilter>> PLATFORM_FILTERS_FIELD = SdkField
            .<List<CisStringFilter>> builder(MarshallingType.LIST)
            .memberName("platformFilters")
            .getter(getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::platformFilters))
            .setter(setter(Builder::platformFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisTargetStatusFilter>> TARGET_STATUS_FILTERS_FIELD = SdkField
            .<List<CisTargetStatusFilter>> builder(MarshallingType.LIST)
            .memberName("targetStatusFilters")
            .getter(getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::targetStatusFilters))
            .setter(setter(Builder::targetStatusFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStatusFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisTargetStatusFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisTargetStatusFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisTargetStatusReasonFilter>> TARGET_STATUS_REASON_FILTERS_FIELD = SdkField
            .<List<CisTargetStatusReasonFilter>> builder(MarshallingType.LIST)
            .memberName("targetStatusReasonFilters")
            .getter(getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::targetStatusReasonFilters))
            .setter(setter(Builder::targetStatusReasonFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStatusReasonFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisTargetStatusReasonFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisTargetStatusReasonFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CisNumberFilter>> FAILED_CHECKS_FILTERS_FIELD = SdkField
            .<List<CisNumberFilter>> builder(MarshallingType.LIST)
            .memberName("failedChecksFilters")
            .getter(getter(CisScanResultsAggregatedByTargetResourceFilterCriteria::failedChecksFilters))
            .setter(setter(Builder::failedChecksFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedChecksFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisNumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisNumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACCOUNT_ID_FILTERS_FIELD, STATUS_FILTERS_FIELD, CHECK_ID_FILTERS_FIELD,
                    TARGET_RESOURCE_ID_FILTERS_FIELD, TARGET_RESOURCE_TAG_FILTERS_FIELD, PLATFORM_FILTERS_FIELD,
                    TARGET_STATUS_FILTERS_FIELD, TARGET_STATUS_REASON_FILTERS_FIELD, FAILED_CHECKS_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CisStringFilter> accountIdFilters;

    private final List<CisResultStatusFilter> statusFilters;

    private final List<CisStringFilter> checkIdFilters;

    private final List<CisStringFilter> targetResourceIdFilters;

    private final List<TagFilter> targetResourceTagFilters;

    private final List<CisStringFilter> platformFilters;

    private final List<CisTargetStatusFilter> targetStatusFilters;

    private final List<CisTargetStatusReasonFilter> targetStatusReasonFilters;

    private final List<CisNumberFilter> failedChecksFilters;

    private CisScanResultsAggregatedByTargetResourceFilterCriteria(BuilderImpl builder) {
        this.accountIdFilters = builder.accountIdFilters;
        this.statusFilters = builder.statusFilters;
        this.checkIdFilters = builder.checkIdFilters;
        this.targetResourceIdFilters = builder.targetResourceIdFilters;
        this.targetResourceTagFilters = builder.targetResourceTagFilters;
        this.platformFilters = builder.platformFilters;
        this.targetStatusFilters = builder.targetStatusFilters;
        this.targetStatusReasonFilters = builder.targetStatusReasonFilters;
        this.failedChecksFilters = builder.failedChecksFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIdFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountIdFilters() {
        return accountIdFilters != null && !(accountIdFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's account ID filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIdFilters} method.
     * </p>
     * 
     * @return The criteria's account ID filters.
     */
    public final List<CisStringFilter> accountIdFilters() {
        return accountIdFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusFilters() {
        return statusFilters != null && !(statusFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's status filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusFilters} method.
     * </p>
     * 
     * @return The criteria's status filter.
     */
    public final List<CisResultStatusFilter> statusFilters() {
        return statusFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the CheckIdFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCheckIdFilters() {
        return checkIdFilters != null && !(checkIdFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's check ID filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCheckIdFilters} method.
     * </p>
     * 
     * @return The criteria's check ID filters.
     */
    public final List<CisStringFilter> checkIdFilters() {
        return checkIdFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetResourceIdFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetResourceIdFilters() {
        return targetResourceIdFilters != null && !(targetResourceIdFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's target resource ID filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResourceIdFilters} method.
     * </p>
     * 
     * @return The criteria's target resource ID filters.
     */
    public final List<CisStringFilter> targetResourceIdFilters() {
        return targetResourceIdFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetResourceTagFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetResourceTagFilters() {
        return targetResourceTagFilters != null && !(targetResourceTagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's target resource tag filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResourceTagFilters} method.
     * </p>
     * 
     * @return The criteria's target resource tag filters.
     */
    public final List<TagFilter> targetResourceTagFilters() {
        return targetResourceTagFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlatformFilters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlatformFilters() {
        return platformFilters != null && !(platformFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's platform filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlatformFilters} method.
     * </p>
     * 
     * @return The criteria's platform filters.
     */
    public final List<CisStringFilter> platformFilters() {
        return platformFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetStatusFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetStatusFilters() {
        return targetStatusFilters != null && !(targetStatusFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's target status filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetStatusFilters} method.
     * </p>
     * 
     * @return The criteria's target status filters.
     */
    public final List<CisTargetStatusFilter> targetStatusFilters() {
        return targetStatusFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetStatusReasonFilters property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetStatusReasonFilters() {
        return targetStatusReasonFilters != null && !(targetStatusReasonFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's target status reason filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetStatusReasonFilters} method.
     * </p>
     * 
     * @return The criteria's target status reason filters.
     */
    public final List<CisTargetStatusReasonFilter> targetStatusReasonFilters() {
        return targetStatusReasonFilters;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedChecksFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedChecksFilters() {
        return failedChecksFilters != null && !(failedChecksFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The criteria's failed checks filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedChecksFilters} method.
     * </p>
     * 
     * @return The criteria's failed checks filters.
     */
    public final List<CisNumberFilter> failedChecksFilters() {
        return failedChecksFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIdFilters() ? accountIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusFilters() ? statusFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCheckIdFilters() ? checkIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetResourceIdFilters() ? targetResourceIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetResourceTagFilters() ? targetResourceTagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPlatformFilters() ? platformFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetStatusFilters() ? targetStatusFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetStatusReasonFilters() ? targetStatusReasonFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedChecksFilters() ? failedChecksFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisScanResultsAggregatedByTargetResourceFilterCriteria)) {
            return false;
        }
        CisScanResultsAggregatedByTargetResourceFilterCriteria other = (CisScanResultsAggregatedByTargetResourceFilterCriteria) obj;
        return hasAccountIdFilters() == other.hasAccountIdFilters()
                && Objects.equals(accountIdFilters(), other.accountIdFilters()) && hasStatusFilters() == other.hasStatusFilters()
                && Objects.equals(statusFilters(), other.statusFilters()) && hasCheckIdFilters() == other.hasCheckIdFilters()
                && Objects.equals(checkIdFilters(), other.checkIdFilters())
                && hasTargetResourceIdFilters() == other.hasTargetResourceIdFilters()
                && Objects.equals(targetResourceIdFilters(), other.targetResourceIdFilters())
                && hasTargetResourceTagFilters() == other.hasTargetResourceTagFilters()
                && Objects.equals(targetResourceTagFilters(), other.targetResourceTagFilters())
                && hasPlatformFilters() == other.hasPlatformFilters()
                && Objects.equals(platformFilters(), other.platformFilters())
                && hasTargetStatusFilters() == other.hasTargetStatusFilters()
                && Objects.equals(targetStatusFilters(), other.targetStatusFilters())
                && hasTargetStatusReasonFilters() == other.hasTargetStatusReasonFilters()
                && Objects.equals(targetStatusReasonFilters(), other.targetStatusReasonFilters())
                && hasFailedChecksFilters() == other.hasFailedChecksFilters()
                && Objects.equals(failedChecksFilters(), other.failedChecksFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisScanResultsAggregatedByTargetResourceFilterCriteria")
                .add("AccountIdFilters", hasAccountIdFilters() ? accountIdFilters() : null)
                .add("StatusFilters", hasStatusFilters() ? statusFilters() : null)
                .add("CheckIdFilters", hasCheckIdFilters() ? checkIdFilters() : null)
                .add("TargetResourceIdFilters", hasTargetResourceIdFilters() ? targetResourceIdFilters() : null)
                .add("TargetResourceTagFilters", hasTargetResourceTagFilters() ? targetResourceTagFilters() : null)
                .add("PlatformFilters", hasPlatformFilters() ? platformFilters() : null)
                .add("TargetStatusFilters", hasTargetStatusFilters() ? targetStatusFilters() : null)
                .add("TargetStatusReasonFilters", hasTargetStatusReasonFilters() ? targetStatusReasonFilters() : null)
                .add("FailedChecksFilters", hasFailedChecksFilters() ? failedChecksFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountIdFilters":
            return Optional.ofNullable(clazz.cast(accountIdFilters()));
        case "statusFilters":
            return Optional.ofNullable(clazz.cast(statusFilters()));
        case "checkIdFilters":
            return Optional.ofNullable(clazz.cast(checkIdFilters()));
        case "targetResourceIdFilters":
            return Optional.ofNullable(clazz.cast(targetResourceIdFilters()));
        case "targetResourceTagFilters":
            return Optional.ofNullable(clazz.cast(targetResourceTagFilters()));
        case "platformFilters":
            return Optional.ofNullable(clazz.cast(platformFilters()));
        case "targetStatusFilters":
            return Optional.ofNullable(clazz.cast(targetStatusFilters()));
        case "targetStatusReasonFilters":
            return Optional.ofNullable(clazz.cast(targetStatusReasonFilters()));
        case "failedChecksFilters":
            return Optional.ofNullable(clazz.cast(failedChecksFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountIdFilters", ACCOUNT_ID_FILTERS_FIELD);
        map.put("statusFilters", STATUS_FILTERS_FIELD);
        map.put("checkIdFilters", CHECK_ID_FILTERS_FIELD);
        map.put("targetResourceIdFilters", TARGET_RESOURCE_ID_FILTERS_FIELD);
        map.put("targetResourceTagFilters", TARGET_RESOURCE_TAG_FILTERS_FIELD);
        map.put("platformFilters", PLATFORM_FILTERS_FIELD);
        map.put("targetStatusFilters", TARGET_STATUS_FILTERS_FIELD);
        map.put("targetStatusReasonFilters", TARGET_STATUS_REASON_FILTERS_FIELD);
        map.put("failedChecksFilters", FAILED_CHECKS_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisScanResultsAggregatedByTargetResourceFilterCriteria, T> g) {
        return obj -> g.apply((CisScanResultsAggregatedByTargetResourceFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisScanResultsAggregatedByTargetResourceFilterCriteria> {
        /**
         * <p>
         * The criteria's account ID filters.
         * </p>
         * 
         * @param accountIdFilters
         *        The criteria's account ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdFilters(Collection<CisStringFilter> accountIdFilters);

        /**
         * <p>
         * The criteria's account ID filters.
         * </p>
         * 
         * @param accountIdFilters
         *        The criteria's account ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdFilters(CisStringFilter... accountIdFilters);

        /**
         * <p>
         * The criteria's account ID filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #accountIdFilters(List<CisStringFilter>)}.
         * 
         * @param accountIdFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountIdFilters(java.util.Collection<CisStringFilter>)
         */
        Builder accountIdFilters(Consumer<CisStringFilter.Builder>... accountIdFilters);

        /**
         * <p>
         * The criteria's status filter.
         * </p>
         * 
         * @param statusFilters
         *        The criteria's status filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusFilters(Collection<CisResultStatusFilter> statusFilters);

        /**
         * <p>
         * The criteria's status filter.
         * </p>
         * 
         * @param statusFilters
         *        The criteria's status filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusFilters(CisResultStatusFilter... statusFilters);

        /**
         * <p>
         * The criteria's status filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisResultStatusFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CisResultStatusFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisResultStatusFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #statusFilters(List<CisResultStatusFilter>)}.
         * 
         * @param statusFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisResultStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusFilters(java.util.Collection<CisResultStatusFilter>)
         */
        Builder statusFilters(Consumer<CisResultStatusFilter.Builder>... statusFilters);

        /**
         * <p>
         * The criteria's check ID filters.
         * </p>
         * 
         * @param checkIdFilters
         *        The criteria's check ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIdFilters(Collection<CisStringFilter> checkIdFilters);

        /**
         * <p>
         * The criteria's check ID filters.
         * </p>
         * 
         * @param checkIdFilters
         *        The criteria's check ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIdFilters(CisStringFilter... checkIdFilters);

        /**
         * <p>
         * The criteria's check ID filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #checkIdFilters(List<CisStringFilter>)}.
         * 
         * @param checkIdFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkIdFilters(java.util.Collection<CisStringFilter>)
         */
        Builder checkIdFilters(Consumer<CisStringFilter.Builder>... checkIdFilters);

        /**
         * <p>
         * The criteria's target resource ID filters.
         * </p>
         * 
         * @param targetResourceIdFilters
         *        The criteria's target resource ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceIdFilters(Collection<CisStringFilter> targetResourceIdFilters);

        /**
         * <p>
         * The criteria's target resource ID filters.
         * </p>
         * 
         * @param targetResourceIdFilters
         *        The criteria's target resource ID filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceIdFilters(CisStringFilter... targetResourceIdFilters);

        /**
         * <p>
         * The criteria's target resource ID filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #targetResourceIdFilters(List<CisStringFilter>)}.
         * 
         * @param targetResourceIdFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResourceIdFilters(java.util.Collection<CisStringFilter>)
         */
        Builder targetResourceIdFilters(Consumer<CisStringFilter.Builder>... targetResourceIdFilters);

        /**
         * <p>
         * The criteria's target resource tag filters.
         * </p>
         * 
         * @param targetResourceTagFilters
         *        The criteria's target resource tag filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceTagFilters(Collection<TagFilter> targetResourceTagFilters);

        /**
         * <p>
         * The criteria's target resource tag filters.
         * </p>
         * 
         * @param targetResourceTagFilters
         *        The criteria's target resource tag filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceTagFilters(TagFilter... targetResourceTagFilters);

        /**
         * <p>
         * The criteria's target resource tag filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.TagFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.TagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.TagFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #targetResourceTagFilters(List<TagFilter>)}.
         * 
         * @param targetResourceTagFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResourceTagFilters(java.util.Collection<TagFilter>)
         */
        Builder targetResourceTagFilters(Consumer<TagFilter.Builder>... targetResourceTagFilters);

        /**
         * <p>
         * The criteria's platform filters.
         * </p>
         * 
         * @param platformFilters
         *        The criteria's platform filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformFilters(Collection<CisStringFilter> platformFilters);

        /**
         * <p>
         * The criteria's platform filters.
         * </p>
         * 
         * @param platformFilters
         *        The criteria's platform filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformFilters(CisStringFilter... platformFilters);

        /**
         * <p>
         * The criteria's platform filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #platformFilters(List<CisStringFilter>)}.
         * 
         * @param platformFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformFilters(java.util.Collection<CisStringFilter>)
         */
        Builder platformFilters(Consumer<CisStringFilter.Builder>... platformFilters);

        /**
         * <p>
         * The criteria's target status filters.
         * </p>
         * 
         * @param targetStatusFilters
         *        The criteria's target status filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStatusFilters(Collection<CisTargetStatusFilter> targetStatusFilters);

        /**
         * <p>
         * The criteria's target status filters.
         * </p>
         * 
         * @param targetStatusFilters
         *        The criteria's target status filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStatusFilters(CisTargetStatusFilter... targetStatusFilters);

        /**
         * <p>
         * The criteria's target status filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisTargetStatusFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CisTargetStatusFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisTargetStatusFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #targetStatusFilters(List<CisTargetStatusFilter>)}.
         * 
         * @param targetStatusFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisTargetStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetStatusFilters(java.util.Collection<CisTargetStatusFilter>)
         */
        Builder targetStatusFilters(Consumer<CisTargetStatusFilter.Builder>... targetStatusFilters);

        /**
         * <p>
         * The criteria's target status reason filters.
         * </p>
         * 
         * @param targetStatusReasonFilters
         *        The criteria's target status reason filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStatusReasonFilters(Collection<CisTargetStatusReasonFilter> targetStatusReasonFilters);

        /**
         * <p>
         * The criteria's target status reason filters.
         * </p>
         * 
         * @param targetStatusReasonFilters
         *        The criteria's target status reason filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetStatusReasonFilters(CisTargetStatusReasonFilter... targetStatusReasonFilters);

        /**
         * <p>
         * The criteria's target status reason filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisTargetStatusReasonFilter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CisTargetStatusReasonFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisTargetStatusReasonFilter.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #targetStatusReasonFilters(List<CisTargetStatusReasonFilter>)}.
         * 
         * @param targetStatusReasonFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisTargetStatusReasonFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetStatusReasonFilters(java.util.Collection<CisTargetStatusReasonFilter>)
         */
        Builder targetStatusReasonFilters(Consumer<CisTargetStatusReasonFilter.Builder>... targetStatusReasonFilters);

        /**
         * <p>
         * The criteria's failed checks filters.
         * </p>
         * 
         * @param failedChecksFilters
         *        The criteria's failed checks filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedChecksFilters(Collection<CisNumberFilter> failedChecksFilters);

        /**
         * <p>
         * The criteria's failed checks filters.
         * </p>
         * 
         * @param failedChecksFilters
         *        The criteria's failed checks filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedChecksFilters(CisNumberFilter... failedChecksFilters);

        /**
         * <p>
         * The criteria's failed checks filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #failedChecksFilters(List<CisNumberFilter>)}.
         * 
         * @param failedChecksFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisNumberFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedChecksFilters(java.util.Collection<CisNumberFilter>)
         */
        Builder failedChecksFilters(Consumer<CisNumberFilter.Builder>... failedChecksFilters);
    }

    static final class BuilderImpl implements Builder {
        private List<CisStringFilter> accountIdFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisResultStatusFilter> statusFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> checkIdFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> targetResourceIdFilters = DefaultSdkAutoConstructList.getInstance();

        private List<TagFilter> targetResourceTagFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisStringFilter> platformFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisTargetStatusFilter> targetStatusFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisTargetStatusReasonFilter> targetStatusReasonFilters = DefaultSdkAutoConstructList.getInstance();

        private List<CisNumberFilter> failedChecksFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CisScanResultsAggregatedByTargetResourceFilterCriteria model) {
            accountIdFilters(model.accountIdFilters);
            statusFilters(model.statusFilters);
            checkIdFilters(model.checkIdFilters);
            targetResourceIdFilters(model.targetResourceIdFilters);
            targetResourceTagFilters(model.targetResourceTagFilters);
            platformFilters(model.platformFilters);
            targetStatusFilters(model.targetStatusFilters);
            targetStatusReasonFilters(model.targetStatusReasonFilters);
            failedChecksFilters(model.failedChecksFilters);
        }

        public final List<CisStringFilter.Builder> getAccountIdFilters() {
            List<CisStringFilter.Builder> result = AccountIdFilterListCopier.copyToBuilder(this.accountIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountIdFilters(Collection<CisStringFilter.BuilderImpl> accountIdFilters) {
            this.accountIdFilters = AccountIdFilterListCopier.copyFromBuilder(accountIdFilters);
        }

        @Override
        public final Builder accountIdFilters(Collection<CisStringFilter> accountIdFilters) {
            this.accountIdFilters = AccountIdFilterListCopier.copy(accountIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdFilters(CisStringFilter... accountIdFilters) {
            accountIdFilters(Arrays.asList(accountIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdFilters(Consumer<CisStringFilter.Builder>... accountIdFilters) {
            accountIdFilters(Stream.of(accountIdFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisResultStatusFilter.Builder> getStatusFilters() {
            List<CisResultStatusFilter.Builder> result = CisResultStatusFilterListCopier.copyToBuilder(this.statusFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusFilters(Collection<CisResultStatusFilter.BuilderImpl> statusFilters) {
            this.statusFilters = CisResultStatusFilterListCopier.copyFromBuilder(statusFilters);
        }

        @Override
        public final Builder statusFilters(Collection<CisResultStatusFilter> statusFilters) {
            this.statusFilters = CisResultStatusFilterListCopier.copy(statusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusFilters(CisResultStatusFilter... statusFilters) {
            statusFilters(Arrays.asList(statusFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusFilters(Consumer<CisResultStatusFilter.Builder>... statusFilters) {
            statusFilters(Stream.of(statusFilters).map(c -> CisResultStatusFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getCheckIdFilters() {
            List<CisStringFilter.Builder> result = CheckIdFilterListCopier.copyToBuilder(this.checkIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCheckIdFilters(Collection<CisStringFilter.BuilderImpl> checkIdFilters) {
            this.checkIdFilters = CheckIdFilterListCopier.copyFromBuilder(checkIdFilters);
        }

        @Override
        public final Builder checkIdFilters(Collection<CisStringFilter> checkIdFilters) {
            this.checkIdFilters = CheckIdFilterListCopier.copy(checkIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIdFilters(CisStringFilter... checkIdFilters) {
            checkIdFilters(Arrays.asList(checkIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkIdFilters(Consumer<CisStringFilter.Builder>... checkIdFilters) {
            checkIdFilters(Stream.of(checkIdFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getTargetResourceIdFilters() {
            List<CisStringFilter.Builder> result = ResourceIdFilterListCopier.copyToBuilder(this.targetResourceIdFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceIdFilters(Collection<CisStringFilter.BuilderImpl> targetResourceIdFilters) {
            this.targetResourceIdFilters = ResourceIdFilterListCopier.copyFromBuilder(targetResourceIdFilters);
        }

        @Override
        public final Builder targetResourceIdFilters(Collection<CisStringFilter> targetResourceIdFilters) {
            this.targetResourceIdFilters = ResourceIdFilterListCopier.copy(targetResourceIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceIdFilters(CisStringFilter... targetResourceIdFilters) {
            targetResourceIdFilters(Arrays.asList(targetResourceIdFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceIdFilters(Consumer<CisStringFilter.Builder>... targetResourceIdFilters) {
            targetResourceIdFilters(Stream.of(targetResourceIdFilters)
                    .map(c -> CisStringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagFilter.Builder> getTargetResourceTagFilters() {
            List<TagFilter.Builder> result = ResourceTagFilterListCopier.copyToBuilder(this.targetResourceTagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetResourceTagFilters(Collection<TagFilter.BuilderImpl> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copyFromBuilder(targetResourceTagFilters);
        }

        @Override
        public final Builder targetResourceTagFilters(Collection<TagFilter> targetResourceTagFilters) {
            this.targetResourceTagFilters = ResourceTagFilterListCopier.copy(targetResourceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(TagFilter... targetResourceTagFilters) {
            targetResourceTagFilters(Arrays.asList(targetResourceTagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetResourceTagFilters(Consumer<TagFilter.Builder>... targetResourceTagFilters) {
            targetResourceTagFilters(Stream.of(targetResourceTagFilters).map(c -> TagFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisStringFilter.Builder> getPlatformFilters() {
            List<CisStringFilter.Builder> result = PlatformFilterListCopier.copyToBuilder(this.platformFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatformFilters(Collection<CisStringFilter.BuilderImpl> platformFilters) {
            this.platformFilters = PlatformFilterListCopier.copyFromBuilder(platformFilters);
        }

        @Override
        public final Builder platformFilters(Collection<CisStringFilter> platformFilters) {
            this.platformFilters = PlatformFilterListCopier.copy(platformFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformFilters(CisStringFilter... platformFilters) {
            platformFilters(Arrays.asList(platformFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformFilters(Consumer<CisStringFilter.Builder>... platformFilters) {
            platformFilters(Stream.of(platformFilters).map(c -> CisStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisTargetStatusFilter.Builder> getTargetStatusFilters() {
            List<CisTargetStatusFilter.Builder> result = TargetStatusFilterListCopier.copyToBuilder(this.targetStatusFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetStatusFilters(Collection<CisTargetStatusFilter.BuilderImpl> targetStatusFilters) {
            this.targetStatusFilters = TargetStatusFilterListCopier.copyFromBuilder(targetStatusFilters);
        }

        @Override
        public final Builder targetStatusFilters(Collection<CisTargetStatusFilter> targetStatusFilters) {
            this.targetStatusFilters = TargetStatusFilterListCopier.copy(targetStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStatusFilters(CisTargetStatusFilter... targetStatusFilters) {
            targetStatusFilters(Arrays.asList(targetStatusFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStatusFilters(Consumer<CisTargetStatusFilter.Builder>... targetStatusFilters) {
            targetStatusFilters(Stream.of(targetStatusFilters).map(c -> CisTargetStatusFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CisTargetStatusReasonFilter.Builder> getTargetStatusReasonFilters() {
            List<CisTargetStatusReasonFilter.Builder> result = TargetStatusReasonFilterListCopier
                    .copyToBuilder(this.targetStatusReasonFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetStatusReasonFilters(
                Collection<CisTargetStatusReasonFilter.BuilderImpl> targetStatusReasonFilters) {
            this.targetStatusReasonFilters = TargetStatusReasonFilterListCopier.copyFromBuilder(targetStatusReasonFilters);
        }

        @Override
        public final Builder targetStatusReasonFilters(Collection<CisTargetStatusReasonFilter> targetStatusReasonFilters) {
            this.targetStatusReasonFilters = TargetStatusReasonFilterListCopier.copy(targetStatusReasonFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStatusReasonFilters(CisTargetStatusReasonFilter... targetStatusReasonFilters) {
            targetStatusReasonFilters(Arrays.asList(targetStatusReasonFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetStatusReasonFilters(Consumer<CisTargetStatusReasonFilter.Builder>... targetStatusReasonFilters) {
            targetStatusReasonFilters(Stream.of(targetStatusReasonFilters)
                    .map(c -> CisTargetStatusReasonFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CisNumberFilter.Builder> getFailedChecksFilters() {
            List<CisNumberFilter.Builder> result = CisNumberFilterListCopier.copyToBuilder(this.failedChecksFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedChecksFilters(Collection<CisNumberFilter.BuilderImpl> failedChecksFilters) {
            this.failedChecksFilters = CisNumberFilterListCopier.copyFromBuilder(failedChecksFilters);
        }

        @Override
        public final Builder failedChecksFilters(Collection<CisNumberFilter> failedChecksFilters) {
            this.failedChecksFilters = CisNumberFilterListCopier.copy(failedChecksFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedChecksFilters(CisNumberFilter... failedChecksFilters) {
            failedChecksFilters(Arrays.asList(failedChecksFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedChecksFilters(Consumer<CisNumberFilter.Builder>... failedChecksFilters) {
            failedChecksFilters(Stream.of(failedChecksFilters).map(c -> CisNumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CisScanResultsAggregatedByTargetResourceFilterCriteria build() {
            return new CisScanResultsAggregatedByTargetResourceFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
