/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CIS target resource aggregation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisTargetResourceAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<CisTargetResourceAggregation.Builder, CisTargetResourceAggregation> {
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanArn").getter(getter(CisTargetResourceAggregation::scanArn)).setter(setter(Builder::scanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()).build();

    private static final SdkField<String> TARGET_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetResourceId").getter(getter(CisTargetResourceAggregation::targetResourceId))
            .setter(setter(Builder::targetResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(CisTargetResourceAggregation::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Map<String, List<String>>> TARGET_RESOURCE_TAGS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("targetResourceTags")
            .getter(getter(CisTargetResourceAggregation::targetResourceTags))
            .setter(setter(Builder::targetResourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<StatusCounts> STATUS_COUNTS_FIELD = SdkField.<StatusCounts> builder(MarshallingType.SDK_POJO)
            .memberName("statusCounts").getter(getter(CisTargetResourceAggregation::statusCounts))
            .setter(setter(Builder::statusCounts)).constructor(StatusCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCounts").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(CisTargetResourceAggregation::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetStatus").getter(getter(CisTargetResourceAggregation::targetStatusAsString))
            .setter(setter(Builder::targetStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStatus").build()).build();

    private static final SdkField<String> TARGET_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetStatusReason").getter(getter(CisTargetResourceAggregation::targetStatusReasonAsString))
            .setter(setter(Builder::targetStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStatusReason").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ARN_FIELD,
            TARGET_RESOURCE_ID_FIELD, ACCOUNT_ID_FIELD, TARGET_RESOURCE_TAGS_FIELD, STATUS_COUNTS_FIELD, PLATFORM_FIELD,
            TARGET_STATUS_FIELD, TARGET_STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scanArn;

    private final String targetResourceId;

    private final String accountId;

    private final Map<String, List<String>> targetResourceTags;

    private final StatusCounts statusCounts;

    private final String platform;

    private final String targetStatus;

    private final String targetStatusReason;

    private CisTargetResourceAggregation(BuilderImpl builder) {
        this.scanArn = builder.scanArn;
        this.targetResourceId = builder.targetResourceId;
        this.accountId = builder.accountId;
        this.targetResourceTags = builder.targetResourceTags;
        this.statusCounts = builder.statusCounts;
        this.platform = builder.platform;
        this.targetStatus = builder.targetStatus;
        this.targetStatusReason = builder.targetStatusReason;
    }

    /**
     * <p>
     * The scan ARN for the CIS target resource.
     * </p>
     * 
     * @return The scan ARN for the CIS target resource.
     */
    public final String scanArn() {
        return scanArn;
    }

    /**
     * <p>
     * The ID of the target resource.
     * </p>
     * 
     * @return The ID of the target resource.
     */
    public final String targetResourceId() {
        return targetResourceId;
    }

    /**
     * <p>
     * The account ID for the CIS target resource.
     * </p>
     * 
     * @return The account ID for the CIS target resource.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetResourceTags property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetResourceTags() {
        return targetResourceTags != null && !(targetResourceTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tag for the target resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetResourceTags} method.
     * </p>
     * 
     * @return The tag for the target resource.
     */
    public final Map<String, List<String>> targetResourceTags() {
        return targetResourceTags;
    }

    /**
     * <p>
     * The target resource status counts.
     * </p>
     * 
     * @return The target resource status counts.
     */
    public final StatusCounts statusCounts() {
        return statusCounts;
    }

    /**
     * <p>
     * The platform for the CIS target resource.
     * </p>
     * 
     * @return The platform for the CIS target resource.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The status of the target resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link CisTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The status of the target resource.
     * @see CisTargetStatus
     */
    public final CisTargetStatus targetStatus() {
        return CisTargetStatus.fromValue(targetStatus);
    }

    /**
     * <p>
     * The status of the target resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetStatus} will
     * return {@link CisTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetStatusAsString}.
     * </p>
     * 
     * @return The status of the target resource.
     * @see CisTargetStatus
     */
    public final String targetStatusAsString() {
        return targetStatus;
    }

    /**
     * <p>
     * The reason for the target resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetStatusReason} will return {@link CisTargetStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetStatusReasonAsString}.
     * </p>
     * 
     * @return The reason for the target resource.
     * @see CisTargetStatusReason
     */
    public final CisTargetStatusReason targetStatusReason() {
        return CisTargetStatusReason.fromValue(targetStatusReason);
    }

    /**
     * <p>
     * The reason for the target resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetStatusReason} will return {@link CisTargetStatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetStatusReasonAsString}.
     * </p>
     * 
     * @return The reason for the target resource.
     * @see CisTargetStatusReason
     */
    public final String targetStatusReasonAsString() {
        return targetStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetResourceTags() ? targetResourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusCounts());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(targetStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetStatusReasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisTargetResourceAggregation)) {
            return false;
        }
        CisTargetResourceAggregation other = (CisTargetResourceAggregation) obj;
        return Objects.equals(scanArn(), other.scanArn()) && Objects.equals(targetResourceId(), other.targetResourceId())
                && Objects.equals(accountId(), other.accountId()) && hasTargetResourceTags() == other.hasTargetResourceTags()
                && Objects.equals(targetResourceTags(), other.targetResourceTags())
                && Objects.equals(statusCounts(), other.statusCounts()) && Objects.equals(platform(), other.platform())
                && Objects.equals(targetStatusAsString(), other.targetStatusAsString())
                && Objects.equals(targetStatusReasonAsString(), other.targetStatusReasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisTargetResourceAggregation").add("ScanArn", scanArn())
                .add("TargetResourceId", targetResourceId()).add("AccountId", accountId())
                .add("TargetResourceTags", hasTargetResourceTags() ? targetResourceTags() : null)
                .add("StatusCounts", statusCounts()).add("Platform", platform()).add("TargetStatus", targetStatusAsString())
                .add("TargetStatusReason", targetStatusReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanArn":
            return Optional.ofNullable(clazz.cast(scanArn()));
        case "targetResourceId":
            return Optional.ofNullable(clazz.cast(targetResourceId()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "targetResourceTags":
            return Optional.ofNullable(clazz.cast(targetResourceTags()));
        case "statusCounts":
            return Optional.ofNullable(clazz.cast(statusCounts()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "targetStatus":
            return Optional.ofNullable(clazz.cast(targetStatusAsString()));
        case "targetStatusReason":
            return Optional.ofNullable(clazz.cast(targetStatusReasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanArn", SCAN_ARN_FIELD);
        map.put("targetResourceId", TARGET_RESOURCE_ID_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("targetResourceTags", TARGET_RESOURCE_TAGS_FIELD);
        map.put("statusCounts", STATUS_COUNTS_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("targetStatus", TARGET_STATUS_FIELD);
        map.put("targetStatusReason", TARGET_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisTargetResourceAggregation, T> g) {
        return obj -> g.apply((CisTargetResourceAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisTargetResourceAggregation> {
        /**
         * <p>
         * The scan ARN for the CIS target resource.
         * </p>
         * 
         * @param scanArn
         *        The scan ARN for the CIS target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanArn(String scanArn);

        /**
         * <p>
         * The ID of the target resource.
         * </p>
         * 
         * @param targetResourceId
         *        The ID of the target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceId(String targetResourceId);

        /**
         * <p>
         * The account ID for the CIS target resource.
         * </p>
         * 
         * @param accountId
         *        The account ID for the CIS target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The tag for the target resource.
         * </p>
         * 
         * @param targetResourceTags
         *        The tag for the target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResourceTags(Map<String, ? extends Collection<String>> targetResourceTags);

        /**
         * <p>
         * The target resource status counts.
         * </p>
         * 
         * @param statusCounts
         *        The target resource status counts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCounts(StatusCounts statusCounts);

        /**
         * <p>
         * The target resource status counts.
         * </p>
         * This is a convenience method that creates an instance of the {@link StatusCounts.Builder} avoiding the need
         * to create one manually via {@link StatusCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StatusCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #statusCounts(StatusCounts)}.
         * 
         * @param statusCounts
         *        a consumer that will call methods on {@link StatusCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusCounts(StatusCounts)
         */
        default Builder statusCounts(Consumer<StatusCounts.Builder> statusCounts) {
            return statusCounts(StatusCounts.builder().applyMutation(statusCounts).build());
        }

        /**
         * <p>
         * The platform for the CIS target resource.
         * </p>
         * 
         * @param platform
         *        The platform for the CIS target resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The status of the target resource.
         * </p>
         * 
         * @param targetStatus
         *        The status of the target resource.
         * @see CisTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisTargetStatus
         */
        Builder targetStatus(String targetStatus);

        /**
         * <p>
         * The status of the target resource.
         * </p>
         * 
         * @param targetStatus
         *        The status of the target resource.
         * @see CisTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisTargetStatus
         */
        Builder targetStatus(CisTargetStatus targetStatus);

        /**
         * <p>
         * The reason for the target resource.
         * </p>
         * 
         * @param targetStatusReason
         *        The reason for the target resource.
         * @see CisTargetStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisTargetStatusReason
         */
        Builder targetStatusReason(String targetStatusReason);

        /**
         * <p>
         * The reason for the target resource.
         * </p>
         * 
         * @param targetStatusReason
         *        The reason for the target resource.
         * @see CisTargetStatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisTargetStatusReason
         */
        Builder targetStatusReason(CisTargetStatusReason targetStatusReason);
    }

    static final class BuilderImpl implements Builder {
        private String scanArn;

        private String targetResourceId;

        private String accountId;

        private Map<String, List<String>> targetResourceTags = DefaultSdkAutoConstructMap.getInstance();

        private StatusCounts statusCounts;

        private String platform;

        private String targetStatus;

        private String targetStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CisTargetResourceAggregation model) {
            scanArn(model.scanArn);
            targetResourceId(model.targetResourceId);
            accountId(model.accountId);
            targetResourceTags(model.targetResourceTags);
            statusCounts(model.statusCounts);
            platform(model.platform);
            targetStatus(model.targetStatus);
            targetStatusReason(model.targetStatusReason);
        }

        public final String getScanArn() {
            return scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final String getTargetResourceId() {
            return targetResourceId;
        }

        public final void setTargetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
        }

        @Override
        public final Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getTargetResourceTags() {
            if (targetResourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return targetResourceTags;
        }

        public final void setTargetResourceTags(Map<String, ? extends Collection<String>> targetResourceTags) {
            this.targetResourceTags = TargetResourceTagsCopier.copy(targetResourceTags);
        }

        @Override
        public final Builder targetResourceTags(Map<String, ? extends Collection<String>> targetResourceTags) {
            this.targetResourceTags = TargetResourceTagsCopier.copy(targetResourceTags);
            return this;
        }

        public final StatusCounts.Builder getStatusCounts() {
            return statusCounts != null ? statusCounts.toBuilder() : null;
        }

        public final void setStatusCounts(StatusCounts.BuilderImpl statusCounts) {
            this.statusCounts = statusCounts != null ? statusCounts.build() : null;
        }

        @Override
        public final Builder statusCounts(StatusCounts statusCounts) {
            this.statusCounts = statusCounts;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getTargetStatus() {
            return targetStatus;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(CisTargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        public final String getTargetStatusReason() {
            return targetStatusReason;
        }

        public final void setTargetStatusReason(String targetStatusReason) {
            this.targetStatusReason = targetStatusReason;
        }

        @Override
        public final Builder targetStatusReason(String targetStatusReason) {
            this.targetStatusReason = targetStatusReason;
            return this;
        }

        @Override
        public final Builder targetStatusReason(CisTargetStatusReason targetStatusReason) {
            this.targetStatusReason(targetStatusReason == null ? null : targetStatusReason.toString());
            return this;
        }

        @Override
        public CisTargetResourceAggregation build() {
            return new CisTargetResourceAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
