/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Cybersecurity and Infrastructure Security Agency (CISA) details for a specific vulnerability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisaData implements SdkPojo, Serializable, ToCopyableBuilder<CisaData.Builder, CisaData> {
    private static final SdkField<Instant> DATE_ADDED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dateAdded").getter(getter(CisaData::dateAdded)).setter(setter(Builder::dateAdded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateAdded").build()).build();

    private static final SdkField<Instant> DATE_DUE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("dateDue").getter(getter(CisaData::dateDue)).setter(setter(Builder::dateDue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateDue").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(CisaData::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_ADDED_FIELD,
            DATE_DUE_FIELD, ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant dateAdded;

    private final Instant dateDue;

    private final String action;

    private CisaData(BuilderImpl builder) {
        this.dateAdded = builder.dateAdded;
        this.dateDue = builder.dateDue;
        this.action = builder.action;
    }

    /**
     * <p>
     * The date and time CISA added this vulnerability to their catalogue.
     * </p>
     * 
     * @return The date and time CISA added this vulnerability to their catalogue.
     */
    public final Instant dateAdded() {
        return dateAdded;
    }

    /**
     * <p>
     * The date and time CISA expects a fix to have been provided vulnerability.
     * </p>
     * 
     * @return The date and time CISA expects a fix to have been provided vulnerability.
     */
    public final Instant dateDue() {
        return dateDue;
    }

    /**
     * <p>
     * The remediation action recommended by CISA for this vulnerability.
     * </p>
     * 
     * @return The remediation action recommended by CISA for this vulnerability.
     */
    public final String action() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dateAdded());
        hashCode = 31 * hashCode + Objects.hashCode(dateDue());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisaData)) {
            return false;
        }
        CisaData other = (CisaData) obj;
        return Objects.equals(dateAdded(), other.dateAdded()) && Objects.equals(dateDue(), other.dateDue())
                && Objects.equals(action(), other.action());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisaData").add("DateAdded", dateAdded()).add("DateDue", dateDue()).add("Action", action())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dateAdded":
            return Optional.ofNullable(clazz.cast(dateAdded()));
        case "dateDue":
            return Optional.ofNullable(clazz.cast(dateDue()));
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dateAdded", DATE_ADDED_FIELD);
        map.put("dateDue", DATE_DUE_FIELD);
        map.put("action", ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisaData, T> g) {
        return obj -> g.apply((CisaData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisaData> {
        /**
         * <p>
         * The date and time CISA added this vulnerability to their catalogue.
         * </p>
         * 
         * @param dateAdded
         *        The date and time CISA added this vulnerability to their catalogue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateAdded(Instant dateAdded);

        /**
         * <p>
         * The date and time CISA expects a fix to have been provided vulnerability.
         * </p>
         * 
         * @param dateDue
         *        The date and time CISA expects a fix to have been provided vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateDue(Instant dateDue);

        /**
         * <p>
         * The remediation action recommended by CISA for this vulnerability.
         * </p>
         * 
         * @param action
         *        The remediation action recommended by CISA for this vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);
    }

    static final class BuilderImpl implements Builder {
        private Instant dateAdded;

        private Instant dateDue;

        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(CisaData model) {
            dateAdded(model.dateAdded);
            dateDue(model.dateDue);
            action(model.action);
        }

        public final Instant getDateAdded() {
            return dateAdded;
        }

        public final void setDateAdded(Instant dateAdded) {
            this.dateAdded = dateAdded;
        }

        @Override
        public final Builder dateAdded(Instant dateAdded) {
            this.dateAdded = dateAdded;
            return this;
        }

        public final Instant getDateDue() {
            return dateDue;
        }

        public final void setDateDue(Instant dateDue) {
            this.dateDue = dateDue;
        }

        @Override
        public final Builder dateDue(Instant dateDue) {
            this.dateDue = dateDue;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public CisaData build() {
            return new CisaData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
