/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterInformation.Builder, ClusterInformation> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(ClusterInformation::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<List<ClusterDetails>> CLUSTER_DETAILS_FIELD = SdkField
            .<List<ClusterDetails>> builder(MarshallingType.LIST)
            .memberName("clusterDetails")
            .getter(getter(ClusterInformation::clusterDetails))
            .setter(setter(Builder::clusterDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CLUSTER_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterArn;

    private final List<ClusterDetails> clusterDetails;

    private ClusterInformation(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterDetails = builder.clusterDetails;
    }

    /**
     * <p>
     * The cluster ARN.
     * </p>
     * 
     * @return The cluster ARN.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterDetails property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterDetails() {
        return clusterDetails != null && !(clusterDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterDetails} method.
     * </p>
     * 
     * @return Details about the cluster.
     */
    public final List<ClusterDetails> clusterDetails() {
        return clusterDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterDetails() ? clusterDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInformation)) {
            return false;
        }
        ClusterInformation other = (ClusterInformation) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && hasClusterDetails() == other.hasClusterDetails()
                && Objects.equals(clusterDetails(), other.clusterDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterInformation").add("ClusterArn", clusterArn())
                .add("ClusterDetails", hasClusterDetails() ? clusterDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "clusterDetails":
            return Optional.ofNullable(clazz.cast(clusterDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("clusterDetails", CLUSTER_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterInformation, T> g) {
        return obj -> g.apply((ClusterInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterInformation> {
        /**
         * <p>
         * The cluster ARN.
         * </p>
         * 
         * @param clusterArn
         *        The cluster ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * Details about the cluster.
         * </p>
         * 
         * @param clusterDetails
         *        Details about the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterDetails(Collection<ClusterDetails> clusterDetails);

        /**
         * <p>
         * Details about the cluster.
         * </p>
         * 
         * @param clusterDetails
         *        Details about the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterDetails(ClusterDetails... clusterDetails);

        /**
         * <p>
         * Details about the cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.ClusterDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.inspector2.model.ClusterDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.ClusterDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #clusterDetails(List<ClusterDetails>)}.
         * 
         * @param clusterDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.ClusterDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterDetails(java.util.Collection<ClusterDetails>)
         */
        Builder clusterDetails(Consumer<ClusterDetails.Builder>... clusterDetails);
    }

    static final class BuilderImpl implements Builder {
        private String clusterArn;

        private List<ClusterDetails> clusterDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInformation model) {
            clusterArn(model.clusterArn);
            clusterDetails(model.clusterDetails);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final List<ClusterDetails.Builder> getClusterDetails() {
            List<ClusterDetails.Builder> result = ClusterInformationClusterDetailsListCopier.copyToBuilder(this.clusterDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterDetails(Collection<ClusterDetails.BuilderImpl> clusterDetails) {
            this.clusterDetails = ClusterInformationClusterDetailsListCopier.copyFromBuilder(clusterDetails);
        }

        @Override
        public final Builder clusterDetails(Collection<ClusterDetails> clusterDetails) {
            this.clusterDetails = ClusterInformationClusterDetailsListCopier.copy(clusterDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDetails(ClusterDetails... clusterDetails) {
            clusterDetails(Arrays.asList(clusterDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDetails(Consumer<ClusterDetails.Builder>... clusterDetails) {
            clusterDetails(Stream.of(clusterDetails).map(c -> ClusterDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ClusterInformation build() {
            return new ClusterInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
