/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata for a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterMetadata implements SdkPojo, Serializable, ToCopyableBuilder<ClusterMetadata.Builder, ClusterMetadata> {
    private static final SdkField<AwsEcsMetadataDetails> AWS_ECS_METADATA_DETAILS_FIELD = SdkField
            .<AwsEcsMetadataDetails> builder(MarshallingType.SDK_POJO).memberName("awsEcsMetadataDetails")
            .getter(getter(ClusterMetadata::awsEcsMetadataDetails)).setter(setter(Builder::awsEcsMetadataDetails))
            .constructor(AwsEcsMetadataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsEcsMetadataDetails").build())
            .build();

    private static final SdkField<AwsEksMetadataDetails> AWS_EKS_METADATA_DETAILS_FIELD = SdkField
            .<AwsEksMetadataDetails> builder(MarshallingType.SDK_POJO).memberName("awsEksMetadataDetails")
            .getter(getter(ClusterMetadata::awsEksMetadataDetails)).setter(setter(Builder::awsEksMetadataDetails))
            .constructor(AwsEksMetadataDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsEksMetadataDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AWS_ECS_METADATA_DETAILS_FIELD, AWS_EKS_METADATA_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsEcsMetadataDetails awsEcsMetadataDetails;

    private final AwsEksMetadataDetails awsEksMetadataDetails;

    private final Type type;

    private ClusterMetadata(BuilderImpl builder) {
        this.awsEcsMetadataDetails = builder.awsEcsMetadataDetails;
        this.awsEksMetadataDetails = builder.awsEksMetadataDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * The details for an Amazon ECS cluster in the cluster metadata.
     * </p>
     * 
     * @return The details for an Amazon ECS cluster in the cluster metadata.
     */
    public final AwsEcsMetadataDetails awsEcsMetadataDetails() {
        return awsEcsMetadataDetails;
    }

    /**
     * <p>
     * The details for an Amazon EKS cluster in the cluster metadata.
     * </p>
     * 
     * @return The details for an Amazon EKS cluster in the cluster metadata.
     */
    public final AwsEksMetadataDetails awsEksMetadataDetails() {
        return awsEksMetadataDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsEcsMetadataDetails());
        hashCode = 31 * hashCode + Objects.hashCode(awsEksMetadataDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterMetadata)) {
            return false;
        }
        ClusterMetadata other = (ClusterMetadata) obj;
        return Objects.equals(awsEcsMetadataDetails(), other.awsEcsMetadataDetails())
                && Objects.equals(awsEksMetadataDetails(), other.awsEksMetadataDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterMetadata").add("AwsEcsMetadataDetails", awsEcsMetadataDetails())
                .add("AwsEksMetadataDetails", awsEksMetadataDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsEcsMetadataDetails":
            return Optional.ofNullable(clazz.cast(awsEcsMetadataDetails()));
        case "awsEksMetadataDetails":
            return Optional.ofNullable(clazz.cast(awsEksMetadataDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #awsEcsMetadataDetails()} initialized to the given value.
     *
     * <p>
     * The details for an Amazon ECS cluster in the cluster metadata.
     * </p>
     * 
     * @param awsEcsMetadataDetails
     *        The details for an Amazon ECS cluster in the cluster metadata.
     */
    public static ClusterMetadata fromAwsEcsMetadataDetails(AwsEcsMetadataDetails awsEcsMetadataDetails) {
        return builder().awsEcsMetadataDetails(awsEcsMetadataDetails).build();
    }

    /**
     * Create an instance of this class with {@link #awsEcsMetadataDetails()} initialized to the given value.
     *
     * <p>
     * The details for an Amazon ECS cluster in the cluster metadata.
     * </p>
     * 
     * @param awsEcsMetadataDetails
     *        The details for an Amazon ECS cluster in the cluster metadata.
     */
    public static ClusterMetadata fromAwsEcsMetadataDetails(Consumer<AwsEcsMetadataDetails.Builder> awsEcsMetadataDetails) {
        AwsEcsMetadataDetails.Builder builder = AwsEcsMetadataDetails.builder();
        awsEcsMetadataDetails.accept(builder);
        return fromAwsEcsMetadataDetails(builder.build());
    }

    /**
     * Create an instance of this class with {@link #awsEksMetadataDetails()} initialized to the given value.
     *
     * <p>
     * The details for an Amazon EKS cluster in the cluster metadata.
     * </p>
     * 
     * @param awsEksMetadataDetails
     *        The details for an Amazon EKS cluster in the cluster metadata.
     */
    public static ClusterMetadata fromAwsEksMetadataDetails(AwsEksMetadataDetails awsEksMetadataDetails) {
        return builder().awsEksMetadataDetails(awsEksMetadataDetails).build();
    }

    /**
     * Create an instance of this class with {@link #awsEksMetadataDetails()} initialized to the given value.
     *
     * <p>
     * The details for an Amazon EKS cluster in the cluster metadata.
     * </p>
     * 
     * @param awsEksMetadataDetails
     *        The details for an Amazon EKS cluster in the cluster metadata.
     */
    public static ClusterMetadata fromAwsEksMetadataDetails(Consumer<AwsEksMetadataDetails.Builder> awsEksMetadataDetails) {
        AwsEksMetadataDetails.Builder builder = AwsEksMetadataDetails.builder();
        awsEksMetadataDetails.accept(builder);
        return fromAwsEksMetadataDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsEcsMetadataDetails", AWS_ECS_METADATA_DETAILS_FIELD);
        map.put("awsEksMetadataDetails", AWS_EKS_METADATA_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterMetadata, T> g) {
        return obj -> g.apply((ClusterMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterMetadata> {
        /**
         * <p>
         * The details for an Amazon ECS cluster in the cluster metadata.
         * </p>
         * 
         * @param awsEcsMetadataDetails
         *        The details for an Amazon ECS cluster in the cluster metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEcsMetadataDetails(AwsEcsMetadataDetails awsEcsMetadataDetails);

        /**
         * <p>
         * The details for an Amazon ECS cluster in the cluster metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEcsMetadataDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEcsMetadataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcsMetadataDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEcsMetadataDetails(AwsEcsMetadataDetails)}.
         * 
         * @param awsEcsMetadataDetails
         *        a consumer that will call methods on {@link AwsEcsMetadataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEcsMetadataDetails(AwsEcsMetadataDetails)
         */
        default Builder awsEcsMetadataDetails(Consumer<AwsEcsMetadataDetails.Builder> awsEcsMetadataDetails) {
            return awsEcsMetadataDetails(AwsEcsMetadataDetails.builder().applyMutation(awsEcsMetadataDetails).build());
        }

        /**
         * <p>
         * The details for an Amazon EKS cluster in the cluster metadata.
         * </p>
         * 
         * @param awsEksMetadataDetails
         *        The details for an Amazon EKS cluster in the cluster metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsEksMetadataDetails(AwsEksMetadataDetails awsEksMetadataDetails);

        /**
         * <p>
         * The details for an Amazon EKS cluster in the cluster metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEksMetadataDetails.Builder} avoiding
         * the need to create one manually via {@link AwsEksMetadataDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEksMetadataDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #awsEksMetadataDetails(AwsEksMetadataDetails)}.
         * 
         * @param awsEksMetadataDetails
         *        a consumer that will call methods on {@link AwsEksMetadataDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsEksMetadataDetails(AwsEksMetadataDetails)
         */
        default Builder awsEksMetadataDetails(Consumer<AwsEksMetadataDetails.Builder> awsEksMetadataDetails) {
            return awsEksMetadataDetails(AwsEksMetadataDetails.builder().applyMutation(awsEksMetadataDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsEcsMetadataDetails awsEcsMetadataDetails;

        private AwsEksMetadataDetails awsEksMetadataDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterMetadata model) {
            awsEcsMetadataDetails(model.awsEcsMetadataDetails);
            awsEksMetadataDetails(model.awsEksMetadataDetails);
        }

        public final AwsEcsMetadataDetails.Builder getAwsEcsMetadataDetails() {
            return awsEcsMetadataDetails != null ? awsEcsMetadataDetails.toBuilder() : null;
        }

        public final void setAwsEcsMetadataDetails(AwsEcsMetadataDetails.BuilderImpl awsEcsMetadataDetails) {
            Object oldValue = this.awsEcsMetadataDetails;
            this.awsEcsMetadataDetails = awsEcsMetadataDetails != null ? awsEcsMetadataDetails.build() : null;
            handleUnionValueChange(Type.AWS_ECS_METADATA_DETAILS, oldValue, this.awsEcsMetadataDetails);
        }

        @Override
        public final Builder awsEcsMetadataDetails(AwsEcsMetadataDetails awsEcsMetadataDetails) {
            Object oldValue = this.awsEcsMetadataDetails;
            this.awsEcsMetadataDetails = awsEcsMetadataDetails;
            handleUnionValueChange(Type.AWS_ECS_METADATA_DETAILS, oldValue, this.awsEcsMetadataDetails);
            return this;
        }

        public final AwsEksMetadataDetails.Builder getAwsEksMetadataDetails() {
            return awsEksMetadataDetails != null ? awsEksMetadataDetails.toBuilder() : null;
        }

        public final void setAwsEksMetadataDetails(AwsEksMetadataDetails.BuilderImpl awsEksMetadataDetails) {
            Object oldValue = this.awsEksMetadataDetails;
            this.awsEksMetadataDetails = awsEksMetadataDetails != null ? awsEksMetadataDetails.build() : null;
            handleUnionValueChange(Type.AWS_EKS_METADATA_DETAILS, oldValue, this.awsEksMetadataDetails);
        }

        @Override
        public final Builder awsEksMetadataDetails(AwsEksMetadataDetails awsEksMetadataDetails) {
            Object oldValue = this.awsEksMetadataDetails;
            this.awsEksMetadataDetails = awsEksMetadataDetails;
            handleUnionValueChange(Type.AWS_EKS_METADATA_DETAILS, oldValue, this.awsEksMetadataDetails);
            return this;
        }

        @Override
        public ClusterMetadata build() {
            return new ClusterMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ClusterMetadata#type()
     */
    public enum Type {
        AWS_ECS_METADATA_DETAILS,

        AWS_EKS_METADATA_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
