/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response that contains the results of a finding aggregation by code repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeRepositoryAggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeRepositoryAggregationResponse.Builder, CodeRepositoryAggregationResponse> {
    private static final SdkField<String> PROJECT_NAMES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectNames").getter(getter(CodeRepositoryAggregationResponse::projectNames))
            .setter(setter(Builder::projectNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectNames").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerType").getter(getter(CodeRepositoryAggregationResponse::providerType))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerType").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(CodeRepositoryAggregationResponse::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final SdkField<Long> EXPLOIT_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("exploitAvailableActiveFindingsCount")
            .getter(getter(CodeRepositoryAggregationResponse::exploitAvailableActiveFindingsCount))
            .setter(setter(Builder::exploitAvailableActiveFindingsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("exploitAvailableActiveFindingsCount").build()).build();

    private static final SdkField<Long> FIX_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("fixAvailableActiveFindingsCount")
            .getter(getter(CodeRepositoryAggregationResponse::fixAvailableActiveFindingsCount))
            .setter(setter(Builder::fixAvailableActiveFindingsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixAvailableActiveFindingsCount")
                    .build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(CodeRepositoryAggregationResponse::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(CodeRepositoryAggregationResponse::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAMES_FIELD,
            PROVIDER_TYPE_FIELD, SEVERITY_COUNTS_FIELD, EXPLOIT_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD,
            FIX_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD, ACCOUNT_ID_FIELD, RESOURCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String projectNames;

    private final String providerType;

    private final SeverityCounts severityCounts;

    private final Long exploitAvailableActiveFindingsCount;

    private final Long fixAvailableActiveFindingsCount;

    private final String accountId;

    private final String resourceId;

    private CodeRepositoryAggregationResponse(BuilderImpl builder) {
        this.projectNames = builder.projectNames;
        this.providerType = builder.providerType;
        this.severityCounts = builder.severityCounts;
        this.exploitAvailableActiveFindingsCount = builder.exploitAvailableActiveFindingsCount;
        this.fixAvailableActiveFindingsCount = builder.fixAvailableActiveFindingsCount;
        this.accountId = builder.accountId;
        this.resourceId = builder.resourceId;
    }

    /**
     * <p>
     * The names of the projects associated with the code repository.
     * </p>
     * 
     * @return The names of the projects associated with the code repository.
     */
    public final String projectNames() {
        return projectNames;
    }

    /**
     * <p>
     * The type of repository provider for the code repository.
     * </p>
     * 
     * @return The type of repository provider for the code repository.
     */
    public final String providerType() {
        return providerType;
    }

    /**
     * Returns the value of the SeverityCounts property for this object.
     * 
     * @return The value of the SeverityCounts property for this object.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    /**
     * <p>
     * The number of active findings that have an exploit available for the code repository.
     * </p>
     * 
     * @return The number of active findings that have an exploit available for the code repository.
     */
    public final Long exploitAvailableActiveFindingsCount() {
        return exploitAvailableActiveFindingsCount;
    }

    /**
     * <p>
     * The number of active findings that have a fix available for the code repository.
     * </p>
     * 
     * @return The number of active findings that have a fix available for the code repository.
     */
    public final Long fixAvailableActiveFindingsCount() {
        return fixAvailableActiveFindingsCount;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the code repository.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the code repository.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The resource ID of the code repository.
     * </p>
     * 
     * @return The resource ID of the code repository.
     */
    public final String resourceId() {
        return resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectNames());
        hashCode = 31 * hashCode + Objects.hashCode(providerType());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        hashCode = 31 * hashCode + Objects.hashCode(exploitAvailableActiveFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(fixAvailableActiveFindingsCount());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositoryAggregationResponse)) {
            return false;
        }
        CodeRepositoryAggregationResponse other = (CodeRepositoryAggregationResponse) obj;
        return Objects.equals(projectNames(), other.projectNames()) && Objects.equals(providerType(), other.providerType())
                && Objects.equals(severityCounts(), other.severityCounts())
                && Objects.equals(exploitAvailableActiveFindingsCount(), other.exploitAvailableActiveFindingsCount())
                && Objects.equals(fixAvailableActiveFindingsCount(), other.fixAvailableActiveFindingsCount())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(resourceId(), other.resourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeRepositoryAggregationResponse").add("ProjectNames", projectNames())
                .add("ProviderType", providerType()).add("SeverityCounts", severityCounts())
                .add("ExploitAvailableActiveFindingsCount", exploitAvailableActiveFindingsCount())
                .add("FixAvailableActiveFindingsCount", fixAvailableActiveFindingsCount()).add("AccountId", accountId())
                .add("ResourceId", resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectNames":
            return Optional.ofNullable(clazz.cast(projectNames()));
        case "providerType":
            return Optional.ofNullable(clazz.cast(providerType()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        case "exploitAvailableActiveFindingsCount":
            return Optional.ofNullable(clazz.cast(exploitAvailableActiveFindingsCount()));
        case "fixAvailableActiveFindingsCount":
            return Optional.ofNullable(clazz.cast(fixAvailableActiveFindingsCount()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectNames", PROJECT_NAMES_FIELD);
        map.put("providerType", PROVIDER_TYPE_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        map.put("exploitAvailableActiveFindingsCount", EXPLOIT_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD);
        map.put("fixAvailableActiveFindingsCount", FIX_AVAILABLE_ACTIVE_FINDINGS_COUNT_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositoryAggregationResponse, T> g) {
        return obj -> g.apply((CodeRepositoryAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeRepositoryAggregationResponse> {
        /**
         * <p>
         * The names of the projects associated with the code repository.
         * </p>
         * 
         * @param projectNames
         *        The names of the projects associated with the code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectNames(String projectNames);

        /**
         * <p>
         * The type of repository provider for the code repository.
         * </p>
         * 
         * @param providerType
         *        The type of repository provider for the code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerType(String providerType);

        /**
         * Sets the value of the SeverityCounts property for this object.
         *
         * @param severityCounts
         *        The new value for the SeverityCounts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * Sets the value of the SeverityCounts property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }

        /**
         * <p>
         * The number of active findings that have an exploit available for the code repository.
         * </p>
         * 
         * @param exploitAvailableActiveFindingsCount
         *        The number of active findings that have an exploit available for the code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exploitAvailableActiveFindingsCount(Long exploitAvailableActiveFindingsCount);

        /**
         * <p>
         * The number of active findings that have a fix available for the code repository.
         * </p>
         * 
         * @param fixAvailableActiveFindingsCount
         *        The number of active findings that have a fix available for the code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixAvailableActiveFindingsCount(Long fixAvailableActiveFindingsCount);

        /**
         * <p>
         * The Amazon Web Services account ID associated with the code repository.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID associated with the code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The resource ID of the code repository.
         * </p>
         * 
         * @param resourceId
         *        The resource ID of the code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);
    }

    static final class BuilderImpl implements Builder {
        private String projectNames;

        private String providerType;

        private SeverityCounts severityCounts;

        private Long exploitAvailableActiveFindingsCount;

        private Long fixAvailableActiveFindingsCount;

        private String accountId;

        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositoryAggregationResponse model) {
            projectNames(model.projectNames);
            providerType(model.providerType);
            severityCounts(model.severityCounts);
            exploitAvailableActiveFindingsCount(model.exploitAvailableActiveFindingsCount);
            fixAvailableActiveFindingsCount(model.fixAvailableActiveFindingsCount);
            accountId(model.accountId);
            resourceId(model.resourceId);
        }

        public final String getProjectNames() {
            return projectNames;
        }

        public final void setProjectNames(String projectNames) {
            this.projectNames = projectNames;
        }

        @Override
        public final Builder projectNames(String projectNames) {
            this.projectNames = projectNames;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public final Long getExploitAvailableActiveFindingsCount() {
            return exploitAvailableActiveFindingsCount;
        }

        public final void setExploitAvailableActiveFindingsCount(Long exploitAvailableActiveFindingsCount) {
            this.exploitAvailableActiveFindingsCount = exploitAvailableActiveFindingsCount;
        }

        @Override
        public final Builder exploitAvailableActiveFindingsCount(Long exploitAvailableActiveFindingsCount) {
            this.exploitAvailableActiveFindingsCount = exploitAvailableActiveFindingsCount;
            return this;
        }

        public final Long getFixAvailableActiveFindingsCount() {
            return fixAvailableActiveFindingsCount;
        }

        public final void setFixAvailableActiveFindingsCount(Long fixAvailableActiveFindingsCount) {
            this.fixAvailableActiveFindingsCount = fixAvailableActiveFindingsCount;
        }

        @Override
        public final Builder fixAvailableActiveFindingsCount(Long fixAvailableActiveFindingsCount) {
            this.fixAvailableActiveFindingsCount = fixAvailableActiveFindingsCount;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public CodeRepositoryAggregationResponse build() {
            return new CodeRepositoryAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
