/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a code repository associated with a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeRepositoryDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeRepositoryDetails.Builder, CodeRepositoryDetails> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(CodeRepositoryDetails::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationArn").getter(getter(CodeRepositoryDetails::integrationArn))
            .setter(setter(Builder::integrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationArn").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerType").getter(getter(CodeRepositoryDetails::providerTypeAsString))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            INTEGRATION_ARN_FIELD, PROVIDER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String projectName;

    private final String integrationArn;

    private final String providerType;

    private CodeRepositoryDetails(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.integrationArn = builder.integrationArn;
        this.providerType = builder.providerType;
    }

    /**
     * <p>
     * The name of the project in the code repository.
     * </p>
     * 
     * @return The name of the project in the code repository.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the code security integration associated with the repository.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the code security integration associated with the repository.
     */
    public final String integrationArn() {
        return integrationArn;
    }

    /**
     * <p>
     * The type of repository provider (such as GitHub, GitLab, etc.).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link CodeRepositoryProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The type of repository provider (such as GitHub, GitLab, etc.).
     * @see CodeRepositoryProviderType
     */
    public final CodeRepositoryProviderType providerType() {
        return CodeRepositoryProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The type of repository provider (such as GitHub, GitLab, etc.).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link CodeRepositoryProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The type of repository provider (such as GitHub, GitLab, etc.).
     * @see CodeRepositoryProviderType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositoryDetails)) {
            return false;
        }
        CodeRepositoryDetails other = (CodeRepositoryDetails) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(integrationArn(), other.integrationArn())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeRepositoryDetails").add("ProjectName", projectName())
                .add("IntegrationArn", integrationArn()).add("ProviderType", providerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "integrationArn":
            return Optional.ofNullable(clazz.cast(integrationArn()));
        case "providerType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("integrationArn", INTEGRATION_ARN_FIELD);
        map.put("providerType", PROVIDER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositoryDetails, T> g) {
        return obj -> g.apply((CodeRepositoryDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeRepositoryDetails> {
        /**
         * <p>
         * The name of the project in the code repository.
         * </p>
         * 
         * @param projectName
         *        The name of the project in the code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the code security integration associated with the repository.
         * </p>
         * 
         * @param integrationArn
         *        The Amazon Resource Name (ARN) of the code security integration associated with the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationArn(String integrationArn);

        /**
         * <p>
         * The type of repository provider (such as GitHub, GitLab, etc.).
         * </p>
         * 
         * @param providerType
         *        The type of repository provider (such as GitHub, GitLab, etc.).
         * @see CodeRepositoryProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeRepositoryProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The type of repository provider (such as GitHub, GitLab, etc.).
         * </p>
         * 
         * @param providerType
         *        The type of repository provider (such as GitHub, GitLab, etc.).
         * @see CodeRepositoryProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeRepositoryProviderType
         */
        Builder providerType(CodeRepositoryProviderType providerType);
    }

    static final class BuilderImpl implements Builder {
        private String projectName;

        private String integrationArn;

        private String providerType;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositoryDetails model) {
            projectName(model.projectName);
            integrationArn(model.integrationArn);
            providerType(model.providerType);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getIntegrationArn() {
            return integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(CodeRepositoryProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        @Override
        public CodeRepositoryDetails build() {
            return new CodeRepositoryDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
