/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about on-demand scans performed on a code repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeRepositoryOnDemandScan implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeRepositoryOnDemandScan.Builder, CodeRepositoryOnDemandScan> {
    private static final SdkField<String> LAST_SCANNED_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastScannedCommitId").getter(getter(CodeRepositoryOnDemandScan::lastScannedCommitId))
            .setter(setter(Builder::lastScannedCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastScannedCommitId").build())
            .build();

    private static final SdkField<Instant> LAST_SCAN_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastScanAt").getter(getter(CodeRepositoryOnDemandScan::lastScanAt)).setter(setter(Builder::lastScanAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastScanAt").build()).build();

    private static final SdkField<ScanStatus> SCAN_STATUS_FIELD = SdkField.<ScanStatus> builder(MarshallingType.SDK_POJO)
            .memberName("scanStatus").getter(getter(CodeRepositoryOnDemandScan::scanStatus)).setter(setter(Builder::scanStatus))
            .constructor(ScanStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_SCANNED_COMMIT_ID_FIELD,
            LAST_SCAN_AT_FIELD, SCAN_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lastScannedCommitId;

    private final Instant lastScanAt;

    private final ScanStatus scanStatus;

    private CodeRepositoryOnDemandScan(BuilderImpl builder) {
        this.lastScannedCommitId = builder.lastScannedCommitId;
        this.lastScanAt = builder.lastScanAt;
        this.scanStatus = builder.scanStatus;
    }

    /**
     * <p>
     * The ID of the last commit that was scanned during an on-demand scan.
     * </p>
     * 
     * @return The ID of the last commit that was scanned during an on-demand scan.
     */
    public final String lastScannedCommitId() {
        return lastScannedCommitId;
    }

    /**
     * <p>
     * The timestamp when the last on-demand scan was performed.
     * </p>
     * 
     * @return The timestamp when the last on-demand scan was performed.
     */
    public final Instant lastScanAt() {
        return lastScanAt;
    }

    /**
     * Returns the value of the ScanStatus property for this object.
     * 
     * @return The value of the ScanStatus property for this object.
     */
    public final ScanStatus scanStatus() {
        return scanStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastScannedCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(lastScanAt());
        hashCode = 31 * hashCode + Objects.hashCode(scanStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositoryOnDemandScan)) {
            return false;
        }
        CodeRepositoryOnDemandScan other = (CodeRepositoryOnDemandScan) obj;
        return Objects.equals(lastScannedCommitId(), other.lastScannedCommitId())
                && Objects.equals(lastScanAt(), other.lastScanAt()) && Objects.equals(scanStatus(), other.scanStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeRepositoryOnDemandScan").add("LastScannedCommitId", lastScannedCommitId())
                .add("LastScanAt", lastScanAt()).add("ScanStatus", scanStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastScannedCommitId":
            return Optional.ofNullable(clazz.cast(lastScannedCommitId()));
        case "lastScanAt":
            return Optional.ofNullable(clazz.cast(lastScanAt()));
        case "scanStatus":
            return Optional.ofNullable(clazz.cast(scanStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lastScannedCommitId", LAST_SCANNED_COMMIT_ID_FIELD);
        map.put("lastScanAt", LAST_SCAN_AT_FIELD);
        map.put("scanStatus", SCAN_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositoryOnDemandScan, T> g) {
        return obj -> g.apply((CodeRepositoryOnDemandScan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeRepositoryOnDemandScan> {
        /**
         * <p>
         * The ID of the last commit that was scanned during an on-demand scan.
         * </p>
         * 
         * @param lastScannedCommitId
         *        The ID of the last commit that was scanned during an on-demand scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastScannedCommitId(String lastScannedCommitId);

        /**
         * <p>
         * The timestamp when the last on-demand scan was performed.
         * </p>
         * 
         * @param lastScanAt
         *        The timestamp when the last on-demand scan was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastScanAt(Instant lastScanAt);

        /**
         * Sets the value of the ScanStatus property for this object.
         *
         * @param scanStatus
         *        The new value for the ScanStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanStatus(ScanStatus scanStatus);

        /**
         * Sets the value of the ScanStatus property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ScanStatus.Builder} avoiding the need to
         * create one manually via {@link ScanStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScanStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #scanStatus(ScanStatus)}.
         * 
         * @param scanStatus
         *        a consumer that will call methods on {@link ScanStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanStatus(ScanStatus)
         */
        default Builder scanStatus(Consumer<ScanStatus.Builder> scanStatus) {
            return scanStatus(ScanStatus.builder().applyMutation(scanStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String lastScannedCommitId;

        private Instant lastScanAt;

        private ScanStatus scanStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositoryOnDemandScan model) {
            lastScannedCommitId(model.lastScannedCommitId);
            lastScanAt(model.lastScanAt);
            scanStatus(model.scanStatus);
        }

        public final String getLastScannedCommitId() {
            return lastScannedCommitId;
        }

        public final void setLastScannedCommitId(String lastScannedCommitId) {
            this.lastScannedCommitId = lastScannedCommitId;
        }

        @Override
        public final Builder lastScannedCommitId(String lastScannedCommitId) {
            this.lastScannedCommitId = lastScannedCommitId;
            return this;
        }

        public final Instant getLastScanAt() {
            return lastScanAt;
        }

        public final void setLastScanAt(Instant lastScanAt) {
            this.lastScanAt = lastScanAt;
        }

        @Override
        public final Builder lastScanAt(Instant lastScanAt) {
            this.lastScanAt = lastScanAt;
            return this;
        }

        public final ScanStatus.Builder getScanStatus() {
            return scanStatus != null ? scanStatus.toBuilder() : null;
        }

        public final void setScanStatus(ScanStatus.BuilderImpl scanStatus) {
            this.scanStatus = scanStatus != null ? scanStatus.build() : null;
        }

        @Override
        public final Builder scanStatus(ScanStatus scanStatus) {
            this.scanStatus = scanStatus;
            return this;
        }

        @Override
        public CodeRepositoryOnDemandScan build() {
            return new CodeRepositoryOnDemandScan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
