/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a code security scan configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSecurityScanConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeSecurityScanConfigurationSummary.Builder, CodeSecurityScanConfigurationSummary> {
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanConfigurationArn").getter(getter(CodeSecurityScanConfigurationSummary::scanConfigurationArn))
            .setter(setter(Builder::scanConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CodeSecurityScanConfigurationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccountId").getter(getter(CodeSecurityScanConfigurationSummary::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()).build();

    private static final SdkField<String> PERIODIC_SCAN_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("periodicScanFrequency")
            .getter(getter(CodeSecurityScanConfigurationSummary::periodicScanFrequencyAsString))
            .setter(setter(Builder::periodicScanFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodicScanFrequency").build())
            .build();

    private static final SdkField<String> FREQUENCY_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frequencyExpression").getter(getter(CodeSecurityScanConfigurationSummary::frequencyExpression))
            .setter(setter(Builder::frequencyExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequencyExpression").build())
            .build();

    private static final SdkField<List<String>> CONTINUOUS_INTEGRATION_SCAN_SUPPORTED_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("continuousIntegrationScanSupportedEvents")
            .getter(getter(CodeSecurityScanConfigurationSummary::continuousIntegrationScanSupportedEventsAsStrings))
            .setter(setter(Builder::continuousIntegrationScanSupportedEventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("continuousIntegrationScanSupportedEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RULE_SET_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ruleSetCategories")
            .getter(getter(CodeSecurityScanConfigurationSummary::ruleSetCategoriesAsStrings))
            .setter(setter(Builder::ruleSetCategoriesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleSetCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ScopeSettings> SCOPE_SETTINGS_FIELD = SdkField
            .<ScopeSettings> builder(MarshallingType.SDK_POJO).memberName("scopeSettings")
            .getter(getter(CodeSecurityScanConfigurationSummary::scopeSettings)).setter(setter(Builder::scopeSettings))
            .constructor(ScopeSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scopeSettings").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CodeSecurityScanConfigurationSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_CONFIGURATION_ARN_FIELD,
            NAME_FIELD, OWNER_ACCOUNT_ID_FIELD, PERIODIC_SCAN_FREQUENCY_FIELD, FREQUENCY_EXPRESSION_FIELD,
            CONTINUOUS_INTEGRATION_SCAN_SUPPORTED_EVENTS_FIELD, RULE_SET_CATEGORIES_FIELD, SCOPE_SETTINGS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scanConfigurationArn;

    private final String name;

    private final String ownerAccountId;

    private final String periodicScanFrequency;

    private final String frequencyExpression;

    private final List<String> continuousIntegrationScanSupportedEvents;

    private final List<String> ruleSetCategories;

    private final ScopeSettings scopeSettings;

    private final Map<String, String> tags;

    private CodeSecurityScanConfigurationSummary(BuilderImpl builder) {
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.name = builder.name;
        this.ownerAccountId = builder.ownerAccountId;
        this.periodicScanFrequency = builder.periodicScanFrequency;
        this.frequencyExpression = builder.frequencyExpression;
        this.continuousIntegrationScanSupportedEvents = builder.continuousIntegrationScanSupportedEvents;
        this.ruleSetCategories = builder.ruleSetCategories;
        this.scopeSettings = builder.scopeSettings;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scan configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scan configuration.
     */
    public final String scanConfigurationArn() {
        return scanConfigurationArn;
    }

    /**
     * <p>
     * The name of the scan configuration.
     * </p>
     * 
     * @return The name of the scan configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the scan configuration.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the scan configuration.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The frequency at which periodic scans are performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #periodicScanFrequency} will return {@link PeriodicScanFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #periodicScanFrequencyAsString}.
     * </p>
     * 
     * @return The frequency at which periodic scans are performed.
     * @see PeriodicScanFrequency
     */
    public final PeriodicScanFrequency periodicScanFrequency() {
        return PeriodicScanFrequency.fromValue(periodicScanFrequency);
    }

    /**
     * <p>
     * The frequency at which periodic scans are performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #periodicScanFrequency} will return {@link PeriodicScanFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #periodicScanFrequencyAsString}.
     * </p>
     * 
     * @return The frequency at which periodic scans are performed.
     * @see PeriodicScanFrequency
     */
    public final String periodicScanFrequencyAsString() {
        return periodicScanFrequency;
    }

    /**
     * <p>
     * The schedule expression for periodic scans, in cron format.
     * </p>
     * 
     * @return The schedule expression for periodic scans, in cron format.
     */
    public final String frequencyExpression() {
        return frequencyExpression;
    }

    /**
     * <p>
     * The repository events that trigger continuous integration scans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasContinuousIntegrationScanSupportedEvents} method.
     * </p>
     * 
     * @return The repository events that trigger continuous integration scans.
     */
    public final List<ContinuousIntegrationScanEvent> continuousIntegrationScanSupportedEvents() {
        return ContinuousIntegrationScanSupportedEventsCopier.copyStringToEnum(continuousIntegrationScanSupportedEvents);
    }

    /**
     * For responses, this returns true if the service returned a value for the ContinuousIntegrationScanSupportedEvents
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasContinuousIntegrationScanSupportedEvents() {
        return continuousIntegrationScanSupportedEvents != null
                && !(continuousIntegrationScanSupportedEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The repository events that trigger continuous integration scans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasContinuousIntegrationScanSupportedEvents} method.
     * </p>
     * 
     * @return The repository events that trigger continuous integration scans.
     */
    public final List<String> continuousIntegrationScanSupportedEventsAsStrings() {
        return continuousIntegrationScanSupportedEvents;
    }

    /**
     * <p>
     * The categories of security rules applied during the scan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleSetCategories} method.
     * </p>
     * 
     * @return The categories of security rules applied during the scan.
     */
    public final List<RuleSetCategory> ruleSetCategories() {
        return RuleSetCategoriesCopier.copyStringToEnum(ruleSetCategories);
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleSetCategories property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleSetCategories() {
        return ruleSetCategories != null && !(ruleSetCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The categories of security rules applied during the scan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleSetCategories} method.
     * </p>
     * 
     * @return The categories of security rules applied during the scan.
     */
    public final List<String> ruleSetCategoriesAsStrings() {
        return ruleSetCategories;
    }

    /**
     * <p>
     * The scope settings that define which repositories will be scanned. If the <code>ScopeSetting</code> parameter is
     * <code>ALL</code> the scan configuration applies to all existing and future projects imported into Amazon
     * Inspector.
     * </p>
     * 
     * @return The scope settings that define which repositories will be scanned. If the <code>ScopeSetting</code>
     *         parameter is <code>ALL</code> the scan configuration applies to all existing and future projects imported
     *         into Amazon Inspector.
     */
    public final ScopeSettings scopeSettings() {
        return scopeSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the scan configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the scan configuration.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(periodicScanFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(frequencyExpression());
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasContinuousIntegrationScanSupportedEvents() ? continuousIntegrationScanSupportedEventsAsStrings()
                                : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleSetCategories() ? ruleSetCategoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scopeSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSecurityScanConfigurationSummary)) {
            return false;
        }
        CodeSecurityScanConfigurationSummary other = (CodeSecurityScanConfigurationSummary) obj;
        return Objects.equals(scanConfigurationArn(), other.scanConfigurationArn())
                && Objects.equals(name(), other.name())
                && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(periodicScanFrequencyAsString(), other.periodicScanFrequencyAsString())
                && Objects.equals(frequencyExpression(), other.frequencyExpression())
                && hasContinuousIntegrationScanSupportedEvents() == other.hasContinuousIntegrationScanSupportedEvents()
                && Objects.equals(continuousIntegrationScanSupportedEventsAsStrings(),
                        other.continuousIntegrationScanSupportedEventsAsStrings())
                && hasRuleSetCategories() == other.hasRuleSetCategories()
                && Objects.equals(ruleSetCategoriesAsStrings(), other.ruleSetCategoriesAsStrings())
                && Objects.equals(scopeSettings(), other.scopeSettings()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CodeSecurityScanConfigurationSummary")
                .add("ScanConfigurationArn", scanConfigurationArn())
                .add("Name", name())
                .add("OwnerAccountId", ownerAccountId())
                .add("PeriodicScanFrequency", periodicScanFrequencyAsString())
                .add("FrequencyExpression", frequencyExpression())
                .add("ContinuousIntegrationScanSupportedEvents",
                        hasContinuousIntegrationScanSupportedEvents() ? continuousIntegrationScanSupportedEventsAsStrings()
                                : null).add("RuleSetCategories", hasRuleSetCategories() ? ruleSetCategoriesAsStrings() : null)
                .add("ScopeSettings", scopeSettings()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanConfigurationArn":
            return Optional.ofNullable(clazz.cast(scanConfigurationArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ownerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "periodicScanFrequency":
            return Optional.ofNullable(clazz.cast(periodicScanFrequencyAsString()));
        case "frequencyExpression":
            return Optional.ofNullable(clazz.cast(frequencyExpression()));
        case "continuousIntegrationScanSupportedEvents":
            return Optional.ofNullable(clazz.cast(continuousIntegrationScanSupportedEventsAsStrings()));
        case "ruleSetCategories":
            return Optional.ofNullable(clazz.cast(ruleSetCategoriesAsStrings()));
        case "scopeSettings":
            return Optional.ofNullable(clazz.cast(scopeSettings()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("periodicScanFrequency", PERIODIC_SCAN_FREQUENCY_FIELD);
        map.put("frequencyExpression", FREQUENCY_EXPRESSION_FIELD);
        map.put("continuousIntegrationScanSupportedEvents", CONTINUOUS_INTEGRATION_SCAN_SUPPORTED_EVENTS_FIELD);
        map.put("ruleSetCategories", RULE_SET_CATEGORIES_FIELD);
        map.put("scopeSettings", SCOPE_SETTINGS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeSecurityScanConfigurationSummary, T> g) {
        return obj -> g.apply((CodeSecurityScanConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeSecurityScanConfigurationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scan configuration.
         * </p>
         * 
         * @param scanConfigurationArn
         *        The Amazon Resource Name (ARN) of the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArn(String scanConfigurationArn);

        /**
         * <p>
         * The name of the scan configuration.
         * </p>
         * 
         * @param name
         *        The name of the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the scan configuration.
         * </p>
         * 
         * @param ownerAccountId
         *        The Amazon Web Services account ID that owns the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The frequency at which periodic scans are performed.
         * </p>
         * 
         * @param periodicScanFrequency
         *        The frequency at which periodic scans are performed.
         * @see PeriodicScanFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodicScanFrequency
         */
        Builder periodicScanFrequency(String periodicScanFrequency);

        /**
         * <p>
         * The frequency at which periodic scans are performed.
         * </p>
         * 
         * @param periodicScanFrequency
         *        The frequency at which periodic scans are performed.
         * @see PeriodicScanFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PeriodicScanFrequency
         */
        Builder periodicScanFrequency(PeriodicScanFrequency periodicScanFrequency);

        /**
         * <p>
         * The schedule expression for periodic scans, in cron format.
         * </p>
         * 
         * @param frequencyExpression
         *        The schedule expression for periodic scans, in cron format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequencyExpression(String frequencyExpression);

        /**
         * <p>
         * The repository events that trigger continuous integration scans.
         * </p>
         * 
         * @param continuousIntegrationScanSupportedEvents
         *        The repository events that trigger continuous integration scans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousIntegrationScanSupportedEventsWithStrings(Collection<String> continuousIntegrationScanSupportedEvents);

        /**
         * <p>
         * The repository events that trigger continuous integration scans.
         * </p>
         * 
         * @param continuousIntegrationScanSupportedEvents
         *        The repository events that trigger continuous integration scans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousIntegrationScanSupportedEventsWithStrings(String... continuousIntegrationScanSupportedEvents);

        /**
         * <p>
         * The repository events that trigger continuous integration scans.
         * </p>
         * 
         * @param continuousIntegrationScanSupportedEvents
         *        The repository events that trigger continuous integration scans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousIntegrationScanSupportedEvents(
                Collection<ContinuousIntegrationScanEvent> continuousIntegrationScanSupportedEvents);

        /**
         * <p>
         * The repository events that trigger continuous integration scans.
         * </p>
         * 
         * @param continuousIntegrationScanSupportedEvents
         *        The repository events that trigger continuous integration scans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousIntegrationScanSupportedEvents(
                ContinuousIntegrationScanEvent... continuousIntegrationScanSupportedEvents);

        /**
         * <p>
         * The categories of security rules applied during the scan.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules applied during the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategoriesWithStrings(Collection<String> ruleSetCategories);

        /**
         * <p>
         * The categories of security rules applied during the scan.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules applied during the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategoriesWithStrings(String... ruleSetCategories);

        /**
         * <p>
         * The categories of security rules applied during the scan.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules applied during the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategories(Collection<RuleSetCategory> ruleSetCategories);

        /**
         * <p>
         * The categories of security rules applied during the scan.
         * </p>
         * 
         * @param ruleSetCategories
         *        The categories of security rules applied during the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetCategories(RuleSetCategory... ruleSetCategories);

        /**
         * <p>
         * The scope settings that define which repositories will be scanned. If the <code>ScopeSetting</code> parameter
         * is <code>ALL</code> the scan configuration applies to all existing and future projects imported into Amazon
         * Inspector.
         * </p>
         * 
         * @param scopeSettings
         *        The scope settings that define which repositories will be scanned. If the <code>ScopeSetting</code>
         *        parameter is <code>ALL</code> the scan configuration applies to all existing and future projects
         *        imported into Amazon Inspector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopeSettings(ScopeSettings scopeSettings);

        /**
         * <p>
         * The scope settings that define which repositories will be scanned. If the <code>ScopeSetting</code> parameter
         * is <code>ALL</code> the scan configuration applies to all existing and future projects imported into Amazon
         * Inspector.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScopeSettings.Builder} avoiding the need
         * to create one manually via {@link ScopeSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScopeSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #scopeSettings(ScopeSettings)}.
         * 
         * @param scopeSettings
         *        a consumer that will call methods on {@link ScopeSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scopeSettings(ScopeSettings)
         */
        default Builder scopeSettings(Consumer<ScopeSettings.Builder> scopeSettings) {
            return scopeSettings(ScopeSettings.builder().applyMutation(scopeSettings).build());
        }

        /**
         * <p>
         * The tags associated with the scan configuration.
         * </p>
         * 
         * @param tags
         *        The tags associated with the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String scanConfigurationArn;

        private String name;

        private String ownerAccountId;

        private String periodicScanFrequency;

        private String frequencyExpression;

        private List<String> continuousIntegrationScanSupportedEvents = DefaultSdkAutoConstructList.getInstance();

        private List<String> ruleSetCategories = DefaultSdkAutoConstructList.getInstance();

        private ScopeSettings scopeSettings;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSecurityScanConfigurationSummary model) {
            scanConfigurationArn(model.scanConfigurationArn);
            name(model.name);
            ownerAccountId(model.ownerAccountId);
            periodicScanFrequency(model.periodicScanFrequency);
            frequencyExpression(model.frequencyExpression);
            continuousIntegrationScanSupportedEventsWithStrings(model.continuousIntegrationScanSupportedEvents);
            ruleSetCategoriesWithStrings(model.ruleSetCategories);
            scopeSettings(model.scopeSettings);
            tags(model.tags);
        }

        public final String getScanConfigurationArn() {
            return scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getPeriodicScanFrequency() {
            return periodicScanFrequency;
        }

        public final void setPeriodicScanFrequency(String periodicScanFrequency) {
            this.periodicScanFrequency = periodicScanFrequency;
        }

        @Override
        public final Builder periodicScanFrequency(String periodicScanFrequency) {
            this.periodicScanFrequency = periodicScanFrequency;
            return this;
        }

        @Override
        public final Builder periodicScanFrequency(PeriodicScanFrequency periodicScanFrequency) {
            this.periodicScanFrequency(periodicScanFrequency == null ? null : periodicScanFrequency.toString());
            return this;
        }

        public final String getFrequencyExpression() {
            return frequencyExpression;
        }

        public final void setFrequencyExpression(String frequencyExpression) {
            this.frequencyExpression = frequencyExpression;
        }

        @Override
        public final Builder frequencyExpression(String frequencyExpression) {
            this.frequencyExpression = frequencyExpression;
            return this;
        }

        public final Collection<String> getContinuousIntegrationScanSupportedEvents() {
            if (continuousIntegrationScanSupportedEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return continuousIntegrationScanSupportedEvents;
        }

        public final void setContinuousIntegrationScanSupportedEvents(Collection<String> continuousIntegrationScanSupportedEvents) {
            this.continuousIntegrationScanSupportedEvents = ContinuousIntegrationScanSupportedEventsCopier
                    .copy(continuousIntegrationScanSupportedEvents);
        }

        @Override
        public final Builder continuousIntegrationScanSupportedEventsWithStrings(
                Collection<String> continuousIntegrationScanSupportedEvents) {
            this.continuousIntegrationScanSupportedEvents = ContinuousIntegrationScanSupportedEventsCopier
                    .copy(continuousIntegrationScanSupportedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousIntegrationScanSupportedEventsWithStrings(
                String... continuousIntegrationScanSupportedEvents) {
            continuousIntegrationScanSupportedEventsWithStrings(Arrays.asList(continuousIntegrationScanSupportedEvents));
            return this;
        }

        @Override
        public final Builder continuousIntegrationScanSupportedEvents(
                Collection<ContinuousIntegrationScanEvent> continuousIntegrationScanSupportedEvents) {
            this.continuousIntegrationScanSupportedEvents = ContinuousIntegrationScanSupportedEventsCopier
                    .copyEnumToString(continuousIntegrationScanSupportedEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousIntegrationScanSupportedEvents(
                ContinuousIntegrationScanEvent... continuousIntegrationScanSupportedEvents) {
            continuousIntegrationScanSupportedEvents(Arrays.asList(continuousIntegrationScanSupportedEvents));
            return this;
        }

        public final Collection<String> getRuleSetCategories() {
            if (ruleSetCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleSetCategories;
        }

        public final void setRuleSetCategories(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
        }

        @Override
        public final Builder ruleSetCategoriesWithStrings(Collection<String> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copy(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategoriesWithStrings(String... ruleSetCategories) {
            ruleSetCategoriesWithStrings(Arrays.asList(ruleSetCategories));
            return this;
        }

        @Override
        public final Builder ruleSetCategories(Collection<RuleSetCategory> ruleSetCategories) {
            this.ruleSetCategories = RuleSetCategoriesCopier.copyEnumToString(ruleSetCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSetCategories(RuleSetCategory... ruleSetCategories) {
            ruleSetCategories(Arrays.asList(ruleSetCategories));
            return this;
        }

        public final ScopeSettings.Builder getScopeSettings() {
            return scopeSettings != null ? scopeSettings.toBuilder() : null;
        }

        public final void setScopeSettings(ScopeSettings.BuilderImpl scopeSettings) {
            this.scopeSettings = scopeSettings != null ? scopeSettings.build() : null;
        }

        @Override
        public final Builder scopeSettings(ScopeSettings scopeSettings) {
            this.scopeSettings = scopeSettings;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CodeSecurityScanConfigurationSummary build() {
            return new CodeSecurityScanConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
