/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that identifies filter criteria for <code>GetCoverageStatistics</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageFilterCriteria.Builder, CoverageFilterCriteria> {
    private static final SdkField<List<CoverageStringFilter>> SCAN_STATUS_CODE_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("scanStatusCode")
            .getter(getter(CoverageFilterCriteria::scanStatusCode))
            .setter(setter(Builder::scanStatusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatusCode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> SCAN_STATUS_REASON_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("scanStatusReason")
            .getter(getter(CoverageFilterCriteria::scanStatusReason))
            .setter(setter(Builder::scanStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanStatusReason").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> ACCOUNT_ID_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("accountId")
            .getter(getter(CoverageFilterCriteria::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> RESOURCE_ID_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("resourceId")
            .getter(getter(CoverageFilterCriteria::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> RESOURCE_TYPE_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("resourceType")
            .getter(getter(CoverageFilterCriteria::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> SCAN_TYPE_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("scanType")
            .getter(getter(CoverageFilterCriteria::scanType))
            .setter(setter(Builder::scanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> ECR_REPOSITORY_NAME_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("ecrRepositoryName")
            .getter(getter(CoverageFilterCriteria::ecrRepositoryName))
            .setter(setter(Builder::ecrRepositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> ECR_IMAGE_TAGS_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("ecrImageTags")
            .getter(getter(CoverageFilterCriteria::ecrImageTags))
            .setter(setter(Builder::ecrImageTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImageTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageMapFilter>> EC2_INSTANCE_TAGS_FIELD = SdkField
            .<List<CoverageMapFilter>> builder(MarshallingType.LIST)
            .memberName("ec2InstanceTags")
            .getter(getter(CoverageFilterCriteria::ec2InstanceTags))
            .setter(setter(Builder::ec2InstanceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageMapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageMapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> LAMBDA_FUNCTION_NAME_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("lambdaFunctionName")
            .getter(getter(CoverageFilterCriteria::lambdaFunctionName))
            .setter(setter(Builder::lambdaFunctionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageMapFilter>> LAMBDA_FUNCTION_TAGS_FIELD = SdkField
            .<List<CoverageMapFilter>> builder(MarshallingType.LIST)
            .memberName("lambdaFunctionTags")
            .getter(getter(CoverageFilterCriteria::lambdaFunctionTags))
            .setter(setter(Builder::lambdaFunctionTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageMapFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageMapFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> LAMBDA_FUNCTION_RUNTIME_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("lambdaFunctionRuntime")
            .getter(getter(CoverageFilterCriteria::lambdaFunctionRuntime))
            .setter(setter(Builder::lambdaFunctionRuntime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionRuntime").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageDateFilter>> LAST_SCANNED_AT_FIELD = SdkField
            .<List<CoverageDateFilter>> builder(MarshallingType.LIST)
            .memberName("lastScannedAt")
            .getter(getter(CoverageFilterCriteria::lastScannedAt))
            .setter(setter(Builder::lastScannedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastScannedAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageDateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageDateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> SCAN_MODE_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("scanMode")
            .getter(getter(CoverageFilterCriteria::scanMode))
            .setter(setter(Builder::scanMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanMode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageDateFilter>> IMAGE_PULLED_AT_FIELD = SdkField
            .<List<CoverageDateFilter>> builder(MarshallingType.LIST)
            .memberName("imagePulledAt")
            .getter(getter(CoverageFilterCriteria::imagePulledAt))
            .setter(setter(Builder::imagePulledAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePulledAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageDateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageDateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageDateFilter>> ECR_IMAGE_LAST_IN_USE_AT_FIELD = SdkField
            .<List<CoverageDateFilter>> builder(MarshallingType.LIST)
            .memberName("ecrImageLastInUseAt")
            .getter(getter(CoverageFilterCriteria::ecrImageLastInUseAt))
            .setter(setter(Builder::ecrImageLastInUseAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImageLastInUseAt").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageDateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageDateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageNumberFilter>> ECR_IMAGE_IN_USE_COUNT_FIELD = SdkField
            .<List<CoverageNumberFilter>> builder(MarshallingType.LIST)
            .memberName("ecrImageInUseCount")
            .getter(getter(CoverageFilterCriteria::ecrImageInUseCount))
            .setter(setter(Builder::ecrImageInUseCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImageInUseCount").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageNumberFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageNumberFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> CODE_REPOSITORY_PROJECT_NAME_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("codeRepositoryProjectName")
            .getter(getter(CoverageFilterCriteria::codeRepositoryProjectName))
            .setter(setter(Builder::codeRepositoryProjectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeRepositoryProjectName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> CODE_REPOSITORY_PROVIDER_TYPE_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("codeRepositoryProviderType")
            .getter(getter(CoverageFilterCriteria::codeRepositoryProviderType))
            .setter(setter(Builder::codeRepositoryProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeRepositoryProviderType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> CODE_REPOSITORY_PROVIDER_TYPE_VISIBILITY_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("codeRepositoryProviderTypeVisibility")
            .getter(getter(CoverageFilterCriteria::codeRepositoryProviderTypeVisibility))
            .setter(setter(Builder::codeRepositoryProviderTypeVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("codeRepositoryProviderTypeVisibility").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CoverageStringFilter>> LAST_SCANNED_COMMIT_ID_FIELD = SdkField
            .<List<CoverageStringFilter>> builder(MarshallingType.LIST)
            .memberName("lastScannedCommitId")
            .getter(getter(CoverageFilterCriteria::lastScannedCommitId))
            .setter(setter(Builder::lastScannedCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastScannedCommitId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CoverageStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CoverageStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_STATUS_CODE_FIELD,
            SCAN_STATUS_REASON_FIELD, ACCOUNT_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, SCAN_TYPE_FIELD,
            ECR_REPOSITORY_NAME_FIELD, ECR_IMAGE_TAGS_FIELD, EC2_INSTANCE_TAGS_FIELD, LAMBDA_FUNCTION_NAME_FIELD,
            LAMBDA_FUNCTION_TAGS_FIELD, LAMBDA_FUNCTION_RUNTIME_FIELD, LAST_SCANNED_AT_FIELD, SCAN_MODE_FIELD,
            IMAGE_PULLED_AT_FIELD, ECR_IMAGE_LAST_IN_USE_AT_FIELD, ECR_IMAGE_IN_USE_COUNT_FIELD,
            CODE_REPOSITORY_PROJECT_NAME_FIELD, CODE_REPOSITORY_PROVIDER_TYPE_FIELD,
            CODE_REPOSITORY_PROVIDER_TYPE_VISIBILITY_FIELD, LAST_SCANNED_COMMIT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CoverageStringFilter> scanStatusCode;

    private final List<CoverageStringFilter> scanStatusReason;

    private final List<CoverageStringFilter> accountId;

    private final List<CoverageStringFilter> resourceId;

    private final List<CoverageStringFilter> resourceType;

    private final List<CoverageStringFilter> scanType;

    private final List<CoverageStringFilter> ecrRepositoryName;

    private final List<CoverageStringFilter> ecrImageTags;

    private final List<CoverageMapFilter> ec2InstanceTags;

    private final List<CoverageStringFilter> lambdaFunctionName;

    private final List<CoverageMapFilter> lambdaFunctionTags;

    private final List<CoverageStringFilter> lambdaFunctionRuntime;

    private final List<CoverageDateFilter> lastScannedAt;

    private final List<CoverageStringFilter> scanMode;

    private final List<CoverageDateFilter> imagePulledAt;

    private final List<CoverageDateFilter> ecrImageLastInUseAt;

    private final List<CoverageNumberFilter> ecrImageInUseCount;

    private final List<CoverageStringFilter> codeRepositoryProjectName;

    private final List<CoverageStringFilter> codeRepositoryProviderType;

    private final List<CoverageStringFilter> codeRepositoryProviderTypeVisibility;

    private final List<CoverageStringFilter> lastScannedCommitId;

    private CoverageFilterCriteria(BuilderImpl builder) {
        this.scanStatusCode = builder.scanStatusCode;
        this.scanStatusReason = builder.scanStatusReason;
        this.accountId = builder.accountId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.scanType = builder.scanType;
        this.ecrRepositoryName = builder.ecrRepositoryName;
        this.ecrImageTags = builder.ecrImageTags;
        this.ec2InstanceTags = builder.ec2InstanceTags;
        this.lambdaFunctionName = builder.lambdaFunctionName;
        this.lambdaFunctionTags = builder.lambdaFunctionTags;
        this.lambdaFunctionRuntime = builder.lambdaFunctionRuntime;
        this.lastScannedAt = builder.lastScannedAt;
        this.scanMode = builder.scanMode;
        this.imagePulledAt = builder.imagePulledAt;
        this.ecrImageLastInUseAt = builder.ecrImageLastInUseAt;
        this.ecrImageInUseCount = builder.ecrImageInUseCount;
        this.codeRepositoryProjectName = builder.codeRepositoryProjectName;
        this.codeRepositoryProviderType = builder.codeRepositoryProviderType;
        this.codeRepositoryProviderTypeVisibility = builder.codeRepositoryProviderTypeVisibility;
        this.lastScannedCommitId = builder.lastScannedCommitId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanStatusCode property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanStatusCode() {
        return scanStatusCode != null && !(scanStatusCode instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scan status code to filter on. Valid values are: <code>ValidationException</code>,
     * <code>InternalServerException</code>, <code>ResourceNotFoundException</code>, <code>BadRequestException</code>,
     * and <code>ThrottlingException</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanStatusCode} method.
     * </p>
     * 
     * @return The scan status code to filter on. Valid values are: <code>ValidationException</code>,
     *         <code>InternalServerException</code>, <code>ResourceNotFoundException</code>,
     *         <code>BadRequestException</code>, and <code>ThrottlingException</code>.
     */
    public final List<CoverageStringFilter> scanStatusCode() {
        return scanStatusCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanStatusReason property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScanStatusReason() {
        return scanStatusReason != null && !(scanStatusReason instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scan status reason to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanStatusReason} method.
     * </p>
     * 
     * @return The scan status reason to filter on.
     */
    public final List<CoverageStringFilter> scanStatusReason() {
        return scanStatusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountId property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountId() {
        return accountId != null && !(accountId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Web Services account IDs to return coverage statistics for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountId} method.
     * </p>
     * 
     * @return An array of Amazon Web Services account IDs to return coverage statistics for.
     */
    public final List<CoverageStringFilter> accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceId property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResourceId() {
        return resourceId != null && !(resourceId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Web Services resource IDs to return coverage statistics for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceId} method.
     * </p>
     * 
     * @return An array of Amazon Web Services resource IDs to return coverage statistics for.
     */
    public final List<CoverageStringFilter> resourceId() {
        return resourceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceType() {
        return resourceType != null && !(resourceType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Web Services resource types to return coverage statistics for. The values can be
     * <code>AWS_EC2_INSTANCE</code>, <code>AWS_LAMBDA_FUNCTION</code>, <code>AWS_ECR_CONTAINER_IMAGE</code>,
     * <code>AWS_ECR_REPOSITORY</code> or <code>AWS_ACCOUNT</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceType} method.
     * </p>
     * 
     * @return An array of Amazon Web Services resource types to return coverage statistics for. The values can be
     *         <code>AWS_EC2_INSTANCE</code>, <code>AWS_LAMBDA_FUNCTION</code>, <code>AWS_ECR_CONTAINER_IMAGE</code>,
     *         <code>AWS_ECR_REPOSITORY</code> or <code>AWS_ACCOUNT</code>.
     */
    public final List<CoverageStringFilter> resourceType() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanType property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScanType() {
        return scanType != null && !(scanType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon Inspector scan types to return coverage statistics for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanType} method.
     * </p>
     * 
     * @return An array of Amazon Inspector scan types to return coverage statistics for.
     */
    public final List<CoverageStringFilter> scanType() {
        return scanType;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrRepositoryName property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcrRepositoryName() {
        return ecrRepositoryName != null && !(ecrRepositoryName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon ECR repository name to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrRepositoryName} method.
     * </p>
     * 
     * @return The Amazon ECR repository name to filter on.
     */
    public final List<CoverageStringFilter> ecrRepositoryName() {
        return ecrRepositoryName;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrImageTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcrImageTags() {
        return ecrImageTags != null && !(ecrImageTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon ECR image tags to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrImageTags} method.
     * </p>
     * 
     * @return The Amazon ECR image tags to filter on.
     */
    public final List<CoverageStringFilter> ecrImageTags() {
        return ecrImageTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ec2InstanceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2InstanceTags() {
        return ec2InstanceTags != null && !(ec2InstanceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon EC2 instance tags to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2InstanceTags} method.
     * </p>
     * 
     * @return The Amazon EC2 instance tags to filter on.
     */
    public final List<CoverageMapFilter> ec2InstanceTags() {
        return ec2InstanceTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the LambdaFunctionName property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLambdaFunctionName() {
        return lambdaFunctionName != null && !(lambdaFunctionName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns coverage statistics for Amazon Web Services Lambda functions filtered by function names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLambdaFunctionName} method.
     * </p>
     * 
     * @return Returns coverage statistics for Amazon Web Services Lambda functions filtered by function names.
     */
    public final List<CoverageStringFilter> lambdaFunctionName() {
        return lambdaFunctionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LambdaFunctionTags property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLambdaFunctionTags() {
        return lambdaFunctionTags != null && !(lambdaFunctionTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns coverage statistics for Amazon Web Services Lambda functions filtered by tag.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLambdaFunctionTags} method.
     * </p>
     * 
     * @return Returns coverage statistics for Amazon Web Services Lambda functions filtered by tag.
     */
    public final List<CoverageMapFilter> lambdaFunctionTags() {
        return lambdaFunctionTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the LambdaFunctionRuntime property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLambdaFunctionRuntime() {
        return lambdaFunctionRuntime != null && !(lambdaFunctionRuntime instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns coverage statistics for Amazon Web Services Lambda functions filtered by runtime.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLambdaFunctionRuntime} method.
     * </p>
     * 
     * @return Returns coverage statistics for Amazon Web Services Lambda functions filtered by runtime.
     */
    public final List<CoverageStringFilter> lambdaFunctionRuntime() {
        return lambdaFunctionRuntime;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastScannedAt property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLastScannedAt() {
        return lastScannedAt != null && !(lastScannedAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters Amazon Web Services resources based on whether Amazon Inspector has checked them for vulnerabilities
     * within the specified time range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastScannedAt} method.
     * </p>
     * 
     * @return Filters Amazon Web Services resources based on whether Amazon Inspector has checked them for
     *         vulnerabilities within the specified time range.
     */
    public final List<CoverageDateFilter> lastScannedAt() {
        return lastScannedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanMode property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScanMode() {
        return scanMode != null && !(scanMode instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter to search for Amazon EC2 instance coverage by scan mode. Valid values are
     * <code>EC2_SSM_AGENT_BASED</code> and <code>EC2_AGENTLESS</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanMode} method.
     * </p>
     * 
     * @return The filter to search for Amazon EC2 instance coverage by scan mode. Valid values are
     *         <code>EC2_SSM_AGENT_BASED</code> and <code>EC2_AGENTLESS</code>.
     */
    public final List<CoverageStringFilter> scanMode() {
        return scanMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImagePulledAt property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImagePulledAt() {
        return imagePulledAt != null && !(imagePulledAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The date an image was last pulled at.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImagePulledAt} method.
     * </p>
     * 
     * @return The date an image was last pulled at.
     */
    public final List<CoverageDateFilter> imagePulledAt() {
        return imagePulledAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrImageLastInUseAt property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcrImageLastInUseAt() {
        return ecrImageLastInUseAt != null && !(ecrImageLastInUseAt instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon ECR image that was last in use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrImageLastInUseAt} method.
     * </p>
     * 
     * @return The Amazon ECR image that was last in use.
     */
    public final List<CoverageDateFilter> ecrImageLastInUseAt() {
        return ecrImageLastInUseAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the EcrImageInUseCount property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEcrImageInUseCount() {
        return ecrImageInUseCount != null && !(ecrImageInUseCount instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of Amazon ECR images in use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEcrImageInUseCount} method.
     * </p>
     * 
     * @return The number of Amazon ECR images in use.
     */
    public final List<CoverageNumberFilter> ecrImageInUseCount() {
        return ecrImageInUseCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the CodeRepositoryProjectName property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCodeRepositoryProjectName() {
        return codeRepositoryProjectName != null && !(codeRepositoryProjectName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter criteria for code repositories based on project name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCodeRepositoryProjectName} method.
     * </p>
     * 
     * @return Filter criteria for code repositories based on project name.
     */
    public final List<CoverageStringFilter> codeRepositoryProjectName() {
        return codeRepositoryProjectName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CodeRepositoryProviderType property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCodeRepositoryProviderType() {
        return codeRepositoryProviderType != null && !(codeRepositoryProviderType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter criteria for code repositories based on provider type (such as GitHub, GitLab, etc.).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCodeRepositoryProviderType} method.
     * </p>
     * 
     * @return Filter criteria for code repositories based on provider type (such as GitHub, GitLab, etc.).
     */
    public final List<CoverageStringFilter> codeRepositoryProviderType() {
        return codeRepositoryProviderType;
    }

    /**
     * For responses, this returns true if the service returned a value for the CodeRepositoryProviderTypeVisibility
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCodeRepositoryProviderTypeVisibility() {
        return codeRepositoryProviderTypeVisibility != null
                && !(codeRepositoryProviderTypeVisibility instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter criteria for code repositories based on visibility setting (public or private).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCodeRepositoryProviderTypeVisibility}
     * method.
     * </p>
     * 
     * @return Filter criteria for code repositories based on visibility setting (public or private).
     */
    public final List<CoverageStringFilter> codeRepositoryProviderTypeVisibility() {
        return codeRepositoryProviderTypeVisibility;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastScannedCommitId property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLastScannedCommitId() {
        return lastScannedCommitId != null && !(lastScannedCommitId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter criteria for code repositories based on the ID of the last scanned commit.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastScannedCommitId} method.
     * </p>
     * 
     * @return Filter criteria for code repositories based on the ID of the last scanned commit.
     */
    public final List<CoverageStringFilter> lastScannedCommitId() {
        return lastScannedCommitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasScanStatusCode() ? scanStatusCode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScanStatusReason() ? scanStatusReason() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountId() ? accountId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceId() ? resourceId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceType() ? resourceType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScanType() ? scanType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrRepositoryName() ? ecrRepositoryName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrImageTags() ? ecrImageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2InstanceTags() ? ec2InstanceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLambdaFunctionName() ? lambdaFunctionName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLambdaFunctionTags() ? lambdaFunctionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLambdaFunctionRuntime() ? lambdaFunctionRuntime() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLastScannedAt() ? lastScannedAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasScanMode() ? scanMode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImagePulledAt() ? imagePulledAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrImageLastInUseAt() ? ecrImageLastInUseAt() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEcrImageInUseCount() ? ecrImageInUseCount() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeRepositoryProjectName() ? codeRepositoryProjectName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeRepositoryProviderType() ? codeRepositoryProviderType() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCodeRepositoryProviderTypeVisibility() ? codeRepositoryProviderTypeVisibility() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLastScannedCommitId() ? lastScannedCommitId() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageFilterCriteria)) {
            return false;
        }
        CoverageFilterCriteria other = (CoverageFilterCriteria) obj;
        return hasScanStatusCode() == other.hasScanStatusCode() && Objects.equals(scanStatusCode(), other.scanStatusCode())
                && hasScanStatusReason() == other.hasScanStatusReason()
                && Objects.equals(scanStatusReason(), other.scanStatusReason()) && hasAccountId() == other.hasAccountId()
                && Objects.equals(accountId(), other.accountId()) && hasResourceId() == other.hasResourceId()
                && Objects.equals(resourceId(), other.resourceId()) && hasResourceType() == other.hasResourceType()
                && Objects.equals(resourceType(), other.resourceType()) && hasScanType() == other.hasScanType()
                && Objects.equals(scanType(), other.scanType()) && hasEcrRepositoryName() == other.hasEcrRepositoryName()
                && Objects.equals(ecrRepositoryName(), other.ecrRepositoryName()) && hasEcrImageTags() == other.hasEcrImageTags()
                && Objects.equals(ecrImageTags(), other.ecrImageTags()) && hasEc2InstanceTags() == other.hasEc2InstanceTags()
                && Objects.equals(ec2InstanceTags(), other.ec2InstanceTags())
                && hasLambdaFunctionName() == other.hasLambdaFunctionName()
                && Objects.equals(lambdaFunctionName(), other.lambdaFunctionName())
                && hasLambdaFunctionTags() == other.hasLambdaFunctionTags()
                && Objects.equals(lambdaFunctionTags(), other.lambdaFunctionTags())
                && hasLambdaFunctionRuntime() == other.hasLambdaFunctionRuntime()
                && Objects.equals(lambdaFunctionRuntime(), other.lambdaFunctionRuntime())
                && hasLastScannedAt() == other.hasLastScannedAt() && Objects.equals(lastScannedAt(), other.lastScannedAt())
                && hasScanMode() == other.hasScanMode() && Objects.equals(scanMode(), other.scanMode())
                && hasImagePulledAt() == other.hasImagePulledAt() && Objects.equals(imagePulledAt(), other.imagePulledAt())
                && hasEcrImageLastInUseAt() == other.hasEcrImageLastInUseAt()
                && Objects.equals(ecrImageLastInUseAt(), other.ecrImageLastInUseAt())
                && hasEcrImageInUseCount() == other.hasEcrImageInUseCount()
                && Objects.equals(ecrImageInUseCount(), other.ecrImageInUseCount())
                && hasCodeRepositoryProjectName() == other.hasCodeRepositoryProjectName()
                && Objects.equals(codeRepositoryProjectName(), other.codeRepositoryProjectName())
                && hasCodeRepositoryProviderType() == other.hasCodeRepositoryProviderType()
                && Objects.equals(codeRepositoryProviderType(), other.codeRepositoryProviderType())
                && hasCodeRepositoryProviderTypeVisibility() == other.hasCodeRepositoryProviderTypeVisibility()
                && Objects.equals(codeRepositoryProviderTypeVisibility(), other.codeRepositoryProviderTypeVisibility())
                && hasLastScannedCommitId() == other.hasLastScannedCommitId()
                && Objects.equals(lastScannedCommitId(), other.lastScannedCommitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CoverageFilterCriteria")
                .add("ScanStatusCode", hasScanStatusCode() ? scanStatusCode() : null)
                .add("ScanStatusReason", hasScanStatusReason() ? scanStatusReason() : null)
                .add("AccountId", hasAccountId() ? accountId() : null)
                .add("ResourceId", hasResourceId() ? resourceId() : null)
                .add("ResourceType", hasResourceType() ? resourceType() : null)
                .add("ScanType", hasScanType() ? scanType() : null)
                .add("EcrRepositoryName", hasEcrRepositoryName() ? ecrRepositoryName() : null)
                .add("EcrImageTags", hasEcrImageTags() ? ecrImageTags() : null)
                .add("Ec2InstanceTags", hasEc2InstanceTags() ? ec2InstanceTags() : null)
                .add("LambdaFunctionName", hasLambdaFunctionName() ? lambdaFunctionName() : null)
                .add("LambdaFunctionTags", hasLambdaFunctionTags() ? lambdaFunctionTags() : null)
                .add("LambdaFunctionRuntime", hasLambdaFunctionRuntime() ? lambdaFunctionRuntime() : null)
                .add("LastScannedAt", hasLastScannedAt() ? lastScannedAt() : null)
                .add("ScanMode", hasScanMode() ? scanMode() : null)
                .add("ImagePulledAt", hasImagePulledAt() ? imagePulledAt() : null)
                .add("EcrImageLastInUseAt", hasEcrImageLastInUseAt() ? ecrImageLastInUseAt() : null)
                .add("EcrImageInUseCount", hasEcrImageInUseCount() ? ecrImageInUseCount() : null)
                .add("CodeRepositoryProjectName", hasCodeRepositoryProjectName() ? codeRepositoryProjectName() : null)
                .add("CodeRepositoryProviderType", hasCodeRepositoryProviderType() ? codeRepositoryProviderType() : null)
                .add("CodeRepositoryProviderTypeVisibility",
                        hasCodeRepositoryProviderTypeVisibility() ? codeRepositoryProviderTypeVisibility() : null)
                .add("LastScannedCommitId", hasLastScannedCommitId() ? lastScannedCommitId() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanStatusCode":
            return Optional.ofNullable(clazz.cast(scanStatusCode()));
        case "scanStatusReason":
            return Optional.ofNullable(clazz.cast(scanStatusReason()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "scanType":
            return Optional.ofNullable(clazz.cast(scanType()));
        case "ecrRepositoryName":
            return Optional.ofNullable(clazz.cast(ecrRepositoryName()));
        case "ecrImageTags":
            return Optional.ofNullable(clazz.cast(ecrImageTags()));
        case "ec2InstanceTags":
            return Optional.ofNullable(clazz.cast(ec2InstanceTags()));
        case "lambdaFunctionName":
            return Optional.ofNullable(clazz.cast(lambdaFunctionName()));
        case "lambdaFunctionTags":
            return Optional.ofNullable(clazz.cast(lambdaFunctionTags()));
        case "lambdaFunctionRuntime":
            return Optional.ofNullable(clazz.cast(lambdaFunctionRuntime()));
        case "lastScannedAt":
            return Optional.ofNullable(clazz.cast(lastScannedAt()));
        case "scanMode":
            return Optional.ofNullable(clazz.cast(scanMode()));
        case "imagePulledAt":
            return Optional.ofNullable(clazz.cast(imagePulledAt()));
        case "ecrImageLastInUseAt":
            return Optional.ofNullable(clazz.cast(ecrImageLastInUseAt()));
        case "ecrImageInUseCount":
            return Optional.ofNullable(clazz.cast(ecrImageInUseCount()));
        case "codeRepositoryProjectName":
            return Optional.ofNullable(clazz.cast(codeRepositoryProjectName()));
        case "codeRepositoryProviderType":
            return Optional.ofNullable(clazz.cast(codeRepositoryProviderType()));
        case "codeRepositoryProviderTypeVisibility":
            return Optional.ofNullable(clazz.cast(codeRepositoryProviderTypeVisibility()));
        case "lastScannedCommitId":
            return Optional.ofNullable(clazz.cast(lastScannedCommitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanStatusCode", SCAN_STATUS_CODE_FIELD);
        map.put("scanStatusReason", SCAN_STATUS_REASON_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("scanType", SCAN_TYPE_FIELD);
        map.put("ecrRepositoryName", ECR_REPOSITORY_NAME_FIELD);
        map.put("ecrImageTags", ECR_IMAGE_TAGS_FIELD);
        map.put("ec2InstanceTags", EC2_INSTANCE_TAGS_FIELD);
        map.put("lambdaFunctionName", LAMBDA_FUNCTION_NAME_FIELD);
        map.put("lambdaFunctionTags", LAMBDA_FUNCTION_TAGS_FIELD);
        map.put("lambdaFunctionRuntime", LAMBDA_FUNCTION_RUNTIME_FIELD);
        map.put("lastScannedAt", LAST_SCANNED_AT_FIELD);
        map.put("scanMode", SCAN_MODE_FIELD);
        map.put("imagePulledAt", IMAGE_PULLED_AT_FIELD);
        map.put("ecrImageLastInUseAt", ECR_IMAGE_LAST_IN_USE_AT_FIELD);
        map.put("ecrImageInUseCount", ECR_IMAGE_IN_USE_COUNT_FIELD);
        map.put("codeRepositoryProjectName", CODE_REPOSITORY_PROJECT_NAME_FIELD);
        map.put("codeRepositoryProviderType", CODE_REPOSITORY_PROVIDER_TYPE_FIELD);
        map.put("codeRepositoryProviderTypeVisibility", CODE_REPOSITORY_PROVIDER_TYPE_VISIBILITY_FIELD);
        map.put("lastScannedCommitId", LAST_SCANNED_COMMIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoverageFilterCriteria, T> g) {
        return obj -> g.apply((CoverageFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageFilterCriteria> {
        /**
         * <p>
         * The scan status code to filter on. Valid values are: <code>ValidationException</code>,
         * <code>InternalServerException</code>, <code>ResourceNotFoundException</code>,
         * <code>BadRequestException</code>, and <code>ThrottlingException</code>.
         * </p>
         * 
         * @param scanStatusCode
         *        The scan status code to filter on. Valid values are: <code>ValidationException</code>,
         *        <code>InternalServerException</code>, <code>ResourceNotFoundException</code>,
         *        <code>BadRequestException</code>, and <code>ThrottlingException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanStatusCode(Collection<CoverageStringFilter> scanStatusCode);

        /**
         * <p>
         * The scan status code to filter on. Valid values are: <code>ValidationException</code>,
         * <code>InternalServerException</code>, <code>ResourceNotFoundException</code>,
         * <code>BadRequestException</code>, and <code>ThrottlingException</code>.
         * </p>
         * 
         * @param scanStatusCode
         *        The scan status code to filter on. Valid values are: <code>ValidationException</code>,
         *        <code>InternalServerException</code>, <code>ResourceNotFoundException</code>,
         *        <code>BadRequestException</code>, and <code>ThrottlingException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanStatusCode(CoverageStringFilter... scanStatusCode);

        /**
         * <p>
         * The scan status code to filter on. Valid values are: <code>ValidationException</code>,
         * <code>InternalServerException</code>, <code>ResourceNotFoundException</code>,
         * <code>BadRequestException</code>, and <code>ThrottlingException</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #scanStatusCode(List<CoverageStringFilter>)}.
         * 
         * @param scanStatusCode
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanStatusCode(java.util.Collection<CoverageStringFilter>)
         */
        Builder scanStatusCode(Consumer<CoverageStringFilter.Builder>... scanStatusCode);

        /**
         * <p>
         * The scan status reason to filter on.
         * </p>
         * 
         * @param scanStatusReason
         *        The scan status reason to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanStatusReason(Collection<CoverageStringFilter> scanStatusReason);

        /**
         * <p>
         * The scan status reason to filter on.
         * </p>
         * 
         * @param scanStatusReason
         *        The scan status reason to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanStatusReason(CoverageStringFilter... scanStatusReason);

        /**
         * <p>
         * The scan status reason to filter on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #scanStatusReason(List<CoverageStringFilter>)}.
         * 
         * @param scanStatusReason
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanStatusReason(java.util.Collection<CoverageStringFilter>)
         */
        Builder scanStatusReason(Consumer<CoverageStringFilter.Builder>... scanStatusReason);

        /**
         * <p>
         * An array of Amazon Web Services account IDs to return coverage statistics for.
         * </p>
         * 
         * @param accountId
         *        An array of Amazon Web Services account IDs to return coverage statistics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(Collection<CoverageStringFilter> accountId);

        /**
         * <p>
         * An array of Amazon Web Services account IDs to return coverage statistics for.
         * </p>
         * 
         * @param accountId
         *        An array of Amazon Web Services account IDs to return coverage statistics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(CoverageStringFilter... accountId);

        /**
         * <p>
         * An array of Amazon Web Services account IDs to return coverage statistics for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #accountId(List<CoverageStringFilter>)}.
         * 
         * @param accountId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountId(java.util.Collection<CoverageStringFilter>)
         */
        Builder accountId(Consumer<CoverageStringFilter.Builder>... accountId);

        /**
         * <p>
         * An array of Amazon Web Services resource IDs to return coverage statistics for.
         * </p>
         * 
         * @param resourceId
         *        An array of Amazon Web Services resource IDs to return coverage statistics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(Collection<CoverageStringFilter> resourceId);

        /**
         * <p>
         * An array of Amazon Web Services resource IDs to return coverage statistics for.
         * </p>
         * 
         * @param resourceId
         *        An array of Amazon Web Services resource IDs to return coverage statistics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(CoverageStringFilter... resourceId);

        /**
         * <p>
         * An array of Amazon Web Services resource IDs to return coverage statistics for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceId(List<CoverageStringFilter>)}.
         * 
         * @param resourceId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceId(java.util.Collection<CoverageStringFilter>)
         */
        Builder resourceId(Consumer<CoverageStringFilter.Builder>... resourceId);

        /**
         * <p>
         * An array of Amazon Web Services resource types to return coverage statistics for. The values can be
         * <code>AWS_EC2_INSTANCE</code>, <code>AWS_LAMBDA_FUNCTION</code>, <code>AWS_ECR_CONTAINER_IMAGE</code>,
         * <code>AWS_ECR_REPOSITORY</code> or <code>AWS_ACCOUNT</code>.
         * </p>
         * 
         * @param resourceType
         *        An array of Amazon Web Services resource types to return coverage statistics for. The values can be
         *        <code>AWS_EC2_INSTANCE</code>, <code>AWS_LAMBDA_FUNCTION</code>, <code>AWS_ECR_CONTAINER_IMAGE</code>,
         *        <code>AWS_ECR_REPOSITORY</code> or <code>AWS_ACCOUNT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(Collection<CoverageStringFilter> resourceType);

        /**
         * <p>
         * An array of Amazon Web Services resource types to return coverage statistics for. The values can be
         * <code>AWS_EC2_INSTANCE</code>, <code>AWS_LAMBDA_FUNCTION</code>, <code>AWS_ECR_CONTAINER_IMAGE</code>,
         * <code>AWS_ECR_REPOSITORY</code> or <code>AWS_ACCOUNT</code>.
         * </p>
         * 
         * @param resourceType
         *        An array of Amazon Web Services resource types to return coverage statistics for. The values can be
         *        <code>AWS_EC2_INSTANCE</code>, <code>AWS_LAMBDA_FUNCTION</code>, <code>AWS_ECR_CONTAINER_IMAGE</code>,
         *        <code>AWS_ECR_REPOSITORY</code> or <code>AWS_ACCOUNT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(CoverageStringFilter... resourceType);

        /**
         * <p>
         * An array of Amazon Web Services resource types to return coverage statistics for. The values can be
         * <code>AWS_EC2_INSTANCE</code>, <code>AWS_LAMBDA_FUNCTION</code>, <code>AWS_ECR_CONTAINER_IMAGE</code>,
         * <code>AWS_ECR_REPOSITORY</code> or <code>AWS_ACCOUNT</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceType(List<CoverageStringFilter>)}.
         * 
         * @param resourceType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceType(java.util.Collection<CoverageStringFilter>)
         */
        Builder resourceType(Consumer<CoverageStringFilter.Builder>... resourceType);

        /**
         * <p>
         * An array of Amazon Inspector scan types to return coverage statistics for.
         * </p>
         * 
         * @param scanType
         *        An array of Amazon Inspector scan types to return coverage statistics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanType(Collection<CoverageStringFilter> scanType);

        /**
         * <p>
         * An array of Amazon Inspector scan types to return coverage statistics for.
         * </p>
         * 
         * @param scanType
         *        An array of Amazon Inspector scan types to return coverage statistics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanType(CoverageStringFilter... scanType);

        /**
         * <p>
         * An array of Amazon Inspector scan types to return coverage statistics for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #scanType(List<CoverageStringFilter>)}.
         * 
         * @param scanType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanType(java.util.Collection<CoverageStringFilter>)
         */
        Builder scanType(Consumer<CoverageStringFilter.Builder>... scanType);

        /**
         * <p>
         * The Amazon ECR repository name to filter on.
         * </p>
         * 
         * @param ecrRepositoryName
         *        The Amazon ECR repository name to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryName(Collection<CoverageStringFilter> ecrRepositoryName);

        /**
         * <p>
         * The Amazon ECR repository name to filter on.
         * </p>
         * 
         * @param ecrRepositoryName
         *        The Amazon ECR repository name to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryName(CoverageStringFilter... ecrRepositoryName);

        /**
         * <p>
         * The Amazon ECR repository name to filter on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #ecrRepositoryName(List<CoverageStringFilter>)}.
         * 
         * @param ecrRepositoryName
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrRepositoryName(java.util.Collection<CoverageStringFilter>)
         */
        Builder ecrRepositoryName(Consumer<CoverageStringFilter.Builder>... ecrRepositoryName);

        /**
         * <p>
         * The Amazon ECR image tags to filter on.
         * </p>
         * 
         * @param ecrImageTags
         *        The Amazon ECR image tags to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageTags(Collection<CoverageStringFilter> ecrImageTags);

        /**
         * <p>
         * The Amazon ECR image tags to filter on.
         * </p>
         * 
         * @param ecrImageTags
         *        The Amazon ECR image tags to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageTags(CoverageStringFilter... ecrImageTags);

        /**
         * <p>
         * The Amazon ECR image tags to filter on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #ecrImageTags(List<CoverageStringFilter>)}.
         * 
         * @param ecrImageTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImageTags(java.util.Collection<CoverageStringFilter>)
         */
        Builder ecrImageTags(Consumer<CoverageStringFilter.Builder>... ecrImageTags);

        /**
         * <p>
         * The Amazon EC2 instance tags to filter on.
         * </p>
         * 
         * @param ec2InstanceTags
         *        The Amazon EC2 instance tags to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceTags(Collection<CoverageMapFilter> ec2InstanceTags);

        /**
         * <p>
         * The Amazon EC2 instance tags to filter on.
         * </p>
         * 
         * @param ec2InstanceTags
         *        The Amazon EC2 instance tags to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceTags(CoverageMapFilter... ec2InstanceTags);

        /**
         * <p>
         * The Amazon EC2 instance tags to filter on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageMapFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.CoverageMapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageMapFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #ec2InstanceTags(List<CoverageMapFilter>)}.
         * 
         * @param ec2InstanceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageMapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceTags(java.util.Collection<CoverageMapFilter>)
         */
        Builder ec2InstanceTags(Consumer<CoverageMapFilter.Builder>... ec2InstanceTags);

        /**
         * <p>
         * Returns coverage statistics for Amazon Web Services Lambda functions filtered by function names.
         * </p>
         * 
         * @param lambdaFunctionName
         *        Returns coverage statistics for Amazon Web Services Lambda functions filtered by function names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionName(Collection<CoverageStringFilter> lambdaFunctionName);

        /**
         * <p>
         * Returns coverage statistics for Amazon Web Services Lambda functions filtered by function names.
         * </p>
         * 
         * @param lambdaFunctionName
         *        Returns coverage statistics for Amazon Web Services Lambda functions filtered by function names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionName(CoverageStringFilter... lambdaFunctionName);

        /**
         * <p>
         * Returns coverage statistics for Amazon Web Services Lambda functions filtered by function names.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lambdaFunctionName(List<CoverageStringFilter>)}.
         * 
         * @param lambdaFunctionName
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionName(java.util.Collection<CoverageStringFilter>)
         */
        Builder lambdaFunctionName(Consumer<CoverageStringFilter.Builder>... lambdaFunctionName);

        /**
         * <p>
         * Returns coverage statistics for Amazon Web Services Lambda functions filtered by tag.
         * </p>
         * 
         * @param lambdaFunctionTags
         *        Returns coverage statistics for Amazon Web Services Lambda functions filtered by tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionTags(Collection<CoverageMapFilter> lambdaFunctionTags);

        /**
         * <p>
         * Returns coverage statistics for Amazon Web Services Lambda functions filtered by tag.
         * </p>
         * 
         * @param lambdaFunctionTags
         *        Returns coverage statistics for Amazon Web Services Lambda functions filtered by tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionTags(CoverageMapFilter... lambdaFunctionTags);

        /**
         * <p>
         * Returns coverage statistics for Amazon Web Services Lambda functions filtered by tag.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageMapFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.CoverageMapFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageMapFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lambdaFunctionTags(List<CoverageMapFilter>)}.
         * 
         * @param lambdaFunctionTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageMapFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionTags(java.util.Collection<CoverageMapFilter>)
         */
        Builder lambdaFunctionTags(Consumer<CoverageMapFilter.Builder>... lambdaFunctionTags);

        /**
         * <p>
         * Returns coverage statistics for Amazon Web Services Lambda functions filtered by runtime.
         * </p>
         * 
         * @param lambdaFunctionRuntime
         *        Returns coverage statistics for Amazon Web Services Lambda functions filtered by runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionRuntime(Collection<CoverageStringFilter> lambdaFunctionRuntime);

        /**
         * <p>
         * Returns coverage statistics for Amazon Web Services Lambda functions filtered by runtime.
         * </p>
         * 
         * @param lambdaFunctionRuntime
         *        Returns coverage statistics for Amazon Web Services Lambda functions filtered by runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionRuntime(CoverageStringFilter... lambdaFunctionRuntime);

        /**
         * <p>
         * Returns coverage statistics for Amazon Web Services Lambda functions filtered by runtime.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lambdaFunctionRuntime(List<CoverageStringFilter>)}.
         * 
         * @param lambdaFunctionRuntime
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionRuntime(java.util.Collection<CoverageStringFilter>)
         */
        Builder lambdaFunctionRuntime(Consumer<CoverageStringFilter.Builder>... lambdaFunctionRuntime);

        /**
         * <p>
         * Filters Amazon Web Services resources based on whether Amazon Inspector has checked them for vulnerabilities
         * within the specified time range.
         * </p>
         * 
         * @param lastScannedAt
         *        Filters Amazon Web Services resources based on whether Amazon Inspector has checked them for
         *        vulnerabilities within the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastScannedAt(Collection<CoverageDateFilter> lastScannedAt);

        /**
         * <p>
         * Filters Amazon Web Services resources based on whether Amazon Inspector has checked them for vulnerabilities
         * within the specified time range.
         * </p>
         * 
         * @param lastScannedAt
         *        Filters Amazon Web Services resources based on whether Amazon Inspector has checked them for
         *        vulnerabilities within the specified time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastScannedAt(CoverageDateFilter... lastScannedAt);

        /**
         * <p>
         * Filters Amazon Web Services resources based on whether Amazon Inspector has checked them for vulnerabilities
         * within the specified time range.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lastScannedAt(List<CoverageDateFilter>)}.
         * 
         * @param lastScannedAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastScannedAt(java.util.Collection<CoverageDateFilter>)
         */
        Builder lastScannedAt(Consumer<CoverageDateFilter.Builder>... lastScannedAt);

        /**
         * <p>
         * The filter to search for Amazon EC2 instance coverage by scan mode. Valid values are
         * <code>EC2_SSM_AGENT_BASED</code> and <code>EC2_AGENTLESS</code>.
         * </p>
         * 
         * @param scanMode
         *        The filter to search for Amazon EC2 instance coverage by scan mode. Valid values are
         *        <code>EC2_SSM_AGENT_BASED</code> and <code>EC2_AGENTLESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanMode(Collection<CoverageStringFilter> scanMode);

        /**
         * <p>
         * The filter to search for Amazon EC2 instance coverage by scan mode. Valid values are
         * <code>EC2_SSM_AGENT_BASED</code> and <code>EC2_AGENTLESS</code>.
         * </p>
         * 
         * @param scanMode
         *        The filter to search for Amazon EC2 instance coverage by scan mode. Valid values are
         *        <code>EC2_SSM_AGENT_BASED</code> and <code>EC2_AGENTLESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanMode(CoverageStringFilter... scanMode);

        /**
         * <p>
         * The filter to search for Amazon EC2 instance coverage by scan mode. Valid values are
         * <code>EC2_SSM_AGENT_BASED</code> and <code>EC2_AGENTLESS</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #scanMode(List<CoverageStringFilter>)}.
         * 
         * @param scanMode
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanMode(java.util.Collection<CoverageStringFilter>)
         */
        Builder scanMode(Consumer<CoverageStringFilter.Builder>... scanMode);

        /**
         * <p>
         * The date an image was last pulled at.
         * </p>
         * 
         * @param imagePulledAt
         *        The date an image was last pulled at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePulledAt(Collection<CoverageDateFilter> imagePulledAt);

        /**
         * <p>
         * The date an image was last pulled at.
         * </p>
         * 
         * @param imagePulledAt
         *        The date an image was last pulled at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePulledAt(CoverageDateFilter... imagePulledAt);

        /**
         * <p>
         * The date an image was last pulled at.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #imagePulledAt(List<CoverageDateFilter>)}.
         * 
         * @param imagePulledAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imagePulledAt(java.util.Collection<CoverageDateFilter>)
         */
        Builder imagePulledAt(Consumer<CoverageDateFilter.Builder>... imagePulledAt);

        /**
         * <p>
         * The Amazon ECR image that was last in use.
         * </p>
         * 
         * @param ecrImageLastInUseAt
         *        The Amazon ECR image that was last in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageLastInUseAt(Collection<CoverageDateFilter> ecrImageLastInUseAt);

        /**
         * <p>
         * The Amazon ECR image that was last in use.
         * </p>
         * 
         * @param ecrImageLastInUseAt
         *        The Amazon ECR image that was last in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageLastInUseAt(CoverageDateFilter... ecrImageLastInUseAt);

        /**
         * <p>
         * The Amazon ECR image that was last in use.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #ecrImageLastInUseAt(List<CoverageDateFilter>)}.
         * 
         * @param ecrImageLastInUseAt
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImageLastInUseAt(java.util.Collection<CoverageDateFilter>)
         */
        Builder ecrImageLastInUseAt(Consumer<CoverageDateFilter.Builder>... ecrImageLastInUseAt);

        /**
         * <p>
         * The number of Amazon ECR images in use.
         * </p>
         * 
         * @param ecrImageInUseCount
         *        The number of Amazon ECR images in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageInUseCount(Collection<CoverageNumberFilter> ecrImageInUseCount);

        /**
         * <p>
         * The number of Amazon ECR images in use.
         * </p>
         * 
         * @param ecrImageInUseCount
         *        The number of Amazon ECR images in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImageInUseCount(CoverageNumberFilter... ecrImageInUseCount);

        /**
         * <p>
         * The number of Amazon ECR images in use.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageNumberFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageNumberFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageNumberFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #ecrImageInUseCount(List<CoverageNumberFilter>)}.
         * 
         * @param ecrImageInUseCount
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageNumberFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImageInUseCount(java.util.Collection<CoverageNumberFilter>)
         */
        Builder ecrImageInUseCount(Consumer<CoverageNumberFilter.Builder>... ecrImageInUseCount);

        /**
         * <p>
         * Filter criteria for code repositories based on project name.
         * </p>
         * 
         * @param codeRepositoryProjectName
         *        Filter criteria for code repositories based on project name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositoryProjectName(Collection<CoverageStringFilter> codeRepositoryProjectName);

        /**
         * <p>
         * Filter criteria for code repositories based on project name.
         * </p>
         * 
         * @param codeRepositoryProjectName
         *        Filter criteria for code repositories based on project name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositoryProjectName(CoverageStringFilter... codeRepositoryProjectName);

        /**
         * <p>
         * Filter criteria for code repositories based on project name.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #codeRepositoryProjectName(List<CoverageStringFilter>)}.
         * 
         * @param codeRepositoryProjectName
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeRepositoryProjectName(java.util.Collection<CoverageStringFilter>)
         */
        Builder codeRepositoryProjectName(Consumer<CoverageStringFilter.Builder>... codeRepositoryProjectName);

        /**
         * <p>
         * Filter criteria for code repositories based on provider type (such as GitHub, GitLab, etc.).
         * </p>
         * 
         * @param codeRepositoryProviderType
         *        Filter criteria for code repositories based on provider type (such as GitHub, GitLab, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositoryProviderType(Collection<CoverageStringFilter> codeRepositoryProviderType);

        /**
         * <p>
         * Filter criteria for code repositories based on provider type (such as GitHub, GitLab, etc.).
         * </p>
         * 
         * @param codeRepositoryProviderType
         *        Filter criteria for code repositories based on provider type (such as GitHub, GitLab, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositoryProviderType(CoverageStringFilter... codeRepositoryProviderType);

        /**
         * <p>
         * Filter criteria for code repositories based on provider type (such as GitHub, GitLab, etc.).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #codeRepositoryProviderType(List<CoverageStringFilter>)}.
         * 
         * @param codeRepositoryProviderType
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeRepositoryProviderType(java.util.Collection<CoverageStringFilter>)
         */
        Builder codeRepositoryProviderType(Consumer<CoverageStringFilter.Builder>... codeRepositoryProviderType);

        /**
         * <p>
         * Filter criteria for code repositories based on visibility setting (public or private).
         * </p>
         * 
         * @param codeRepositoryProviderTypeVisibility
         *        Filter criteria for code repositories based on visibility setting (public or private).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositoryProviderTypeVisibility(Collection<CoverageStringFilter> codeRepositoryProviderTypeVisibility);

        /**
         * <p>
         * Filter criteria for code repositories based on visibility setting (public or private).
         * </p>
         * 
         * @param codeRepositoryProviderTypeVisibility
         *        Filter criteria for code repositories based on visibility setting (public or private).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositoryProviderTypeVisibility(CoverageStringFilter... codeRepositoryProviderTypeVisibility);

        /**
         * <p>
         * Filter criteria for code repositories based on visibility setting (public or private).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #codeRepositoryProviderTypeVisibility(List<CoverageStringFilter>)}.
         * 
         * @param codeRepositoryProviderTypeVisibility
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeRepositoryProviderTypeVisibility(java.util.Collection<CoverageStringFilter>)
         */
        Builder codeRepositoryProviderTypeVisibility(
                Consumer<CoverageStringFilter.Builder>... codeRepositoryProviderTypeVisibility);

        /**
         * <p>
         * Filter criteria for code repositories based on the ID of the last scanned commit.
         * </p>
         * 
         * @param lastScannedCommitId
         *        Filter criteria for code repositories based on the ID of the last scanned commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastScannedCommitId(Collection<CoverageStringFilter> lastScannedCommitId);

        /**
         * <p>
         * Filter criteria for code repositories based on the ID of the last scanned commit.
         * </p>
         * 
         * @param lastScannedCommitId
         *        Filter criteria for code repositories based on the ID of the last scanned commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastScannedCommitId(CoverageStringFilter... lastScannedCommitId);

        /**
         * <p>
         * Filter criteria for code repositories based on the ID of the last scanned commit.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #lastScannedCommitId(List<CoverageStringFilter>)}.
         * 
         * @param lastScannedCommitId
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CoverageStringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastScannedCommitId(java.util.Collection<CoverageStringFilter>)
         */
        Builder lastScannedCommitId(Consumer<CoverageStringFilter.Builder>... lastScannedCommitId);
    }

    static final class BuilderImpl implements Builder {
        private List<CoverageStringFilter> scanStatusCode = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> scanStatusReason = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> accountId = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> resourceId = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> resourceType = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> scanType = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> ecrRepositoryName = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> ecrImageTags = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageMapFilter> ec2InstanceTags = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> lambdaFunctionName = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageMapFilter> lambdaFunctionTags = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> lambdaFunctionRuntime = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageDateFilter> lastScannedAt = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> scanMode = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageDateFilter> imagePulledAt = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageDateFilter> ecrImageLastInUseAt = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageNumberFilter> ecrImageInUseCount = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> codeRepositoryProjectName = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> codeRepositoryProviderType = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> codeRepositoryProviderTypeVisibility = DefaultSdkAutoConstructList.getInstance();

        private List<CoverageStringFilter> lastScannedCommitId = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageFilterCriteria model) {
            scanStatusCode(model.scanStatusCode);
            scanStatusReason(model.scanStatusReason);
            accountId(model.accountId);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            scanType(model.scanType);
            ecrRepositoryName(model.ecrRepositoryName);
            ecrImageTags(model.ecrImageTags);
            ec2InstanceTags(model.ec2InstanceTags);
            lambdaFunctionName(model.lambdaFunctionName);
            lambdaFunctionTags(model.lambdaFunctionTags);
            lambdaFunctionRuntime(model.lambdaFunctionRuntime);
            lastScannedAt(model.lastScannedAt);
            scanMode(model.scanMode);
            imagePulledAt(model.imagePulledAt);
            ecrImageLastInUseAt(model.ecrImageLastInUseAt);
            ecrImageInUseCount(model.ecrImageInUseCount);
            codeRepositoryProjectName(model.codeRepositoryProjectName);
            codeRepositoryProviderType(model.codeRepositoryProviderType);
            codeRepositoryProviderTypeVisibility(model.codeRepositoryProviderTypeVisibility);
            lastScannedCommitId(model.lastScannedCommitId);
        }

        public final List<CoverageStringFilter.Builder> getScanStatusCode() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.scanStatusCode);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanStatusCode(Collection<CoverageStringFilter.BuilderImpl> scanStatusCode) {
            this.scanStatusCode = CoverageStringFilterListCopier.copyFromBuilder(scanStatusCode);
        }

        @Override
        public final Builder scanStatusCode(Collection<CoverageStringFilter> scanStatusCode) {
            this.scanStatusCode = CoverageStringFilterListCopier.copy(scanStatusCode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusCode(CoverageStringFilter... scanStatusCode) {
            scanStatusCode(Arrays.asList(scanStatusCode));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusCode(Consumer<CoverageStringFilter.Builder>... scanStatusCode) {
            scanStatusCode(Stream.of(scanStatusCode).map(c -> CoverageStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getScanStatusReason() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.scanStatusReason);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanStatusReason(Collection<CoverageStringFilter.BuilderImpl> scanStatusReason) {
            this.scanStatusReason = CoverageStringFilterListCopier.copyFromBuilder(scanStatusReason);
        }

        @Override
        public final Builder scanStatusReason(Collection<CoverageStringFilter> scanStatusReason) {
            this.scanStatusReason = CoverageStringFilterListCopier.copy(scanStatusReason);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusReason(CoverageStringFilter... scanStatusReason) {
            scanStatusReason(Arrays.asList(scanStatusReason));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanStatusReason(Consumer<CoverageStringFilter.Builder>... scanStatusReason) {
            scanStatusReason(Stream.of(scanStatusReason).map(c -> CoverageStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getAccountId() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.accountId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountId(Collection<CoverageStringFilter.BuilderImpl> accountId) {
            this.accountId = CoverageStringFilterListCopier.copyFromBuilder(accountId);
        }

        @Override
        public final Builder accountId(Collection<CoverageStringFilter> accountId) {
            this.accountId = CoverageStringFilterListCopier.copy(accountId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountId(CoverageStringFilter... accountId) {
            accountId(Arrays.asList(accountId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountId(Consumer<CoverageStringFilter.Builder>... accountId) {
            accountId(Stream.of(accountId).map(c -> CoverageStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getResourceId() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.resourceId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceId(Collection<CoverageStringFilter.BuilderImpl> resourceId) {
            this.resourceId = CoverageStringFilterListCopier.copyFromBuilder(resourceId);
        }

        @Override
        public final Builder resourceId(Collection<CoverageStringFilter> resourceId) {
            this.resourceId = CoverageStringFilterListCopier.copy(resourceId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(CoverageStringFilter... resourceId) {
            resourceId(Arrays.asList(resourceId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceId(Consumer<CoverageStringFilter.Builder>... resourceId) {
            resourceId(Stream.of(resourceId).map(c -> CoverageStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getResourceType() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.resourceType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceType(Collection<CoverageStringFilter.BuilderImpl> resourceType) {
            this.resourceType = CoverageStringFilterListCopier.copyFromBuilder(resourceType);
        }

        @Override
        public final Builder resourceType(Collection<CoverageStringFilter> resourceType) {
            this.resourceType = CoverageStringFilterListCopier.copy(resourceType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(CoverageStringFilter... resourceType) {
            resourceType(Arrays.asList(resourceType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceType(Consumer<CoverageStringFilter.Builder>... resourceType) {
            resourceType(Stream.of(resourceType).map(c -> CoverageStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getScanType() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.scanType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanType(Collection<CoverageStringFilter.BuilderImpl> scanType) {
            this.scanType = CoverageStringFilterListCopier.copyFromBuilder(scanType);
        }

        @Override
        public final Builder scanType(Collection<CoverageStringFilter> scanType) {
            this.scanType = CoverageStringFilterListCopier.copy(scanType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanType(CoverageStringFilter... scanType) {
            scanType(Arrays.asList(scanType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanType(Consumer<CoverageStringFilter.Builder>... scanType) {
            scanType(Stream.of(scanType).map(c -> CoverageStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getEcrRepositoryName() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.ecrRepositoryName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrRepositoryName(Collection<CoverageStringFilter.BuilderImpl> ecrRepositoryName) {
            this.ecrRepositoryName = CoverageStringFilterListCopier.copyFromBuilder(ecrRepositoryName);
        }

        @Override
        public final Builder ecrRepositoryName(Collection<CoverageStringFilter> ecrRepositoryName) {
            this.ecrRepositoryName = CoverageStringFilterListCopier.copy(ecrRepositoryName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrRepositoryName(CoverageStringFilter... ecrRepositoryName) {
            ecrRepositoryName(Arrays.asList(ecrRepositoryName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrRepositoryName(Consumer<CoverageStringFilter.Builder>... ecrRepositoryName) {
            ecrRepositoryName(Stream.of(ecrRepositoryName).map(c -> CoverageStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getEcrImageTags() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.ecrImageTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImageTags(Collection<CoverageStringFilter.BuilderImpl> ecrImageTags) {
            this.ecrImageTags = CoverageStringFilterListCopier.copyFromBuilder(ecrImageTags);
        }

        @Override
        public final Builder ecrImageTags(Collection<CoverageStringFilter> ecrImageTags) {
            this.ecrImageTags = CoverageStringFilterListCopier.copy(ecrImageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageTags(CoverageStringFilter... ecrImageTags) {
            ecrImageTags(Arrays.asList(ecrImageTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageTags(Consumer<CoverageStringFilter.Builder>... ecrImageTags) {
            ecrImageTags(Stream.of(ecrImageTags).map(c -> CoverageStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageMapFilter.Builder> getEc2InstanceTags() {
            List<CoverageMapFilter.Builder> result = CoverageMapFilterListCopier.copyToBuilder(this.ec2InstanceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InstanceTags(Collection<CoverageMapFilter.BuilderImpl> ec2InstanceTags) {
            this.ec2InstanceTags = CoverageMapFilterListCopier.copyFromBuilder(ec2InstanceTags);
        }

        @Override
        public final Builder ec2InstanceTags(Collection<CoverageMapFilter> ec2InstanceTags) {
            this.ec2InstanceTags = CoverageMapFilterListCopier.copy(ec2InstanceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceTags(CoverageMapFilter... ec2InstanceTags) {
            ec2InstanceTags(Arrays.asList(ec2InstanceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceTags(Consumer<CoverageMapFilter.Builder>... ec2InstanceTags) {
            ec2InstanceTags(Stream.of(ec2InstanceTags).map(c -> CoverageMapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getLambdaFunctionName() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.lambdaFunctionName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaFunctionName(Collection<CoverageStringFilter.BuilderImpl> lambdaFunctionName) {
            this.lambdaFunctionName = CoverageStringFilterListCopier.copyFromBuilder(lambdaFunctionName);
        }

        @Override
        public final Builder lambdaFunctionName(Collection<CoverageStringFilter> lambdaFunctionName) {
            this.lambdaFunctionName = CoverageStringFilterListCopier.copy(lambdaFunctionName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionName(CoverageStringFilter... lambdaFunctionName) {
            lambdaFunctionName(Arrays.asList(lambdaFunctionName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionName(Consumer<CoverageStringFilter.Builder>... lambdaFunctionName) {
            lambdaFunctionName(Stream.of(lambdaFunctionName).map(c -> CoverageStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageMapFilter.Builder> getLambdaFunctionTags() {
            List<CoverageMapFilter.Builder> result = CoverageMapFilterListCopier.copyToBuilder(this.lambdaFunctionTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaFunctionTags(Collection<CoverageMapFilter.BuilderImpl> lambdaFunctionTags) {
            this.lambdaFunctionTags = CoverageMapFilterListCopier.copyFromBuilder(lambdaFunctionTags);
        }

        @Override
        public final Builder lambdaFunctionTags(Collection<CoverageMapFilter> lambdaFunctionTags) {
            this.lambdaFunctionTags = CoverageMapFilterListCopier.copy(lambdaFunctionTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionTags(CoverageMapFilter... lambdaFunctionTags) {
            lambdaFunctionTags(Arrays.asList(lambdaFunctionTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionTags(Consumer<CoverageMapFilter.Builder>... lambdaFunctionTags) {
            lambdaFunctionTags(Stream.of(lambdaFunctionTags).map(c -> CoverageMapFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getLambdaFunctionRuntime() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.lambdaFunctionRuntime);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLambdaFunctionRuntime(Collection<CoverageStringFilter.BuilderImpl> lambdaFunctionRuntime) {
            this.lambdaFunctionRuntime = CoverageStringFilterListCopier.copyFromBuilder(lambdaFunctionRuntime);
        }

        @Override
        public final Builder lambdaFunctionRuntime(Collection<CoverageStringFilter> lambdaFunctionRuntime) {
            this.lambdaFunctionRuntime = CoverageStringFilterListCopier.copy(lambdaFunctionRuntime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionRuntime(CoverageStringFilter... lambdaFunctionRuntime) {
            lambdaFunctionRuntime(Arrays.asList(lambdaFunctionRuntime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionRuntime(Consumer<CoverageStringFilter.Builder>... lambdaFunctionRuntime) {
            lambdaFunctionRuntime(Stream.of(lambdaFunctionRuntime)
                    .map(c -> CoverageStringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageDateFilter.Builder> getLastScannedAt() {
            List<CoverageDateFilter.Builder> result = CoverageDateFilterListCopier.copyToBuilder(this.lastScannedAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastScannedAt(Collection<CoverageDateFilter.BuilderImpl> lastScannedAt) {
            this.lastScannedAt = CoverageDateFilterListCopier.copyFromBuilder(lastScannedAt);
        }

        @Override
        public final Builder lastScannedAt(Collection<CoverageDateFilter> lastScannedAt) {
            this.lastScannedAt = CoverageDateFilterListCopier.copy(lastScannedAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastScannedAt(CoverageDateFilter... lastScannedAt) {
            lastScannedAt(Arrays.asList(lastScannedAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastScannedAt(Consumer<CoverageDateFilter.Builder>... lastScannedAt) {
            lastScannedAt(Stream.of(lastScannedAt).map(c -> CoverageDateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getScanMode() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.scanMode);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanMode(Collection<CoverageStringFilter.BuilderImpl> scanMode) {
            this.scanMode = CoverageStringFilterListCopier.copyFromBuilder(scanMode);
        }

        @Override
        public final Builder scanMode(Collection<CoverageStringFilter> scanMode) {
            this.scanMode = CoverageStringFilterListCopier.copy(scanMode);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanMode(CoverageStringFilter... scanMode) {
            scanMode(Arrays.asList(scanMode));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanMode(Consumer<CoverageStringFilter.Builder>... scanMode) {
            scanMode(Stream.of(scanMode).map(c -> CoverageStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageDateFilter.Builder> getImagePulledAt() {
            List<CoverageDateFilter.Builder> result = CoverageDateFilterListCopier.copyToBuilder(this.imagePulledAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImagePulledAt(Collection<CoverageDateFilter.BuilderImpl> imagePulledAt) {
            this.imagePulledAt = CoverageDateFilterListCopier.copyFromBuilder(imagePulledAt);
        }

        @Override
        public final Builder imagePulledAt(Collection<CoverageDateFilter> imagePulledAt) {
            this.imagePulledAt = CoverageDateFilterListCopier.copy(imagePulledAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePulledAt(CoverageDateFilter... imagePulledAt) {
            imagePulledAt(Arrays.asList(imagePulledAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePulledAt(Consumer<CoverageDateFilter.Builder>... imagePulledAt) {
            imagePulledAt(Stream.of(imagePulledAt).map(c -> CoverageDateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageDateFilter.Builder> getEcrImageLastInUseAt() {
            List<CoverageDateFilter.Builder> result = CoverageDateFilterListCopier.copyToBuilder(this.ecrImageLastInUseAt);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImageLastInUseAt(Collection<CoverageDateFilter.BuilderImpl> ecrImageLastInUseAt) {
            this.ecrImageLastInUseAt = CoverageDateFilterListCopier.copyFromBuilder(ecrImageLastInUseAt);
        }

        @Override
        public final Builder ecrImageLastInUseAt(Collection<CoverageDateFilter> ecrImageLastInUseAt) {
            this.ecrImageLastInUseAt = CoverageDateFilterListCopier.copy(ecrImageLastInUseAt);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageLastInUseAt(CoverageDateFilter... ecrImageLastInUseAt) {
            ecrImageLastInUseAt(Arrays.asList(ecrImageLastInUseAt));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageLastInUseAt(Consumer<CoverageDateFilter.Builder>... ecrImageLastInUseAt) {
            ecrImageLastInUseAt(Stream.of(ecrImageLastInUseAt).map(c -> CoverageDateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageNumberFilter.Builder> getEcrImageInUseCount() {
            List<CoverageNumberFilter.Builder> result = CoverageNumberFilterListCopier.copyToBuilder(this.ecrImageInUseCount);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcrImageInUseCount(Collection<CoverageNumberFilter.BuilderImpl> ecrImageInUseCount) {
            this.ecrImageInUseCount = CoverageNumberFilterListCopier.copyFromBuilder(ecrImageInUseCount);
        }

        @Override
        public final Builder ecrImageInUseCount(Collection<CoverageNumberFilter> ecrImageInUseCount) {
            this.ecrImageInUseCount = CoverageNumberFilterListCopier.copy(ecrImageInUseCount);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageInUseCount(CoverageNumberFilter... ecrImageInUseCount) {
            ecrImageInUseCount(Arrays.asList(ecrImageInUseCount));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecrImageInUseCount(Consumer<CoverageNumberFilter.Builder>... ecrImageInUseCount) {
            ecrImageInUseCount(Stream.of(ecrImageInUseCount).map(c -> CoverageNumberFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getCodeRepositoryProjectName() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier
                    .copyToBuilder(this.codeRepositoryProjectName);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeRepositoryProjectName(Collection<CoverageStringFilter.BuilderImpl> codeRepositoryProjectName) {
            this.codeRepositoryProjectName = CoverageStringFilterListCopier.copyFromBuilder(codeRepositoryProjectName);
        }

        @Override
        public final Builder codeRepositoryProjectName(Collection<CoverageStringFilter> codeRepositoryProjectName) {
            this.codeRepositoryProjectName = CoverageStringFilterListCopier.copy(codeRepositoryProjectName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositoryProjectName(CoverageStringFilter... codeRepositoryProjectName) {
            codeRepositoryProjectName(Arrays.asList(codeRepositoryProjectName));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositoryProjectName(Consumer<CoverageStringFilter.Builder>... codeRepositoryProjectName) {
            codeRepositoryProjectName(Stream.of(codeRepositoryProjectName)
                    .map(c -> CoverageStringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getCodeRepositoryProviderType() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier
                    .copyToBuilder(this.codeRepositoryProviderType);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeRepositoryProviderType(Collection<CoverageStringFilter.BuilderImpl> codeRepositoryProviderType) {
            this.codeRepositoryProviderType = CoverageStringFilterListCopier.copyFromBuilder(codeRepositoryProviderType);
        }

        @Override
        public final Builder codeRepositoryProviderType(Collection<CoverageStringFilter> codeRepositoryProviderType) {
            this.codeRepositoryProviderType = CoverageStringFilterListCopier.copy(codeRepositoryProviderType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositoryProviderType(CoverageStringFilter... codeRepositoryProviderType) {
            codeRepositoryProviderType(Arrays.asList(codeRepositoryProviderType));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositoryProviderType(Consumer<CoverageStringFilter.Builder>... codeRepositoryProviderType) {
            codeRepositoryProviderType(Stream.of(codeRepositoryProviderType)
                    .map(c -> CoverageStringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getCodeRepositoryProviderTypeVisibility() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier
                    .copyToBuilder(this.codeRepositoryProviderTypeVisibility);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeRepositoryProviderTypeVisibility(
                Collection<CoverageStringFilter.BuilderImpl> codeRepositoryProviderTypeVisibility) {
            this.codeRepositoryProviderTypeVisibility = CoverageStringFilterListCopier
                    .copyFromBuilder(codeRepositoryProviderTypeVisibility);
        }

        @Override
        public final Builder codeRepositoryProviderTypeVisibility(
                Collection<CoverageStringFilter> codeRepositoryProviderTypeVisibility) {
            this.codeRepositoryProviderTypeVisibility = CoverageStringFilterListCopier.copy(codeRepositoryProviderTypeVisibility);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositoryProviderTypeVisibility(CoverageStringFilter... codeRepositoryProviderTypeVisibility) {
            codeRepositoryProviderTypeVisibility(Arrays.asList(codeRepositoryProviderTypeVisibility));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositoryProviderTypeVisibility(
                Consumer<CoverageStringFilter.Builder>... codeRepositoryProviderTypeVisibility) {
            codeRepositoryProviderTypeVisibility(Stream.of(codeRepositoryProviderTypeVisibility)
                    .map(c -> CoverageStringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CoverageStringFilter.Builder> getLastScannedCommitId() {
            List<CoverageStringFilter.Builder> result = CoverageStringFilterListCopier.copyToBuilder(this.lastScannedCommitId);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastScannedCommitId(Collection<CoverageStringFilter.BuilderImpl> lastScannedCommitId) {
            this.lastScannedCommitId = CoverageStringFilterListCopier.copyFromBuilder(lastScannedCommitId);
        }

        @Override
        public final Builder lastScannedCommitId(Collection<CoverageStringFilter> lastScannedCommitId) {
            this.lastScannedCommitId = CoverageStringFilterListCopier.copy(lastScannedCommitId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastScannedCommitId(CoverageStringFilter... lastScannedCommitId) {
            lastScannedCommitId(Arrays.asList(lastScannedCommitId));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastScannedCommitId(Consumer<CoverageStringFilter.Builder>... lastScannedCommitId) {
            lastScannedCommitId(Stream.of(lastScannedCommitId).map(c -> CoverageStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CoverageFilterCriteria build() {
            return new CoverageFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
