/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details required to create a code security integration with a specific repository provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIntegrationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateIntegrationDetail.Builder, CreateIntegrationDetail> {
    private static final SdkField<CreateGitLabSelfManagedIntegrationDetail> GITLAB_SELF_MANAGED_FIELD = SdkField
            .<CreateGitLabSelfManagedIntegrationDetail> builder(MarshallingType.SDK_POJO).memberName("gitlabSelfManaged")
            .getter(getter(CreateIntegrationDetail::gitlabSelfManaged)).setter(setter(Builder::gitlabSelfManaged))
            .constructor(CreateGitLabSelfManagedIntegrationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitlabSelfManaged").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GITLAB_SELF_MANAGED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CreateGitLabSelfManagedIntegrationDetail gitlabSelfManaged;

    private final Type type;

    private CreateIntegrationDetail(BuilderImpl builder) {
        this.gitlabSelfManaged = builder.gitlabSelfManaged;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details specific to creating an integration with a self-managed GitLab instance.
     * </p>
     * 
     * @return Details specific to creating an integration with a self-managed GitLab instance.
     */
    public final CreateGitLabSelfManagedIntegrationDetail gitlabSelfManaged() {
        return gitlabSelfManaged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gitlabSelfManaged());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationDetail)) {
            return false;
        }
        CreateIntegrationDetail other = (CreateIntegrationDetail) obj;
        return Objects.equals(gitlabSelfManaged(), other.gitlabSelfManaged());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIntegrationDetail").add("GitlabSelfManaged", gitlabSelfManaged()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gitlabSelfManaged":
            return Optional.ofNullable(clazz.cast(gitlabSelfManaged()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #gitlabSelfManaged()} initialized to the given value.
     *
     * <p>
     * Details specific to creating an integration with a self-managed GitLab instance.
     * </p>
     * 
     * @param gitlabSelfManaged
     *        Details specific to creating an integration with a self-managed GitLab instance.
     */
    public static CreateIntegrationDetail fromGitlabSelfManaged(CreateGitLabSelfManagedIntegrationDetail gitlabSelfManaged) {
        return builder().gitlabSelfManaged(gitlabSelfManaged).build();
    }

    /**
     * Create an instance of this class with {@link #gitlabSelfManaged()} initialized to the given value.
     *
     * <p>
     * Details specific to creating an integration with a self-managed GitLab instance.
     * </p>
     * 
     * @param gitlabSelfManaged
     *        Details specific to creating an integration with a self-managed GitLab instance.
     */
    public static CreateIntegrationDetail fromGitlabSelfManaged(
            Consumer<CreateGitLabSelfManagedIntegrationDetail.Builder> gitlabSelfManaged) {
        CreateGitLabSelfManagedIntegrationDetail.Builder builder = CreateGitLabSelfManagedIntegrationDetail.builder();
        gitlabSelfManaged.accept(builder);
        return fromGitlabSelfManaged(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gitlabSelfManaged", GITLAB_SELF_MANAGED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationDetail, T> g) {
        return obj -> g.apply((CreateIntegrationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateIntegrationDetail> {
        /**
         * <p>
         * Details specific to creating an integration with a self-managed GitLab instance.
         * </p>
         * 
         * @param gitlabSelfManaged
         *        Details specific to creating an integration with a self-managed GitLab instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitlabSelfManaged(CreateGitLabSelfManagedIntegrationDetail gitlabSelfManaged);

        /**
         * <p>
         * Details specific to creating an integration with a self-managed GitLab instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateGitLabSelfManagedIntegrationDetail.Builder} avoiding the need to create one manually via
         * {@link CreateGitLabSelfManagedIntegrationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateGitLabSelfManagedIntegrationDetail.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #gitlabSelfManaged(CreateGitLabSelfManagedIntegrationDetail)}.
         * 
         * @param gitlabSelfManaged
         *        a consumer that will call methods on {@link CreateGitLabSelfManagedIntegrationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitlabSelfManaged(CreateGitLabSelfManagedIntegrationDetail)
         */
        default Builder gitlabSelfManaged(Consumer<CreateGitLabSelfManagedIntegrationDetail.Builder> gitlabSelfManaged) {
            return gitlabSelfManaged(CreateGitLabSelfManagedIntegrationDetail.builder().applyMutation(gitlabSelfManaged).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CreateGitLabSelfManagedIntegrationDetail gitlabSelfManaged;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationDetail model) {
            gitlabSelfManaged(model.gitlabSelfManaged);
        }

        public final CreateGitLabSelfManagedIntegrationDetail.Builder getGitlabSelfManaged() {
            return gitlabSelfManaged != null ? gitlabSelfManaged.toBuilder() : null;
        }

        public final void setGitlabSelfManaged(CreateGitLabSelfManagedIntegrationDetail.BuilderImpl gitlabSelfManaged) {
            Object oldValue = this.gitlabSelfManaged;
            this.gitlabSelfManaged = gitlabSelfManaged != null ? gitlabSelfManaged.build() : null;
            handleUnionValueChange(Type.GITLAB_SELF_MANAGED, oldValue, this.gitlabSelfManaged);
        }

        @Override
        public final Builder gitlabSelfManaged(CreateGitLabSelfManagedIntegrationDetail gitlabSelfManaged) {
            Object oldValue = this.gitlabSelfManaged;
            this.gitlabSelfManaged = gitlabSelfManaged;
            handleUnionValueChange(Type.GITLAB_SELF_MANAGED, oldValue, this.gitlabSelfManaged);
            return this;
        }

        @Override
        public CreateIntegrationDetail build() {
            return new CreateIntegrationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CreateIntegrationDetail#type()
     */
    public enum Type {
        GITLAB_SELF_MANAGED,

        UNKNOWN_TO_SDK_VERSION
    }
}
