/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DisassociateConfigurationRequestListCopier {
    static List<DisassociateConfigurationRequest> copy(
            Collection<? extends DisassociateConfigurationRequest> disassociateConfigurationRequestListParam) {
        List<DisassociateConfigurationRequest> list;
        if (disassociateConfigurationRequestListParam == null
                || disassociateConfigurationRequestListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DisassociateConfigurationRequest> modifiableList = new ArrayList<>(
                    disassociateConfigurationRequestListParam.size());
            disassociateConfigurationRequestListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DisassociateConfigurationRequest> copyFromBuilder(
            Collection<? extends DisassociateConfigurationRequest.Builder> disassociateConfigurationRequestListParam) {
        List<DisassociateConfigurationRequest> list;
        if (disassociateConfigurationRequestListParam == null
                || disassociateConfigurationRequestListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DisassociateConfigurationRequest> modifiableList = new ArrayList<>(
                    disassociateConfigurationRequestListParam.size());
            disassociateConfigurationRequestListParam.forEach(entry -> {
                DisassociateConfigurationRequest member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DisassociateConfigurationRequest.Builder> copyToBuilder(
            Collection<? extends DisassociateConfigurationRequest> disassociateConfigurationRequestListParam) {
        List<DisassociateConfigurationRequest.Builder> list;
        if (disassociateConfigurationRequestListParam == null
                || disassociateConfigurationRequestListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DisassociateConfigurationRequest.Builder> modifiableList = new ArrayList<>(
                    disassociateConfigurationRequestListParam.size());
            disassociateConfigurationRequestListParam.forEach(entry -> {
                DisassociateConfigurationRequest.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
