/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information on when this exploit was observed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExploitObserved implements SdkPojo, Serializable, ToCopyableBuilder<ExploitObserved.Builder, ExploitObserved> {
    private static final SdkField<Instant> LAST_SEEN_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastSeen").getter(getter(ExploitObserved::lastSeen)).setter(setter(Builder::lastSeen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSeen").build()).build();

    private static final SdkField<Instant> FIRST_SEEN_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstSeen").getter(getter(ExploitObserved::firstSeen)).setter(setter(Builder::firstSeen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstSeen").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_SEEN_FIELD,
            FIRST_SEEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant lastSeen;

    private final Instant firstSeen;

    private ExploitObserved(BuilderImpl builder) {
        this.lastSeen = builder.lastSeen;
        this.firstSeen = builder.firstSeen;
    }

    /**
     * <p>
     * The date an time when the exploit was last seen.
     * </p>
     * 
     * @return The date an time when the exploit was last seen.
     */
    public final Instant lastSeen() {
        return lastSeen;
    }

    /**
     * <p>
     * The date an time when the exploit was first seen.
     * </p>
     * 
     * @return The date an time when the exploit was first seen.
     */
    public final Instant firstSeen() {
        return firstSeen;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastSeen());
        hashCode = 31 * hashCode + Objects.hashCode(firstSeen());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExploitObserved)) {
            return false;
        }
        ExploitObserved other = (ExploitObserved) obj;
        return Objects.equals(lastSeen(), other.lastSeen()) && Objects.equals(firstSeen(), other.firstSeen());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExploitObserved").add("LastSeen", lastSeen()).add("FirstSeen", firstSeen()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastSeen":
            return Optional.ofNullable(clazz.cast(lastSeen()));
        case "firstSeen":
            return Optional.ofNullable(clazz.cast(firstSeen()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lastSeen", LAST_SEEN_FIELD);
        map.put("firstSeen", FIRST_SEEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExploitObserved, T> g) {
        return obj -> g.apply((ExploitObserved) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExploitObserved> {
        /**
         * <p>
         * The date an time when the exploit was last seen.
         * </p>
         * 
         * @param lastSeen
         *        The date an time when the exploit was last seen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSeen(Instant lastSeen);

        /**
         * <p>
         * The date an time when the exploit was first seen.
         * </p>
         * 
         * @param firstSeen
         *        The date an time when the exploit was first seen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSeen(Instant firstSeen);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastSeen;

        private Instant firstSeen;

        private BuilderImpl() {
        }

        private BuilderImpl(ExploitObserved model) {
            lastSeen(model.lastSeen);
            firstSeen(model.firstSeen);
        }

        public final Instant getLastSeen() {
            return lastSeen;
        }

        public final void setLastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
        }

        @Override
        public final Builder lastSeen(Instant lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public final Instant getFirstSeen() {
            return firstSeen;
        }

        public final void setFirstSeen(Instant firstSeen) {
            this.firstSeen = firstSeen;
        }

        @Override
        public final Builder firstSeen(Instant firstSeen) {
            this.firstSeen = firstSeen;
            return this;
        }

        @Override
        public ExploitObserved build() {
            return new ExploitObserved(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
