/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a failed attempt to associate or disassociate a code repository with a scan configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedAssociationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedAssociationResult.Builder, FailedAssociationResult> {
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanConfigurationArn").getter(getter(FailedAssociationResult::scanConfigurationArn))
            .setter(setter(Builder::scanConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build())
            .build();

    private static final SdkField<CodeSecurityResource> RESOURCE_FIELD = SdkField
            .<CodeSecurityResource> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(FailedAssociationResult::resource)).setter(setter(Builder::resource))
            .constructor(CodeSecurityResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(FailedAssociationResult::statusCodeAsString))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(FailedAssociationResult::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_CONFIGURATION_ARN_FIELD,
            RESOURCE_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scanConfigurationArn;

    private final CodeSecurityResource resource;

    private final String statusCodeValue;

    private final String statusMessage;

    private FailedAssociationResult(BuilderImpl builder) {
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.resource = builder.resource;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scan configuration that failed to be associated or disassociated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scan configuration that failed to be associated or disassociated.
     */
    public final String scanConfigurationArn() {
        return scanConfigurationArn;
    }

    /**
     * Returns the value of the Resource property for this object.
     * 
     * @return The value of the Resource property for this object.
     */
    public final CodeSecurityResource resource() {
        return resource;
    }

    /**
     * <p>
     * The status code indicating why the association or disassociation failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link AssociationResultStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code indicating why the association or disassociation failed.
     * @see AssociationResultStatusCode
     */
    public final AssociationResultStatusCode statusCode() {
        return AssociationResultStatusCode.fromValue(statusCodeValue);
    }

    /**
     * <p>
     * The status code indicating why the association or disassociation failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link AssociationResultStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The status code indicating why the association or disassociation failed.
     * @see AssociationResultStatusCode
     */
    public final String statusCodeAsString() {
        return statusCodeValue;
    }

    /**
     * <p>
     * A message explaining why the association or disassociation failed.
     * </p>
     * 
     * @return A message explaining why the association or disassociation failed.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedAssociationResult)) {
            return false;
        }
        FailedAssociationResult other = (FailedAssociationResult) obj;
        return Objects.equals(scanConfigurationArn(), other.scanConfigurationArn())
                && Objects.equals(resource(), other.resource())
                && Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedAssociationResult").add("ScanConfigurationArn", scanConfigurationArn())
                .add("Resource", resource()).add("StatusCode", statusCodeAsString()).add("StatusMessage", statusMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanConfigurationArn":
            return Optional.ofNullable(clazz.cast(scanConfigurationArn()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("statusCode", STATUS_CODE_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedAssociationResult, T> g) {
        return obj -> g.apply((FailedAssociationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedAssociationResult> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scan configuration that failed to be associated or disassociated.
         * </p>
         * 
         * @param scanConfigurationArn
         *        The Amazon Resource Name (ARN) of the scan configuration that failed to be associated or
         *        disassociated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArn(String scanConfigurationArn);

        /**
         * Sets the value of the Resource property for this object.
         *
         * @param resource
         *        The new value for the Resource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(CodeSecurityResource resource);

        /**
         * Sets the value of the Resource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CodeSecurityResource.Builder} avoiding
         * the need to create one manually via {@link CodeSecurityResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeSecurityResource.Builder#build()} is called immediately and
         * its result is passed to {@link #resource(CodeSecurityResource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link CodeSecurityResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(CodeSecurityResource)
         */
        default Builder resource(Consumer<CodeSecurityResource.Builder> resource) {
            return resource(CodeSecurityResource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The status code indicating why the association or disassociation failed.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code indicating why the association or disassociation failed.
         * @see AssociationResultStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationResultStatusCode
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * The status code indicating why the association or disassociation failed.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code indicating why the association or disassociation failed.
         * @see AssociationResultStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationResultStatusCode
         */
        Builder statusCode(AssociationResultStatusCode statusCodeValue);

        /**
         * <p>
         * A message explaining why the association or disassociation failed.
         * </p>
         * 
         * @param statusMessage
         *        A message explaining why the association or disassociation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String scanConfigurationArn;

        private CodeSecurityResource resource;

        private String statusCodeValue;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedAssociationResult model) {
            scanConfigurationArn(model.scanConfigurationArn);
            resource(model.resource);
            statusCode(model.statusCodeValue);
            statusMessage(model.statusMessage);
        }

        public final String getScanConfigurationArn() {
            return scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final CodeSecurityResource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(CodeSecurityResource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(CodeSecurityResource resource) {
            this.resource = resource;
            return this;
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(AssociationResultStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public FailedAssociationResult build() {
            return new FailedAssociationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
