/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response that contains the results of a finding type aggregation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingTypeAggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingTypeAggregationResponse.Builder, FindingTypeAggregationResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(FindingTypeAggregationResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(FindingTypeAggregationResponse::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final SdkField<Long> EXPLOIT_AVAILABLE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("exploitAvailableCount").getter(getter(FindingTypeAggregationResponse::exploitAvailableCount))
            .setter(setter(Builder::exploitAvailableCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exploitAvailableCount").build())
            .build();

    private static final SdkField<Long> FIX_AVAILABLE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("fixAvailableCount").getter(getter(FindingTypeAggregationResponse::fixAvailableCount))
            .setter(setter(Builder::fixAvailableCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixAvailableCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            SEVERITY_COUNTS_FIELD, EXPLOIT_AVAILABLE_COUNT_FIELD, FIX_AVAILABLE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final SeverityCounts severityCounts;

    private final Long exploitAvailableCount;

    private final Long fixAvailableCount;

    private FindingTypeAggregationResponse(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.severityCounts = builder.severityCounts;
        this.exploitAvailableCount = builder.exploitAvailableCount;
        this.fixAvailableCount = builder.fixAvailableCount;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account associated with the findings.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account associated with the findings.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * 
     * @return The value to sort results by.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    /**
     * <p>
     * The number of findings that have an exploit available.
     * </p>
     * 
     * @return The number of findings that have an exploit available.
     */
    public final Long exploitAvailableCount() {
        return exploitAvailableCount;
    }

    /**
     * <p>
     * Details about the number of fixes.
     * </p>
     * 
     * @return Details about the number of fixes.
     */
    public final Long fixAvailableCount() {
        return fixAvailableCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        hashCode = 31 * hashCode + Objects.hashCode(exploitAvailableCount());
        hashCode = 31 * hashCode + Objects.hashCode(fixAvailableCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingTypeAggregationResponse)) {
            return false;
        }
        FindingTypeAggregationResponse other = (FindingTypeAggregationResponse) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(severityCounts(), other.severityCounts())
                && Objects.equals(exploitAvailableCount(), other.exploitAvailableCount())
                && Objects.equals(fixAvailableCount(), other.fixAvailableCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingTypeAggregationResponse").add("AccountId", accountId())
                .add("SeverityCounts", severityCounts()).add("ExploitAvailableCount", exploitAvailableCount())
                .add("FixAvailableCount", fixAvailableCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        case "exploitAvailableCount":
            return Optional.ofNullable(clazz.cast(exploitAvailableCount()));
        case "fixAvailableCount":
            return Optional.ofNullable(clazz.cast(fixAvailableCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        map.put("exploitAvailableCount", EXPLOIT_AVAILABLE_COUNT_FIELD);
        map.put("fixAvailableCount", FIX_AVAILABLE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingTypeAggregationResponse, T> g) {
        return obj -> g.apply((FindingTypeAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingTypeAggregationResponse> {
        /**
         * <p>
         * The ID of the Amazon Web Services account associated with the findings.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account associated with the findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param severityCounts
         *        The value to sort results by.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }

        /**
         * <p>
         * The number of findings that have an exploit available.
         * </p>
         * 
         * @param exploitAvailableCount
         *        The number of findings that have an exploit available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exploitAvailableCount(Long exploitAvailableCount);

        /**
         * <p>
         * Details about the number of fixes.
         * </p>
         * 
         * @param fixAvailableCount
         *        Details about the number of fixes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixAvailableCount(Long fixAvailableCount);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private SeverityCounts severityCounts;

        private Long exploitAvailableCount;

        private Long fixAvailableCount;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingTypeAggregationResponse model) {
            accountId(model.accountId);
            severityCounts(model.severityCounts);
            exploitAvailableCount(model.exploitAvailableCount);
            fixAvailableCount(model.fixAvailableCount);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public final Long getExploitAvailableCount() {
            return exploitAvailableCount;
        }

        public final void setExploitAvailableCount(Long exploitAvailableCount) {
            this.exploitAvailableCount = exploitAvailableCount;
        }

        @Override
        public final Builder exploitAvailableCount(Long exploitAvailableCount) {
            this.exploitAvailableCount = exploitAvailableCount;
            return this;
        }

        public final Long getFixAvailableCount() {
            return fixAvailableCount;
        }

        public final void setFixAvailableCount(Long fixAvailableCount) {
            this.fixAvailableCount = fixAvailableCount;
        }

        @Override
        public final Builder fixAvailableCount(Long fixAvailableCount) {
            this.fixAvailableCount = fixAvailableCount;
            return this;
        }

        @Override
        public FindingTypeAggregationResponse build() {
            return new FindingTypeAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
