/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about the Amazon Inspector free trial for an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FreeTrialInfo implements SdkPojo, Serializable, ToCopyableBuilder<FreeTrialInfo.Builder, FreeTrialInfo> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FreeTrialInfo::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> START_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("start")
            .getter(getter(FreeTrialInfo::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<Instant> END_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("end")
            .getter(getter(FreeTrialInfo::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(FreeTrialInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, START_FIELD,
            END_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Instant start;

    private final Instant end;

    private final String status;

    private FreeTrialInfo(BuilderImpl builder) {
        this.type = builder.type;
        this.start = builder.start;
        this.end = builder.end;
        this.status = builder.status;
    }

    /**
     * <p>
     * The type of scan covered by the Amazon Inspector free trail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FreeTrialType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of scan covered by the Amazon Inspector free trail.
     * @see FreeTrialType
     */
    public final FreeTrialType type() {
        return FreeTrialType.fromValue(type);
    }

    /**
     * <p>
     * The type of scan covered by the Amazon Inspector free trail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FreeTrialType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of scan covered by the Amazon Inspector free trail.
     * @see FreeTrialType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The date and time that the Amazon Inspector free trail started for a given account.
     * </p>
     * 
     * @return The date and time that the Amazon Inspector free trail started for a given account.
     */
    public final Instant start() {
        return start;
    }

    /**
     * <p>
     * The date and time that the Amazon Inspector free trail ends for a given account.
     * </p>
     * 
     * @return The date and time that the Amazon Inspector free trail ends for a given account.
     */
    public final Instant end() {
        return end;
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FreeTrialStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see FreeTrialStatus
     */
    public final FreeTrialStatus status() {
        return FreeTrialStatus.fromValue(status);
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FreeTrialStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see FreeTrialStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeTrialInfo)) {
            return false;
        }
        FreeTrialInfo other = (FreeTrialInfo) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(start(), other.start())
                && Objects.equals(end(), other.end()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FreeTrialInfo").add("Type", typeAsString()).add("Start", start()).add("End", end())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("start", START_FIELD);
        map.put("end", END_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FreeTrialInfo, T> g) {
        return obj -> g.apply((FreeTrialInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FreeTrialInfo> {
        /**
         * <p>
         * The type of scan covered by the Amazon Inspector free trail.
         * </p>
         * 
         * @param type
         *        The type of scan covered by the Amazon Inspector free trail.
         * @see FreeTrialType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FreeTrialType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of scan covered by the Amazon Inspector free trail.
         * </p>
         * 
         * @param type
         *        The type of scan covered by the Amazon Inspector free trail.
         * @see FreeTrialType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FreeTrialType
         */
        Builder type(FreeTrialType type);

        /**
         * <p>
         * The date and time that the Amazon Inspector free trail started for a given account.
         * </p>
         * 
         * @param start
         *        The date and time that the Amazon Inspector free trail started for a given account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The date and time that the Amazon Inspector free trail ends for a given account.
         * </p>
         * 
         * @param end
         *        The date and time that the Amazon Inspector free trail ends for a given account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param status
         *        The order to sort results by.
         * @see FreeTrialStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FreeTrialStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param status
         *        The order to sort results by.
         * @see FreeTrialStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FreeTrialStatus
         */
        Builder status(FreeTrialStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Instant start;

        private Instant end;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(FreeTrialInfo model) {
            type(model.type);
            start(model.start);
            end(model.end);
            status(model.status);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FreeTrialType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getStart() {
            return start;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final Instant getEnd() {
            return end;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FreeTrialStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public FreeTrialInfo build() {
            return new FreeTrialInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
