/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCodeSecurityScanResponse extends Inspector2Response implements
        ToCopyableBuilder<GetCodeSecurityScanResponse.Builder, GetCodeSecurityScanResponse> {
    private static final SdkField<String> SCAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scanId")
            .getter(getter(GetCodeSecurityScanResponse::scanId)).setter(setter(Builder::scanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanId").build()).build();

    private static final SdkField<CodeSecurityResource> RESOURCE_FIELD = SdkField
            .<CodeSecurityResource> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(GetCodeSecurityScanResponse::resource)).setter(setter(Builder::resource))
            .constructor(CodeSecurityResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(GetCodeSecurityScanResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetCodeSecurityScanResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetCodeSecurityScanResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetCodeSecurityScanResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetCodeSecurityScanResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> LAST_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastCommitId").getter(getter(GetCodeSecurityScanResponse::lastCommitId))
            .setter(setter(Builder::lastCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastCommitId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ID_FIELD, RESOURCE_FIELD,
            ACCOUNT_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, LAST_COMMIT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scanId;

    private final CodeSecurityResource resource;

    private final String accountId;

    private final String status;

    private final String statusReason;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String lastCommitId;

    private GetCodeSecurityScanResponse(BuilderImpl builder) {
        super(builder);
        this.scanId = builder.scanId;
        this.resource = builder.resource;
        this.accountId = builder.accountId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.lastCommitId = builder.lastCommitId;
    }

    /**
     * <p>
     * The unique identifier of the scan.
     * </p>
     * 
     * @return The unique identifier of the scan.
     */
    public final String scanId() {
        return scanId;
    }

    /**
     * <p>
     * The resource identifier for the code repository that was scanned.
     * </p>
     * 
     * @return The resource identifier for the code repository that was scanned.
     */
    public final CodeSecurityResource resource() {
        return resource;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the scan.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the scan.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The current status of the scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodeScanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the scan.
     * @see CodeScanStatus
     */
    public final CodeScanStatus status() {
        return CodeScanStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the scan.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodeScanStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the scan.
     * @see CodeScanStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the current status of the scan.
     * </p>
     * 
     * @return The reason for the current status of the scan.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The timestamp when the scan was created.
     * </p>
     * 
     * @return The timestamp when the scan was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the scan was last updated.
     * </p>
     * 
     * @return The timestamp when the scan was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The identifier of the last commit that was scanned. This is only returned if the scan was successful or skipped.
     * </p>
     * 
     * @return The identifier of the last commit that was scanned. This is only returned if the scan was successful or
     *         skipped.
     */
    public final String lastCommitId() {
        return lastCommitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scanId());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastCommitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCodeSecurityScanResponse)) {
            return false;
        }
        GetCodeSecurityScanResponse other = (GetCodeSecurityScanResponse) obj;
        return Objects.equals(scanId(), other.scanId()) && Objects.equals(resource(), other.resource())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(lastCommitId(), other.lastCommitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCodeSecurityScanResponse").add("ScanId", scanId()).add("Resource", resource())
                .add("AccountId", accountId()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("LastCommitId", lastCommitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanId":
            return Optional.ofNullable(clazz.cast(scanId()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "lastCommitId":
            return Optional.ofNullable(clazz.cast(lastCommitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanId", SCAN_ID_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("lastCommitId", LAST_COMMIT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCodeSecurityScanResponse, T> g) {
        return obj -> g.apply((GetCodeSecurityScanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetCodeSecurityScanResponse> {
        /**
         * <p>
         * The unique identifier of the scan.
         * </p>
         * 
         * @param scanId
         *        The unique identifier of the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanId(String scanId);

        /**
         * <p>
         * The resource identifier for the code repository that was scanned.
         * </p>
         * 
         * @param resource
         *        The resource identifier for the code repository that was scanned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(CodeSecurityResource resource);

        /**
         * <p>
         * The resource identifier for the code repository that was scanned.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeSecurityResource.Builder} avoiding
         * the need to create one manually via {@link CodeSecurityResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeSecurityResource.Builder#build()} is called immediately and
         * its result is passed to {@link #resource(CodeSecurityResource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link CodeSecurityResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(CodeSecurityResource)
         */
        default Builder resource(Consumer<CodeSecurityResource.Builder> resource) {
            return resource(CodeSecurityResource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The Amazon Web Services account ID associated with the scan.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID associated with the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The current status of the scan.
         * </p>
         * 
         * @param status
         *        The current status of the scan.
         * @see CodeScanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeScanStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the scan.
         * </p>
         * 
         * @param status
         *        The current status of the scan.
         * @see CodeScanStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeScanStatus
         */
        Builder status(CodeScanStatus status);

        /**
         * <p>
         * The reason for the current status of the scan.
         * </p>
         * 
         * @param statusReason
         *        The reason for the current status of the scan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The timestamp when the scan was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the scan was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the scan was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the scan was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The identifier of the last commit that was scanned. This is only returned if the scan was successful or
         * skipped.
         * </p>
         * 
         * @param lastCommitId
         *        The identifier of the last commit that was scanned. This is only returned if the scan was successful
         *        or skipped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastCommitId(String lastCommitId);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private String scanId;

        private CodeSecurityResource resource;

        private String accountId;

        private String status;

        private String statusReason;

        private Instant createdAt;

        private Instant updatedAt;

        private String lastCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCodeSecurityScanResponse model) {
            super(model);
            scanId(model.scanId);
            resource(model.resource);
            accountId(model.accountId);
            status(model.status);
            statusReason(model.statusReason);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            lastCommitId(model.lastCommitId);
        }

        public final String getScanId() {
            return scanId;
        }

        public final void setScanId(String scanId) {
            this.scanId = scanId;
        }

        @Override
        public final Builder scanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public final CodeSecurityResource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(CodeSecurityResource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(CodeSecurityResource resource) {
            this.resource = resource;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodeScanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getLastCommitId() {
            return lastCommitId;
        }

        public final void setLastCommitId(String lastCommitId) {
            this.lastCommitId = lastCommitId;
        }

        @Override
        public final Builder lastCommitId(String lastCommitId) {
            this.lastCommitId = lastCommitId;
            return this;
        }

        @Override
        public GetCodeSecurityScanResponse build() {
            return new GetCodeSecurityScanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
