/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response that contains the results of an Amazon Web Services Lambda function finding aggregation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionAggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionAggregationResponse.Builder, LambdaFunctionAggregationResponse> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(LambdaFunctionAggregationResponse::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("functionName").getter(getter(LambdaFunctionAggregationResponse::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runtime")
            .getter(getter(LambdaFunctionAggregationResponse::runtime)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()).build();

    private static final SdkField<Map<String, String>> LAMBDA_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("lambdaTags")
            .getter(getter(LambdaFunctionAggregationResponse::lambdaTags))
            .setter(setter(Builder::lambdaTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(LambdaFunctionAggregationResponse::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(LambdaFunctionAggregationResponse::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(LambdaFunctionAggregationResponse::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            FUNCTION_NAME_FIELD, RUNTIME_FIELD, LAMBDA_TAGS_FIELD, ACCOUNT_ID_FIELD, SEVERITY_COUNTS_FIELD,
            LAST_MODIFIED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String functionName;

    private final String runtime;

    private final Map<String, String> lambdaTags;

    private final String accountId;

    private final SeverityCounts severityCounts;

    private final Instant lastModifiedAt;

    private LambdaFunctionAggregationResponse(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.functionName = builder.functionName;
        this.runtime = builder.runtime;
        this.lambdaTags = builder.lambdaTags;
        this.accountId = builder.accountId;
        this.severityCounts = builder.severityCounts;
        this.lastModifiedAt = builder.lastModifiedAt;
    }

    /**
     * <p>
     * The resource IDs included in the aggregation results.
     * </p>
     * 
     * @return The resource IDs included in the aggregation results.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The Amazon Web Services Lambda function names included in the aggregation results.
     * </p>
     * 
     * @return The Amazon Web Services Lambda function names included in the aggregation results.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The runtimes included in the aggregation results.
     * </p>
     * 
     * @return The runtimes included in the aggregation results.
     */
    public final String runtime() {
        return runtime;
    }

    /**
     * For responses, this returns true if the service returned a value for the LambdaTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLambdaTags() {
        return lambdaTags != null && !(lambdaTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags included in the aggregation results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLambdaTags} method.
     * </p>
     * 
     * @return The tags included in the aggregation results.
     */
    public final Map<String, String> lambdaTags() {
        return lambdaTags;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the Amazon Web Services Lambda function.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the Amazon Web Services Lambda function.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * An object that contains the counts of aggregated finding per severity.
     * </p>
     * 
     * @return An object that contains the counts of aggregated finding per severity.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    /**
     * <p>
     * The date that the Amazon Web Services Lambda function included in the aggregation results was last changed.
     * </p>
     * 
     * @return The date that the Amazon Web Services Lambda function included in the aggregation results was last
     *         changed.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(runtime());
        hashCode = 31 * hashCode + Objects.hashCode(hasLambdaTags() ? lambdaTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAggregationResponse)) {
            return false;
        }
        LambdaFunctionAggregationResponse other = (LambdaFunctionAggregationResponse) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(functionName(), other.functionName())
                && Objects.equals(runtime(), other.runtime()) && hasLambdaTags() == other.hasLambdaTags()
                && Objects.equals(lambdaTags(), other.lambdaTags()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(severityCounts(), other.severityCounts())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaFunctionAggregationResponse").add("ResourceId", resourceId())
                .add("FunctionName", functionName()).add("Runtime", runtime())
                .add("LambdaTags", hasLambdaTags() ? lambdaTags() : null).add("AccountId", accountId())
                .add("SeverityCounts", severityCounts()).add("LastModifiedAt", lastModifiedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "functionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "runtime":
            return Optional.ofNullable(clazz.cast(runtime()));
        case "lambdaTags":
            return Optional.ofNullable(clazz.cast(lambdaTags()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("functionName", FUNCTION_NAME_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        map.put("lambdaTags", LAMBDA_TAGS_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        map.put("lastModifiedAt", LAST_MODIFIED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionAggregationResponse, T> g) {
        return obj -> g.apply((LambdaFunctionAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionAggregationResponse> {
        /**
         * <p>
         * The resource IDs included in the aggregation results.
         * </p>
         * 
         * @param resourceId
         *        The resource IDs included in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The Amazon Web Services Lambda function names included in the aggregation results.
         * </p>
         * 
         * @param functionName
         *        The Amazon Web Services Lambda function names included in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The runtimes included in the aggregation results.
         * </p>
         * 
         * @param runtime
         *        The runtimes included in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * The tags included in the aggregation results.
         * </p>
         * 
         * @param lambdaTags
         *        The tags included in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaTags(Map<String, String> lambdaTags);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the Amazon Web Services Lambda function.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account that owns the Amazon Web Services Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An object that contains the counts of aggregated finding per severity.
         * </p>
         * 
         * @param severityCounts
         *        An object that contains the counts of aggregated finding per severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * <p>
         * An object that contains the counts of aggregated finding per severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }

        /**
         * <p>
         * The date that the Amazon Web Services Lambda function included in the aggregation results was last changed.
         * </p>
         * 
         * @param lastModifiedAt
         *        The date that the Amazon Web Services Lambda function included in the aggregation results was last
         *        changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);
    }

    static final class BuilderImpl implements Builder {
        private String resourceId;

        private String functionName;

        private String runtime;

        private Map<String, String> lambdaTags = DefaultSdkAutoConstructMap.getInstance();

        private String accountId;

        private SeverityCounts severityCounts;

        private Instant lastModifiedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAggregationResponse model) {
            resourceId(model.resourceId);
            functionName(model.functionName);
            runtime(model.runtime);
            lambdaTags(model.lambdaTags);
            accountId(model.accountId);
            severityCounts(model.severityCounts);
            lastModifiedAt(model.lastModifiedAt);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getRuntime() {
            return runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        public final Map<String, String> getLambdaTags() {
            if (lambdaTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return lambdaTags;
        }

        public final void setLambdaTags(Map<String, String> lambdaTags) {
            this.lambdaTags = TagMapCopier.copy(lambdaTags);
        }

        @Override
        public final Builder lambdaTags(Map<String, String> lambdaTags) {
            this.lambdaTags = TagMapCopier.copy(lambdaTags);
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        @Override
        public LambdaFunctionAggregationResponse build() {
            return new LambdaFunctionAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
