/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCisScanResultsAggregatedByChecksRequest extends Inspector2Request implements
        ToCopyableBuilder<ListCisScanResultsAggregatedByChecksRequest.Builder, ListCisScanResultsAggregatedByChecksRequest> {
    private static final SdkField<String> SCAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanArn").getter(getter(ListCisScanResultsAggregatedByChecksRequest::scanArn))
            .setter(setter(Builder::scanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanArn").build()).build();

    private static final SdkField<CisScanResultsAggregatedByChecksFilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<CisScanResultsAggregatedByChecksFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("filterCriteria")
            .getter(getter(ListCisScanResultsAggregatedByChecksRequest::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(CisScanResultsAggregatedByChecksFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListCisScanResultsAggregatedByChecksRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListCisScanResultsAggregatedByChecksRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCisScanResultsAggregatedByChecksRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCisScanResultsAggregatedByChecksRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ARN_FIELD,
            FILTER_CRITERIA_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scanArn;

    private final CisScanResultsAggregatedByChecksFilterCriteria filterCriteria;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private ListCisScanResultsAggregatedByChecksRequest(BuilderImpl builder) {
        super(builder);
        this.scanArn = builder.scanArn;
        this.filterCriteria = builder.filterCriteria;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The scan ARN.
     * </p>
     * 
     * @return The scan ARN.
     */
    public final String scanArn() {
        return scanArn;
    }

    /**
     * <p>
     * The filter criteria.
     * </p>
     * 
     * @return The filter criteria.
     */
    public final CisScanResultsAggregatedByChecksFilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * The sort by order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link CisScanResultsAggregatedByChecksSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The sort by order.
     * @see CisScanResultsAggregatedByChecksSortBy
     */
    public final CisScanResultsAggregatedByChecksSortBy sortBy() {
        return CisScanResultsAggregatedByChecksSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The sort by order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link CisScanResultsAggregatedByChecksSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The sort by order.
     * @see CisScanResultsAggregatedByChecksSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link CisSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order.
     * @see CisSortOrder
     */
    public final CisSortOrder sortOrder() {
        return CisSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link CisSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order.
     * @see CisSortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The pagination token from a previous request that's used to retrieve the next page of results.
     * </p>
     * 
     * @return The pagination token from a previous request that's used to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of scan results aggregated by checks to be returned in a single page of results.
     * </p>
     * 
     * @return The maximum number of scan results aggregated by checks to be returned in a single page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scanArn());
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCisScanResultsAggregatedByChecksRequest)) {
            return false;
        }
        ListCisScanResultsAggregatedByChecksRequest other = (ListCisScanResultsAggregatedByChecksRequest) obj;
        return Objects.equals(scanArn(), other.scanArn()) && Objects.equals(filterCriteria(), other.filterCriteria())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCisScanResultsAggregatedByChecksRequest").add("ScanArn", scanArn())
                .add("FilterCriteria", filterCriteria()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanArn":
            return Optional.ofNullable(clazz.cast(scanArn()));
        case "filterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanArn", SCAN_ARN_FIELD);
        map.put("filterCriteria", FILTER_CRITERIA_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCisScanResultsAggregatedByChecksRequest, T> g) {
        return obj -> g.apply((ListCisScanResultsAggregatedByChecksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCisScanResultsAggregatedByChecksRequest> {
        /**
         * <p>
         * The scan ARN.
         * </p>
         * 
         * @param scanArn
         *        The scan ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanArn(String scanArn);

        /**
         * <p>
         * The filter criteria.
         * </p>
         * 
         * @param filterCriteria
         *        The filter criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(CisScanResultsAggregatedByChecksFilterCriteria filterCriteria);

        /**
         * <p>
         * The filter criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CisScanResultsAggregatedByChecksFilterCriteria.Builder} avoiding the need to create one manually via
         * {@link CisScanResultsAggregatedByChecksFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CisScanResultsAggregatedByChecksFilterCriteria.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #filterCriteria(CisScanResultsAggregatedByChecksFilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link CisScanResultsAggregatedByChecksFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(CisScanResultsAggregatedByChecksFilterCriteria)
         */
        default Builder filterCriteria(Consumer<CisScanResultsAggregatedByChecksFilterCriteria.Builder> filterCriteria) {
            return filterCriteria(CisScanResultsAggregatedByChecksFilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * The sort by order.
         * </p>
         * 
         * @param sortBy
         *        The sort by order.
         * @see CisScanResultsAggregatedByChecksSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisScanResultsAggregatedByChecksSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The sort by order.
         * </p>
         * 
         * @param sortBy
         *        The sort by order.
         * @see CisScanResultsAggregatedByChecksSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisScanResultsAggregatedByChecksSortBy
         */
        Builder sortBy(CisScanResultsAggregatedByChecksSortBy sortBy);

        /**
         * <p>
         * The sort order.
         * </p>
         * 
         * @param sortOrder
         *        The sort order.
         * @see CisSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order.
         * </p>
         * 
         * @param sortOrder
         *        The sort order.
         * @see CisSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSortOrder
         */
        Builder sortOrder(CisSortOrder sortOrder);

        /**
         * <p>
         * The pagination token from a previous request that's used to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from a previous request that's used to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of scan results aggregated by checks to be returned in a single page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of scan results aggregated by checks to be returned in a single page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String scanArn;

        private CisScanResultsAggregatedByChecksFilterCriteria filterCriteria;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCisScanResultsAggregatedByChecksRequest model) {
            super(model);
            scanArn(model.scanArn);
            filterCriteria(model.filterCriteria);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getScanArn() {
            return scanArn;
        }

        public final void setScanArn(String scanArn) {
            this.scanArn = scanArn;
        }

        @Override
        public final Builder scanArn(String scanArn) {
            this.scanArn = scanArn;
            return this;
        }

        public final CisScanResultsAggregatedByChecksFilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(CisScanResultsAggregatedByChecksFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(CisScanResultsAggregatedByChecksFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(CisScanResultsAggregatedByChecksSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(CisSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCisScanResultsAggregatedByChecksRequest build() {
            return new ListCisScanResultsAggregatedByChecksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
