/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCisScansResponse extends Inspector2Response implements
        ToCopyableBuilder<ListCisScansResponse.Builder, ListCisScansResponse> {
    private static final SdkField<List<CisScan>> SCANS_FIELD = SdkField
            .<List<CisScan>> builder(MarshallingType.LIST)
            .memberName("scans")
            .getter(getter(ListCisScansResponse::scans))
            .setter(setter(Builder::scans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CisScan> builder(MarshallingType.SDK_POJO)
                                            .constructor(CisScan::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCisScansResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SCANS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CisScan> scans;

    private final String nextToken;

    private ListCisScansResponse(BuilderImpl builder) {
        super(builder);
        this.scans = builder.scans;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scans property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasScans() {
        return scans != null && !(scans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CIS scans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScans} method.
     * </p>
     * 
     * @return The CIS scans.
     */
    public final List<CisScan> scans() {
        return scans;
    }

    /**
     * <p>
     * The pagination token from a previous request that's used to retrieve the next page of results.
     * </p>
     * 
     * @return The pagination token from a previous request that's used to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScans() ? scans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCisScansResponse)) {
            return false;
        }
        ListCisScansResponse other = (ListCisScansResponse) obj;
        return hasScans() == other.hasScans() && Objects.equals(scans(), other.scans())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCisScansResponse").add("Scans", hasScans() ? scans() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scans":
            return Optional.ofNullable(clazz.cast(scans()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scans", SCANS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCisScansResponse, T> g) {
        return obj -> g.apply((ListCisScansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListCisScansResponse> {
        /**
         * <p>
         * The CIS scans.
         * </p>
         * 
         * @param scans
         *        The CIS scans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scans(Collection<CisScan> scans);

        /**
         * <p>
         * The CIS scans.
         * </p>
         * 
         * @param scans
         *        The CIS scans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scans(CisScan... scans);

        /**
         * <p>
         * The CIS scans.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CisScan.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.CisScan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CisScan.Builder#build()} is called immediately and
         * its result is passed to {@link #scans(List<CisScan>)}.
         * 
         * @param scans
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CisScan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scans(java.util.Collection<CisScan>)
         */
        Builder scans(Consumer<CisScan.Builder>... scans);

        /**
         * <p>
         * The pagination token from a previous request that's used to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from a previous request that's used to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private List<CisScan> scans = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCisScansResponse model) {
            super(model);
            scans(model.scans);
            nextToken(model.nextToken);
        }

        public final List<CisScan.Builder> getScans() {
            List<CisScan.Builder> result = CisScanListCopier.copyToBuilder(this.scans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScans(Collection<CisScan.BuilderImpl> scans) {
            this.scans = CisScanListCopier.copyFromBuilder(scans);
        }

        @Override
        public final Builder scans(Collection<CisScan> scans) {
            this.scans = CisScanListCopier.copy(scans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scans(CisScan... scans) {
            scans(Arrays.asList(scans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scans(Consumer<CisScan.Builder>... scans) {
            scans(Stream.of(scans).map(c -> CisScan.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCisScansResponse build() {
            return new ListCisScansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
