/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCodeSecurityIntegrationsResponse extends Inspector2Response implements
        ToCopyableBuilder<ListCodeSecurityIntegrationsResponse.Builder, ListCodeSecurityIntegrationsResponse> {
    private static final SdkField<List<CodeSecurityIntegrationSummary>> INTEGRATIONS_FIELD = SdkField
            .<List<CodeSecurityIntegrationSummary>> builder(MarshallingType.LIST)
            .memberName("integrations")
            .getter(getter(ListCodeSecurityIntegrationsResponse::integrations))
            .setter(setter(Builder::integrations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeSecurityIntegrationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeSecurityIntegrationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCodeSecurityIntegrationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CodeSecurityIntegrationSummary> integrations;

    private final String nextToken;

    private ListCodeSecurityIntegrationsResponse(BuilderImpl builder) {
        super(builder);
        this.integrations = builder.integrations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Integrations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIntegrations() {
        return integrations != null && !(integrations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of code security integration summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIntegrations} method.
     * </p>
     * 
     * @return A list of code security integration summaries.
     */
    public final List<CodeSecurityIntegrationSummary> integrations() {
        return integrations;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request. For subsequent calls, use the NextToken value returned from the previous request to
     * continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request. For subsequent calls, use the NextToken value returned from the previous
     *         request to continue listing results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIntegrations() ? integrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeSecurityIntegrationsResponse)) {
            return false;
        }
        ListCodeSecurityIntegrationsResponse other = (ListCodeSecurityIntegrationsResponse) obj;
        return hasIntegrations() == other.hasIntegrations() && Objects.equals(integrations(), other.integrations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCodeSecurityIntegrationsResponse")
                .add("Integrations", hasIntegrations() ? integrations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integrations":
            return Optional.ofNullable(clazz.cast(integrations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("integrations", INTEGRATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCodeSecurityIntegrationsResponse, T> g) {
        return obj -> g.apply((ListCodeSecurityIntegrationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCodeSecurityIntegrationsResponse> {
        /**
         * <p>
         * A list of code security integration summaries.
         * </p>
         * 
         * @param integrations
         *        A list of code security integration summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrations(Collection<CodeSecurityIntegrationSummary> integrations);

        /**
         * <p>
         * A list of code security integration summaries.
         * </p>
         * 
         * @param integrations
         *        A list of code security integration summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrations(CodeSecurityIntegrationSummary... integrations);

        /**
         * <p>
         * A list of code security integration summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.CodeSecurityIntegrationSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.CodeSecurityIntegrationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.CodeSecurityIntegrationSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #integrations(List<CodeSecurityIntegrationSummary>)}.
         * 
         * @param integrations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.CodeSecurityIntegrationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integrations(java.util.Collection<CodeSecurityIntegrationSummary>)
         */
        Builder integrations(Consumer<CodeSecurityIntegrationSummary.Builder>... integrations);

        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request. For subsequent calls, use the NextToken value returned from the previous request
         * to continue listing results after the first page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request. For subsequent calls, use the NextToken value returned from
         *        the previous request to continue listing results after the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Inspector2Response.BuilderImpl implements Builder {
        private List<CodeSecurityIntegrationSummary> integrations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeSecurityIntegrationsResponse model) {
            super(model);
            integrations(model.integrations);
            nextToken(model.nextToken);
        }

        public final List<CodeSecurityIntegrationSummary.Builder> getIntegrations() {
            List<CodeSecurityIntegrationSummary.Builder> result = IntegrationSummariesCopier.copyToBuilder(this.integrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegrations(Collection<CodeSecurityIntegrationSummary.BuilderImpl> integrations) {
            this.integrations = IntegrationSummariesCopier.copyFromBuilder(integrations);
        }

        @Override
        public final Builder integrations(Collection<CodeSecurityIntegrationSummary> integrations) {
            this.integrations = IntegrationSummariesCopier.copy(integrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(CodeSecurityIntegrationSummary... integrations) {
            integrations(Arrays.asList(integrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Consumer<CodeSecurityIntegrationSummary.Builder>... integrations) {
            integrations(Stream.of(integrations).map(c -> CodeSecurityIntegrationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCodeSecurityIntegrationsResponse build() {
            return new ListCodeSecurityIntegrationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
