/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingAggregationsRequest extends Inspector2Request implements
        ToCopyableBuilder<ListFindingAggregationsRequest.Builder, ListFindingAggregationsRequest> {
    private static final SdkField<String> AGGREGATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aggregationType").getter(getter(ListFindingAggregationsRequest::aggregationTypeAsString))
            .setter(setter(Builder::aggregationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFindingAggregationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListFindingAggregationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<StringFilter>> ACCOUNT_IDS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("accountIds")
            .getter(getter(ListFindingAggregationsRequest::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AggregationRequest> AGGREGATION_REQUEST_FIELD = SdkField
            .<AggregationRequest> builder(MarshallingType.SDK_POJO).memberName("aggregationRequest")
            .getter(getter(ListFindingAggregationsRequest::aggregationRequest)).setter(setter(Builder::aggregationRequest))
            .constructor(AggregationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationRequest").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_TYPE_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ACCOUNT_IDS_FIELD, AGGREGATION_REQUEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String aggregationType;

    private final String nextToken;

    private final Integer maxResults;

    private final List<StringFilter> accountIds;

    private final AggregationRequest aggregationRequest;

    private ListFindingAggregationsRequest(BuilderImpl builder) {
        super(builder);
        this.aggregationType = builder.aggregationType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.accountIds = builder.accountIds;
        this.aggregationRequest = builder.aggregationRequest;
    }

    /**
     * <p>
     * The type of the aggregation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationType}
     * will return {@link AggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationTypeAsString}.
     * </p>
     * 
     * @return The type of the aggregation request.
     * @see AggregationType
     */
    public final AggregationType aggregationType() {
        return AggregationType.fromValue(aggregationType);
    }

    /**
     * <p>
     * The type of the aggregation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationType}
     * will return {@link AggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationTypeAsString}.
     * </p>
     * 
     * @return The type of the aggregation request.
     * @see AggregationType
     */
    public final String aggregationTypeAsString() {
        return aggregationType;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. If your response returns more than the <code>maxResults</code> maximum
     * value it will also return a <code>nextToken</code> value. For subsequent calls, use the <code>nextToken</code>
     * value returned from the previous request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request to a list action. If your response returns more than the
     *         <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For subsequent
     *         calls, use the <code>nextToken</code> value returned from the previous request to continue listing
     *         results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results the response can return. If your request would return more than the maximum the
     * response will return a <code>nextToken</code> value, use this value when you call the action again to get the
     * remaining results.
     * </p>
     * 
     * @return The maximum number of results the response can return. If your request would return more than the maximum
     *         the response will return a <code>nextToken</code> value, use this value when you call the action again to
     *         get the remaining results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services account IDs to retrieve finding aggregation data for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return The Amazon Web Services account IDs to retrieve finding aggregation data for.
     */
    public final List<StringFilter> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * Details of the aggregation request that is used to filter your aggregation results.
     * </p>
     * 
     * @return Details of the aggregation request that is used to filter your aggregation results.
     */
    public final AggregationRequest aggregationRequest() {
        return aggregationRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aggregationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(aggregationRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingAggregationsRequest)) {
            return false;
        }
        ListFindingAggregationsRequest other = (ListFindingAggregationsRequest) obj;
        return Objects.equals(aggregationTypeAsString(), other.aggregationTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && Objects.equals(aggregationRequest(), other.aggregationRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFindingAggregationsRequest").add("AggregationType", aggregationTypeAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("AccountIds", hasAccountIds() ? accountIds() : null).add("AggregationRequest", aggregationRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aggregationType":
            return Optional.ofNullable(clazz.cast(aggregationTypeAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "accountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "aggregationRequest":
            return Optional.ofNullable(clazz.cast(aggregationRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aggregationType", AGGREGATION_TYPE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("accountIds", ACCOUNT_IDS_FIELD);
        map.put("aggregationRequest", AGGREGATION_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFindingAggregationsRequest, T> g) {
        return obj -> g.apply((ListFindingAggregationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListFindingAggregationsRequest> {
        /**
         * <p>
         * The type of the aggregation request.
         * </p>
         * 
         * @param aggregationType
         *        The type of the aggregation request.
         * @see AggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationType
         */
        Builder aggregationType(String aggregationType);

        /**
         * <p>
         * The type of the aggregation request.
         * </p>
         * 
         * @param aggregationType
         *        The type of the aggregation request.
         * @see AggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationType
         */
        Builder aggregationType(AggregationType aggregationType);

        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request to a list action. If your response returns more than the <code>maxResults</code>
         * maximum value it will also return a <code>nextToken</code> value. For subsequent calls, use the
         * <code>nextToken</code> value returned from the previous request to continue listing results after the first
         * page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request to a list action. If your response returns more than the
         *        <code>maxResults</code> maximum value it will also return a <code>nextToken</code> value. For
         *        subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue
         *        listing results after the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results the response can return. If your request would return more than the maximum the
         * response will return a <code>nextToken</code> value, use this value when you call the action again to get the
         * remaining results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results the response can return. If your request would return more than the
         *        maximum the response will return a <code>nextToken</code> value, use this value when you call the
         *        action again to get the remaining results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The Amazon Web Services account IDs to retrieve finding aggregation data for.
         * </p>
         * 
         * @param accountIds
         *        The Amazon Web Services account IDs to retrieve finding aggregation data for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<StringFilter> accountIds);

        /**
         * <p>
         * The Amazon Web Services account IDs to retrieve finding aggregation data for.
         * </p>
         * 
         * @param accountIds
         *        The Amazon Web Services account IDs to retrieve finding aggregation data for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(StringFilter... accountIds);

        /**
         * <p>
         * The Amazon Web Services account IDs to retrieve finding aggregation data for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #accountIds(List<StringFilter>)}.
         * 
         * @param accountIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountIds(java.util.Collection<StringFilter>)
         */
        Builder accountIds(Consumer<StringFilter.Builder>... accountIds);

        /**
         * <p>
         * Details of the aggregation request that is used to filter your aggregation results.
         * </p>
         * 
         * @param aggregationRequest
         *        Details of the aggregation request that is used to filter your aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationRequest(AggregationRequest aggregationRequest);

        /**
         * <p>
         * Details of the aggregation request that is used to filter your aggregation results.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregationRequest.Builder} avoiding the
         * need to create one manually via {@link AggregationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregationRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregationRequest(AggregationRequest)}.
         * 
         * @param aggregationRequest
         *        a consumer that will call methods on {@link AggregationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationRequest(AggregationRequest)
         */
        default Builder aggregationRequest(Consumer<AggregationRequest.Builder> aggregationRequest) {
            return aggregationRequest(AggregationRequest.builder().applyMutation(aggregationRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private String aggregationType;

        private String nextToken;

        private Integer maxResults;

        private List<StringFilter> accountIds = DefaultSdkAutoConstructList.getInstance();

        private AggregationRequest aggregationRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingAggregationsRequest model) {
            super(model);
            aggregationType(model.aggregationType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            accountIds(model.accountIds);
            aggregationRequest(model.aggregationRequest);
        }

        public final String getAggregationType() {
            return aggregationType;
        }

        public final void setAggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
        }

        @Override
        public final Builder aggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        @Override
        public final Builder aggregationType(AggregationType aggregationType) {
            this.aggregationType(aggregationType == null ? null : aggregationType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<StringFilter.Builder> getAccountIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.accountIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountIds(Collection<StringFilter.BuilderImpl> accountIds) {
            this.accountIds = StringFilterListCopier.copyFromBuilder(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<StringFilter> accountIds) {
            this.accountIds = StringFilterListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(StringFilter... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(Consumer<StringFilter.Builder>... accountIds) {
            accountIds(Stream.of(accountIds).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AggregationRequest.Builder getAggregationRequest() {
            return aggregationRequest != null ? aggregationRequest.toBuilder() : null;
        }

        public final void setAggregationRequest(AggregationRequest.BuilderImpl aggregationRequest) {
            this.aggregationRequest = aggregationRequest != null ? aggregationRequest.build() : null;
        }

        @Override
        public final Builder aggregationRequest(AggregationRequest aggregationRequest) {
            this.aggregationRequest = aggregationRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFindingAggregationsRequest build() {
            return new ListFindingAggregationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
