/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes the details of a number filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumberFilter implements SdkPojo, Serializable, ToCopyableBuilder<NumberFilter.Builder, NumberFilter> {
    private static final SdkField<Double> UPPER_INCLUSIVE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("upperInclusive").getter(getter(NumberFilter::upperInclusive)).setter(setter(Builder::upperInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upperInclusive").build()).build();

    private static final SdkField<Double> LOWER_INCLUSIVE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("lowerInclusive").getter(getter(NumberFilter::lowerInclusive)).setter(setter(Builder::lowerInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lowerInclusive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPPER_INCLUSIVE_FIELD,
            LOWER_INCLUSIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double upperInclusive;

    private final Double lowerInclusive;

    private NumberFilter(BuilderImpl builder) {
        this.upperInclusive = builder.upperInclusive;
        this.lowerInclusive = builder.lowerInclusive;
    }

    /**
     * <p>
     * The highest number to be included in the filter.
     * </p>
     * 
     * @return The highest number to be included in the filter.
     */
    public final Double upperInclusive() {
        return upperInclusive;
    }

    /**
     * <p>
     * The lowest number to be included in the filter.
     * </p>
     * 
     * @return The lowest number to be included in the filter.
     */
    public final Double lowerInclusive() {
        return lowerInclusive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(upperInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(lowerInclusive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberFilter)) {
            return false;
        }
        NumberFilter other = (NumberFilter) obj;
        return Objects.equals(upperInclusive(), other.upperInclusive())
                && Objects.equals(lowerInclusive(), other.lowerInclusive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumberFilter").add("UpperInclusive", upperInclusive()).add("LowerInclusive", lowerInclusive())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "upperInclusive":
            return Optional.ofNullable(clazz.cast(upperInclusive()));
        case "lowerInclusive":
            return Optional.ofNullable(clazz.cast(lowerInclusive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("upperInclusive", UPPER_INCLUSIVE_FIELD);
        map.put("lowerInclusive", LOWER_INCLUSIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NumberFilter, T> g) {
        return obj -> g.apply((NumberFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumberFilter> {
        /**
         * <p>
         * The highest number to be included in the filter.
         * </p>
         * 
         * @param upperInclusive
         *        The highest number to be included in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upperInclusive(Double upperInclusive);

        /**
         * <p>
         * The lowest number to be included in the filter.
         * </p>
         * 
         * @param lowerInclusive
         *        The lowest number to be included in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lowerInclusive(Double lowerInclusive);
    }

    static final class BuilderImpl implements Builder {
        private Double upperInclusive;

        private Double lowerInclusive;

        private BuilderImpl() {
        }

        private BuilderImpl(NumberFilter model) {
            upperInclusive(model.upperInclusive);
            lowerInclusive(model.lowerInclusive);
        }

        public final Double getUpperInclusive() {
            return upperInclusive;
        }

        public final void setUpperInclusive(Double upperInclusive) {
            this.upperInclusive = upperInclusive;
        }

        @Override
        public final Builder upperInclusive(Double upperInclusive) {
            this.upperInclusive = upperInclusive;
            return this;
        }

        public final Double getLowerInclusive() {
            return lowerInclusive;
        }

        public final void setLowerInclusive(Double lowerInclusive) {
            this.lowerInclusive = lowerInclusive;
        }

        @Override
        public final Builder lowerInclusive(Double lowerInclusive) {
            this.lowerInclusive = lowerInclusive;
            return this;
        }

        @Override
        public NumberFilter build() {
            return new NumberFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
