/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the port range associated with a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortRange implements SdkPojo, Serializable, ToCopyableBuilder<PortRange.Builder, PortRange> {
    private static final SdkField<Integer> BEGIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("begin")
            .getter(getter(PortRange::begin)).setter(setter(Builder::begin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("begin").build()).build();

    private static final SdkField<Integer> END_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("end")
            .getter(getter(PortRange::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_FIELD, END_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer begin;

    private final Integer end;

    private PortRange(BuilderImpl builder) {
        this.begin = builder.begin;
        this.end = builder.end;
    }

    /**
     * <p>
     * The beginning port in a port range.
     * </p>
     * 
     * @return The beginning port in a port range.
     */
    public final Integer begin() {
        return begin;
    }

    /**
     * <p>
     * The ending port in a port range.
     * </p>
     * 
     * @return The ending port in a port range.
     */
    public final Integer end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(begin());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortRange)) {
            return false;
        }
        PortRange other = (PortRange) obj;
        return Objects.equals(begin(), other.begin()) && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortRange").add("Begin", begin()).add("End", end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "begin":
            return Optional.ofNullable(clazz.cast(begin()));
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("begin", BEGIN_FIELD);
        map.put("end", END_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PortRange, T> g) {
        return obj -> g.apply((PortRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortRange> {
        /**
         * <p>
         * The beginning port in a port range.
         * </p>
         * 
         * @param begin
         *        The beginning port in a port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder begin(Integer begin);

        /**
         * <p>
         * The ending port in a port range.
         * </p>
         * 
         * @param end
         *        The ending port in a port range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Integer end);
    }

    static final class BuilderImpl implements Builder {
        private Integer begin;

        private Integer end;

        private BuilderImpl() {
        }

        private BuilderImpl(PortRange model) {
            begin(model.begin);
            end(model.end);
        }

        public final Integer getBegin() {
            return begin;
        }

        public final void setBegin(Integer begin) {
            this.begin = begin;
        }

        @Override
        public final Builder begin(Integer begin) {
            this.begin = begin;
            return this;
        }

        public final Integer getEnd() {
            return end;
        }

        public final void setEnd(Integer end) {
            this.end = end;
        }

        @Override
        public final Builder end(Integer end) {
            this.end = end;
            return this;
        }

        @Override
        public PortRange build() {
            return new PortRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
