/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ScanStatusReason {
    PENDING_INITIAL_SCAN("PENDING_INITIAL_SCAN"),

    ACCESS_DENIED("ACCESS_DENIED"),

    INTERNAL_ERROR("INTERNAL_ERROR"),

    UNMANAGED_EC2_INSTANCE("UNMANAGED_EC2_INSTANCE"),

    UNSUPPORTED_OS("UNSUPPORTED_OS"),

    SCAN_ELIGIBILITY_EXPIRED("SCAN_ELIGIBILITY_EXPIRED"),

    RESOURCE_TERMINATED("RESOURCE_TERMINATED"),

    SUCCESSFUL("SUCCESSFUL"),

    NO_RESOURCES_FOUND("NO_RESOURCES_FOUND"),

    IMAGE_SIZE_EXCEEDED("IMAGE_SIZE_EXCEEDED"),

    SCAN_FREQUENCY_MANUAL("SCAN_FREQUENCY_MANUAL"),

    SCAN_FREQUENCY_SCAN_ON_PUSH("SCAN_FREQUENCY_SCAN_ON_PUSH"),

    EC2_INSTANCE_STOPPED("EC2_INSTANCE_STOPPED"),

    PENDING_DISABLE("PENDING_DISABLE"),

    NO_INVENTORY("NO_INVENTORY"),

    STALE_INVENTORY("STALE_INVENTORY"),

    EXCLUDED_BY_TAG("EXCLUDED_BY_TAG"),

    UNSUPPORTED_RUNTIME("UNSUPPORTED_RUNTIME"),

    UNSUPPORTED_MEDIA_TYPE("UNSUPPORTED_MEDIA_TYPE"),

    UNSUPPORTED_CONFIG_FILE("UNSUPPORTED_CONFIG_FILE"),

    DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED("DEEP_INSPECTION_PACKAGE_COLLECTION_LIMIT_EXCEEDED"),

    DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED("DEEP_INSPECTION_DAILY_SSM_INVENTORY_LIMIT_EXCEEDED"),

    DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED("DEEP_INSPECTION_COLLECTION_TIME_LIMIT_EXCEEDED"),

    DEEP_INSPECTION_NO_INVENTORY("DEEP_INSPECTION_NO_INVENTORY"),

    AGENTLESS_INSTANCE_STORAGE_LIMIT_EXCEEDED("AGENTLESS_INSTANCE_STORAGE_LIMIT_EXCEEDED"),

    AGENTLESS_INSTANCE_COLLECTION_TIME_LIMIT_EXCEEDED("AGENTLESS_INSTANCE_COLLECTION_TIME_LIMIT_EXCEEDED"),

    PENDING_REVIVAL_SCAN("PENDING_REVIVAL_SCAN"),

    INTEGRATION_CONNECTION_LOST("INTEGRATION_CONNECTION_LOST"),

    ACCESS_DENIED_TO_ENCRYPTION_KEY("ACCESS_DENIED_TO_ENCRYPTION_KEY"),

    UNSUPPORTED_LANGUAGE("UNSUPPORTED_LANGUAGE"),

    NO_SCAN_CONFIGURATION_ASSOCIATED("NO_SCAN_CONFIGURATION_ASSOCIATED"),

    SCAN_IN_PROGRESS("SCAN_IN_PROGRESS"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanStatusReason> VALUE_MAP = EnumUtils.uniqueIndex(ScanStatusReason.class,
            ScanStatusReason::toString);

    private final String value;

    private ScanStatusReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ScanStatusReason corresponding to the value
     */
    public static ScanStatusReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ScanStatusReason}s
     */
    public static Set<ScanStatusReason> knownValues() {
        Set<ScanStatusReason> knownValues = EnumSet.allOf(ScanStatusReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
