/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response that contains details on the results of a finding aggregation by title.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TitleAggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<TitleAggregationResponse.Builder, TitleAggregationResponse> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(TitleAggregationResponse::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> VULNERABILITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vulnerabilityId").getter(getter(TitleAggregationResponse::vulnerabilityId))
            .setter(setter(Builder::vulnerabilityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilityId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(TitleAggregationResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(TitleAggregationResponse::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD,
            VULNERABILITY_ID_FIELD, ACCOUNT_ID_FIELD, SEVERITY_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String vulnerabilityId;

    private final String accountId;

    private final SeverityCounts severityCounts;

    private TitleAggregationResponse(BuilderImpl builder) {
        this.title = builder.title;
        this.vulnerabilityId = builder.vulnerabilityId;
        this.accountId = builder.accountId;
        this.severityCounts = builder.severityCounts;
    }

    /**
     * <p>
     * The title that the findings were aggregated on.
     * </p>
     * 
     * @return The title that the findings were aggregated on.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The vulnerability ID of the finding.
     * </p>
     * 
     * @return The vulnerability ID of the finding.
     */
    public final String vulnerabilityId() {
        return vulnerabilityId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account associated with the findings.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account associated with the findings.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * An object that represent the count of matched findings per severity.
     * </p>
     * 
     * @return An object that represent the count of matched findings per severity.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(vulnerabilityId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TitleAggregationResponse)) {
            return false;
        }
        TitleAggregationResponse other = (TitleAggregationResponse) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(vulnerabilityId(), other.vulnerabilityId())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(severityCounts(), other.severityCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TitleAggregationResponse").add("Title", title()).add("VulnerabilityId", vulnerabilityId())
                .add("AccountId", accountId()).add("SeverityCounts", severityCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "vulnerabilityId":
            return Optional.ofNullable(clazz.cast(vulnerabilityId()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("title", TITLE_FIELD);
        map.put("vulnerabilityId", VULNERABILITY_ID_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TitleAggregationResponse, T> g) {
        return obj -> g.apply((TitleAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TitleAggregationResponse> {
        /**
         * <p>
         * The title that the findings were aggregated on.
         * </p>
         * 
         * @param title
         *        The title that the findings were aggregated on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The vulnerability ID of the finding.
         * </p>
         * 
         * @param vulnerabilityId
         *        The vulnerability ID of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerabilityId(String vulnerabilityId);

        /**
         * <p>
         * The ID of the Amazon Web Services account associated with the findings.
         * </p>
         * 
         * @param accountId
         *        The ID of the Amazon Web Services account associated with the findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An object that represent the count of matched findings per severity.
         * </p>
         * 
         * @param severityCounts
         *        An object that represent the count of matched findings per severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * <p>
         * An object that represent the count of matched findings per severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String vulnerabilityId;

        private String accountId;

        private SeverityCounts severityCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(TitleAggregationResponse model) {
            title(model.title);
            vulnerabilityId(model.vulnerabilityId);
            accountId(model.accountId);
            severityCounts(model.severityCounts);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getVulnerabilityId() {
            return vulnerabilityId;
        }

        public final void setVulnerabilityId(String vulnerabilityId) {
            this.vulnerabilityId = vulnerabilityId;
        }

        @Override
        public final Builder vulnerabilityId(String vulnerabilityId) {
            this.vulnerabilityId = vulnerabilityId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        @Override
        public TitleAggregationResponse build() {
            return new TitleAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
