/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details required to update an integration with GitHub.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGitHubIntegrationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateGitHubIntegrationDetail.Builder, UpdateGitHubIntegrationDetail> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(UpdateGitHubIntegrationDetail::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> INSTALLATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("installationId").getter(getter(UpdateGitHubIntegrationDetail::installationId))
            .setter(setter(Builder::installationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("installationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD,
            INSTALLATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String installationId;

    private UpdateGitHubIntegrationDetail(BuilderImpl builder) {
        this.code = builder.code;
        this.installationId = builder.installationId;
    }

    /**
     * <p>
     * The authorization code received from GitHub to update the integration.
     * </p>
     * 
     * @return The authorization code received from GitHub to update the integration.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The installation ID of the GitHub App associated with the integration.
     * </p>
     * 
     * @return The installation ID of the GitHub App associated with the integration.
     */
    public final String installationId() {
        return installationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(installationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGitHubIntegrationDetail)) {
            return false;
        }
        UpdateGitHubIntegrationDetail other = (UpdateGitHubIntegrationDetail) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(installationId(), other.installationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGitHubIntegrationDetail")
                .add("Code", code() == null ? null : "*** Sensitive Data Redacted ***").add("InstallationId", installationId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "installationId":
            return Optional.ofNullable(clazz.cast(installationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("code", CODE_FIELD);
        map.put("installationId", INSTALLATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGitHubIntegrationDetail, T> g) {
        return obj -> g.apply((UpdateGitHubIntegrationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateGitHubIntegrationDetail> {
        /**
         * <p>
         * The authorization code received from GitHub to update the integration.
         * </p>
         * 
         * @param code
         *        The authorization code received from GitHub to update the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The installation ID of the GitHub App associated with the integration.
         * </p>
         * 
         * @param installationId
         *        The installation ID of the GitHub App associated with the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installationId(String installationId);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String installationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGitHubIntegrationDetail model) {
            code(model.code);
            installationId(model.installationId);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getInstallationId() {
            return installationId;
        }

        public final void setInstallationId(String installationId) {
            this.installationId = installationId;
        }

        @Override
        public final Builder installationId(String installationId) {
            this.installationId = installationId;
            return this;
        }

        @Override
        public UpdateGitHubIntegrationDetail build() {
            return new UpdateGitHubIntegrationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
