/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details required to update an integration with a self-managed GitLab instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGitLabSelfManagedIntegrationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateGitLabSelfManagedIntegrationDetail.Builder, UpdateGitLabSelfManagedIntegrationDetail> {
    private static final SdkField<String> AUTH_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authCode").getter(getter(UpdateGitLabSelfManagedIntegrationDetail::authCode))
            .setter(setter(Builder::authCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authCode;

    private UpdateGitLabSelfManagedIntegrationDetail(BuilderImpl builder) {
        this.authCode = builder.authCode;
    }

    /**
     * <p>
     * The authorization code received from the self-managed GitLab instance to update the integration.
     * </p>
     * 
     * @return The authorization code received from the self-managed GitLab instance to update the integration.
     */
    public final String authCode() {
        return authCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGitLabSelfManagedIntegrationDetail)) {
            return false;
        }
        UpdateGitLabSelfManagedIntegrationDetail other = (UpdateGitLabSelfManagedIntegrationDetail) obj;
        return Objects.equals(authCode(), other.authCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGitLabSelfManagedIntegrationDetail")
                .add("AuthCode", authCode() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authCode":
            return Optional.ofNullable(clazz.cast(authCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authCode", AUTH_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGitLabSelfManagedIntegrationDetail, T> g) {
        return obj -> g.apply((UpdateGitLabSelfManagedIntegrationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateGitLabSelfManagedIntegrationDetail> {
        /**
         * <p>
         * The authorization code received from the self-managed GitLab instance to update the integration.
         * </p>
         * 
         * @param authCode
         *        The authorization code received from the self-managed GitLab instance to update the integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authCode(String authCode);
    }

    static final class BuilderImpl implements Builder {
        private String authCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGitLabSelfManagedIntegrationDetail model) {
            authCode(model.authCode);
        }

        public final String getAuthCode() {
            return authCode;
        }

        public final void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        @Override
        public final Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        @Override
        public UpdateGitLabSelfManagedIntegrationDetail build() {
            return new UpdateGitLabSelfManagedIntegrationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
