/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details required to update a code security integration with a specific repository provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIntegrationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateIntegrationDetails.Builder, UpdateIntegrationDetails> {
    private static final SdkField<UpdateGitLabSelfManagedIntegrationDetail> GITLAB_SELF_MANAGED_FIELD = SdkField
            .<UpdateGitLabSelfManagedIntegrationDetail> builder(MarshallingType.SDK_POJO).memberName("gitlabSelfManaged")
            .getter(getter(UpdateIntegrationDetails::gitlabSelfManaged)).setter(setter(Builder::gitlabSelfManaged))
            .constructor(UpdateGitLabSelfManagedIntegrationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitlabSelfManaged").build()).build();

    private static final SdkField<UpdateGitHubIntegrationDetail> GITHUB_FIELD = SdkField
            .<UpdateGitHubIntegrationDetail> builder(MarshallingType.SDK_POJO).memberName("github")
            .getter(getter(UpdateIntegrationDetails::github)).setter(setter(Builder::github))
            .constructor(UpdateGitHubIntegrationDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("github").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GITLAB_SELF_MANAGED_FIELD,
            GITHUB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UpdateGitLabSelfManagedIntegrationDetail gitlabSelfManaged;

    private final UpdateGitHubIntegrationDetail github;

    private final Type type;

    private UpdateIntegrationDetails(BuilderImpl builder) {
        this.gitlabSelfManaged = builder.gitlabSelfManaged;
        this.github = builder.github;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details specific to updating an integration with a self-managed GitLab instance.
     * </p>
     * 
     * @return Details specific to updating an integration with a self-managed GitLab instance.
     */
    public final UpdateGitLabSelfManagedIntegrationDetail gitlabSelfManaged() {
        return gitlabSelfManaged;
    }

    /**
     * <p>
     * Details specific to updating an integration with GitHub.
     * </p>
     * 
     * @return Details specific to updating an integration with GitHub.
     */
    public final UpdateGitHubIntegrationDetail github() {
        return github;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gitlabSelfManaged());
        hashCode = 31 * hashCode + Objects.hashCode(github());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntegrationDetails)) {
            return false;
        }
        UpdateIntegrationDetails other = (UpdateIntegrationDetails) obj;
        return Objects.equals(gitlabSelfManaged(), other.gitlabSelfManaged()) && Objects.equals(github(), other.github());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIntegrationDetails").add("GitlabSelfManaged", gitlabSelfManaged()).add("Github", github())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gitlabSelfManaged":
            return Optional.ofNullable(clazz.cast(gitlabSelfManaged()));
        case "github":
            return Optional.ofNullable(clazz.cast(github()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #gitlabSelfManaged()} initialized to the given value.
     *
     * <p>
     * Details specific to updating an integration with a self-managed GitLab instance.
     * </p>
     * 
     * @param gitlabSelfManaged
     *        Details specific to updating an integration with a self-managed GitLab instance.
     */
    public static UpdateIntegrationDetails fromGitlabSelfManaged(UpdateGitLabSelfManagedIntegrationDetail gitlabSelfManaged) {
        return builder().gitlabSelfManaged(gitlabSelfManaged).build();
    }

    /**
     * Create an instance of this class with {@link #gitlabSelfManaged()} initialized to the given value.
     *
     * <p>
     * Details specific to updating an integration with a self-managed GitLab instance.
     * </p>
     * 
     * @param gitlabSelfManaged
     *        Details specific to updating an integration with a self-managed GitLab instance.
     */
    public static UpdateIntegrationDetails fromGitlabSelfManaged(
            Consumer<UpdateGitLabSelfManagedIntegrationDetail.Builder> gitlabSelfManaged) {
        UpdateGitLabSelfManagedIntegrationDetail.Builder builder = UpdateGitLabSelfManagedIntegrationDetail.builder();
        gitlabSelfManaged.accept(builder);
        return fromGitlabSelfManaged(builder.build());
    }

    /**
     * Create an instance of this class with {@link #github()} initialized to the given value.
     *
     * <p>
     * Details specific to updating an integration with GitHub.
     * </p>
     * 
     * @param github
     *        Details specific to updating an integration with GitHub.
     */
    public static UpdateIntegrationDetails fromGithub(UpdateGitHubIntegrationDetail github) {
        return builder().github(github).build();
    }

    /**
     * Create an instance of this class with {@link #github()} initialized to the given value.
     *
     * <p>
     * Details specific to updating an integration with GitHub.
     * </p>
     * 
     * @param github
     *        Details specific to updating an integration with GitHub.
     */
    public static UpdateIntegrationDetails fromGithub(Consumer<UpdateGitHubIntegrationDetail.Builder> github) {
        UpdateGitHubIntegrationDetail.Builder builder = UpdateGitHubIntegrationDetail.builder();
        github.accept(builder);
        return fromGithub(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gitlabSelfManaged", GITLAB_SELF_MANAGED_FIELD);
        map.put("github", GITHUB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntegrationDetails, T> g) {
        return obj -> g.apply((UpdateIntegrationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateIntegrationDetails> {
        /**
         * <p>
         * Details specific to updating an integration with a self-managed GitLab instance.
         * </p>
         * 
         * @param gitlabSelfManaged
         *        Details specific to updating an integration with a self-managed GitLab instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitlabSelfManaged(UpdateGitLabSelfManagedIntegrationDetail gitlabSelfManaged);

        /**
         * <p>
         * Details specific to updating an integration with a self-managed GitLab instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateGitLabSelfManagedIntegrationDetail.Builder} avoiding the need to create one manually via
         * {@link UpdateGitLabSelfManagedIntegrationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateGitLabSelfManagedIntegrationDetail.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #gitlabSelfManaged(UpdateGitLabSelfManagedIntegrationDetail)}.
         * 
         * @param gitlabSelfManaged
         *        a consumer that will call methods on {@link UpdateGitLabSelfManagedIntegrationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitlabSelfManaged(UpdateGitLabSelfManagedIntegrationDetail)
         */
        default Builder gitlabSelfManaged(Consumer<UpdateGitLabSelfManagedIntegrationDetail.Builder> gitlabSelfManaged) {
            return gitlabSelfManaged(UpdateGitLabSelfManagedIntegrationDetail.builder().applyMutation(gitlabSelfManaged).build());
        }

        /**
         * <p>
         * Details specific to updating an integration with GitHub.
         * </p>
         * 
         * @param github
         *        Details specific to updating an integration with GitHub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder github(UpdateGitHubIntegrationDetail github);

        /**
         * <p>
         * Details specific to updating an integration with GitHub.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateGitHubIntegrationDetail.Builder}
         * avoiding the need to create one manually via {@link UpdateGitHubIntegrationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateGitHubIntegrationDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #github(UpdateGitHubIntegrationDetail)}.
         * 
         * @param github
         *        a consumer that will call methods on {@link UpdateGitHubIntegrationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #github(UpdateGitHubIntegrationDetail)
         */
        default Builder github(Consumer<UpdateGitHubIntegrationDetail.Builder> github) {
            return github(UpdateGitHubIntegrationDetail.builder().applyMutation(github).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateGitLabSelfManagedIntegrationDetail gitlabSelfManaged;

        private UpdateGitHubIntegrationDetail github;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntegrationDetails model) {
            gitlabSelfManaged(model.gitlabSelfManaged);
            github(model.github);
        }

        public final UpdateGitLabSelfManagedIntegrationDetail.Builder getGitlabSelfManaged() {
            return gitlabSelfManaged != null ? gitlabSelfManaged.toBuilder() : null;
        }

        public final void setGitlabSelfManaged(UpdateGitLabSelfManagedIntegrationDetail.BuilderImpl gitlabSelfManaged) {
            Object oldValue = this.gitlabSelfManaged;
            this.gitlabSelfManaged = gitlabSelfManaged != null ? gitlabSelfManaged.build() : null;
            handleUnionValueChange(Type.GITLAB_SELF_MANAGED, oldValue, this.gitlabSelfManaged);
        }

        @Override
        public final Builder gitlabSelfManaged(UpdateGitLabSelfManagedIntegrationDetail gitlabSelfManaged) {
            Object oldValue = this.gitlabSelfManaged;
            this.gitlabSelfManaged = gitlabSelfManaged;
            handleUnionValueChange(Type.GITLAB_SELF_MANAGED, oldValue, this.gitlabSelfManaged);
            return this;
        }

        public final UpdateGitHubIntegrationDetail.Builder getGithub() {
            return github != null ? github.toBuilder() : null;
        }

        public final void setGithub(UpdateGitHubIntegrationDetail.BuilderImpl github) {
            Object oldValue = this.github;
            this.github = github != null ? github.build() : null;
            handleUnionValueChange(Type.GITHUB, oldValue, this.github);
        }

        @Override
        public final Builder github(UpdateGitHubIntegrationDetail github) {
            Object oldValue = this.github;
            this.github = github;
            handleUnionValueChange(Type.GITHUB, oldValue, this.github);
            return this;
        }

        @Override
        public UpdateIntegrationDetails build() {
            return new UpdateIntegrationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see UpdateIntegrationDetails#type()
     */
    public enum Type {
        GITLAB_SELF_MANAGED,

        GITHUB,

        UNKNOWN_TO_SDK_VERSION
    }
}
