/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total of usage for an account ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageTotal implements SdkPojo, Serializable, ToCopyableBuilder<UsageTotal.Builder, UsageTotal> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(UsageTotal::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<List<Usage>> USAGE_FIELD = SdkField
            .<List<Usage>> builder(MarshallingType.LIST)
            .memberName("usage")
            .getter(getter(UsageTotal::usage))
            .setter(setter(Builder::usage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Usage> builder(MarshallingType.SDK_POJO)
                                            .constructor(Usage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, USAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final List<Usage> usage;

    private UsageTotal(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.usage = builder.usage;
    }

    /**
     * <p>
     * The account ID of the account that usage data was retrieved for.
     * </p>
     * 
     * @return The account ID of the account that usage data was retrieved for.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Usage property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsage() {
        return usage != null && !(usage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object representing the total usage for an account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsage} method.
     * </p>
     * 
     * @return An object representing the total usage for an account.
     */
    public final List<Usage> usage() {
        return usage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsage() ? usage() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageTotal)) {
            return false;
        }
        UsageTotal other = (UsageTotal) obj;
        return Objects.equals(accountId(), other.accountId()) && hasUsage() == other.hasUsage()
                && Objects.equals(usage(), other.usage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageTotal").add("AccountId", accountId()).add("Usage", hasUsage() ? usage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "usage":
            return Optional.ofNullable(clazz.cast(usage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("usage", USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageTotal, T> g) {
        return obj -> g.apply((UsageTotal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageTotal> {
        /**
         * <p>
         * The account ID of the account that usage data was retrieved for.
         * </p>
         * 
         * @param accountId
         *        The account ID of the account that usage data was retrieved for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * An object representing the total usage for an account.
         * </p>
         * 
         * @param usage
         *        An object representing the total usage for an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(Collection<Usage> usage);

        /**
         * <p>
         * An object representing the total usage for an account.
         * </p>
         * 
         * @param usage
         *        An object representing the total usage for an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(Usage... usage);

        /**
         * <p>
         * An object representing the total usage for an account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.Usage.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.Usage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.Usage.Builder#build()} is called immediately and its
         * result is passed to {@link #usage(List<Usage>)}.
         * 
         * @param usage
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.Usage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usage(java.util.Collection<Usage>)
         */
        Builder usage(Consumer<Usage.Builder>... usage);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private List<Usage> usage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageTotal model) {
            accountId(model.accountId);
            usage(model.usage);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final List<Usage.Builder> getUsage() {
            List<Usage.Builder> result = UsageListCopier.copyToBuilder(this.usage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsage(Collection<Usage.BuilderImpl> usage) {
            this.usage = UsageListCopier.copyFromBuilder(usage);
        }

        @Override
        public final Builder usage(Collection<Usage> usage) {
            this.usage = UsageListCopier.copy(usage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(Usage... usage) {
            usage(Arrays.asList(usage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(Consumer<Usage.Builder>... usage) {
            usage(Stream.of(usage).map(c -> Usage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UsageTotal build() {
            return new UsageTotal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
