/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information on the vulnerable package identified by a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VulnerablePackage implements SdkPojo, Serializable,
        ToCopyableBuilder<VulnerablePackage.Builder, VulnerablePackage> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(VulnerablePackage::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(VulnerablePackage::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<String> SOURCE_LAYER_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceLayerHash").getter(getter(VulnerablePackage::sourceLayerHash))
            .setter(setter(Builder::sourceLayerHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLayerHash").build()).build();

    private static final SdkField<Integer> EPOCH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("epoch")
            .getter(getter(VulnerablePackage::epoch)).setter(setter(Builder::epoch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epoch").build()).build();

    private static final SdkField<String> RELEASE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("release")
            .getter(getter(VulnerablePackage::release)).setter(setter(Builder::release))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("release").build()).build();

    private static final SdkField<String> ARCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arch")
            .getter(getter(VulnerablePackage::arch)).setter(setter(Builder::arch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arch").build()).build();

    private static final SdkField<String> PACKAGE_MANAGER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageManager").getter(getter(VulnerablePackage::packageManagerAsString))
            .setter(setter(Builder::packageManager))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageManager").build()).build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filePath").getter(getter(VulnerablePackage::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()).build();

    private static final SdkField<String> FIXED_IN_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fixedInVersion").getter(getter(VulnerablePackage::fixedInVersion))
            .setter(setter(Builder::fixedInVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedInVersion").build()).build();

    private static final SdkField<String> REMEDIATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remediation").getter(getter(VulnerablePackage::remediation)).setter(setter(Builder::remediation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()).build();

    private static final SdkField<String> SOURCE_LAMBDA_LAYER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceLambdaLayerArn").getter(getter(VulnerablePackage::sourceLambdaLayerArn))
            .setter(setter(Builder::sourceLambdaLayerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLambdaLayerArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD,
            SOURCE_LAYER_HASH_FIELD, EPOCH_FIELD, RELEASE_FIELD, ARCH_FIELD, PACKAGE_MANAGER_FIELD, FILE_PATH_FIELD,
            FIXED_IN_VERSION_FIELD, REMEDIATION_FIELD, SOURCE_LAMBDA_LAYER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String version;

    private final String sourceLayerHash;

    private final Integer epoch;

    private final String release;

    private final String arch;

    private final String packageManager;

    private final String filePath;

    private final String fixedInVersion;

    private final String remediation;

    private final String sourceLambdaLayerArn;

    private VulnerablePackage(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.sourceLayerHash = builder.sourceLayerHash;
        this.epoch = builder.epoch;
        this.release = builder.release;
        this.arch = builder.arch;
        this.packageManager = builder.packageManager;
        this.filePath = builder.filePath;
        this.fixedInVersion = builder.fixedInVersion;
        this.remediation = builder.remediation;
        this.sourceLambdaLayerArn = builder.sourceLambdaLayerArn;
    }

    /**
     * <p>
     * The name of the vulnerable package.
     * </p>
     * 
     * @return The name of the vulnerable package.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the vulnerable package.
     * </p>
     * 
     * @return The version of the vulnerable package.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The source layer hash of the vulnerable package.
     * </p>
     * 
     * @return The source layer hash of the vulnerable package.
     */
    public final String sourceLayerHash() {
        return sourceLayerHash;
    }

    /**
     * <p>
     * The epoch of the vulnerable package.
     * </p>
     * 
     * @return The epoch of the vulnerable package.
     */
    public final Integer epoch() {
        return epoch;
    }

    /**
     * <p>
     * The release of the vulnerable package.
     * </p>
     * 
     * @return The release of the vulnerable package.
     */
    public final String release() {
        return release;
    }

    /**
     * <p>
     * The architecture of the vulnerable package.
     * </p>
     * 
     * @return The architecture of the vulnerable package.
     */
    public final String arch() {
        return arch;
    }

    /**
     * <p>
     * The package manager of the vulnerable package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageManager}
     * will return {@link PackageManager#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #packageManagerAsString}.
     * </p>
     * 
     * @return The package manager of the vulnerable package.
     * @see PackageManager
     */
    public final PackageManager packageManager() {
        return PackageManager.fromValue(packageManager);
    }

    /**
     * <p>
     * The package manager of the vulnerable package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageManager}
     * will return {@link PackageManager#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #packageManagerAsString}.
     * </p>
     * 
     * @return The package manager of the vulnerable package.
     * @see PackageManager
     */
    public final String packageManagerAsString() {
        return packageManager;
    }

    /**
     * <p>
     * The file path of the vulnerable package.
     * </p>
     * 
     * @return The file path of the vulnerable package.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The version of the package that contains the vulnerability fix.
     * </p>
     * 
     * @return The version of the package that contains the vulnerability fix.
     */
    public final String fixedInVersion() {
        return fixedInVersion;
    }

    /**
     * <p>
     * The code to run in your environment to update packages with a fix available.
     * </p>
     * 
     * @return The code to run in your environment to update packages with a fix available.
     */
    public final String remediation() {
        return remediation;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of the Amazon Web Services Lambda function affected by a finding.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of the Amazon Web Services Lambda function affected by a finding.
     */
    public final String sourceLambdaLayerArn() {
        return sourceLambdaLayerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLayerHash());
        hashCode = 31 * hashCode + Objects.hashCode(epoch());
        hashCode = 31 * hashCode + Objects.hashCode(release());
        hashCode = 31 * hashCode + Objects.hashCode(arch());
        hashCode = 31 * hashCode + Objects.hashCode(packageManagerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(fixedInVersion());
        hashCode = 31 * hashCode + Objects.hashCode(remediation());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLambdaLayerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VulnerablePackage)) {
            return false;
        }
        VulnerablePackage other = (VulnerablePackage) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(sourceLayerHash(), other.sourceLayerHash()) && Objects.equals(epoch(), other.epoch())
                && Objects.equals(release(), other.release()) && Objects.equals(arch(), other.arch())
                && Objects.equals(packageManagerAsString(), other.packageManagerAsString())
                && Objects.equals(filePath(), other.filePath()) && Objects.equals(fixedInVersion(), other.fixedInVersion())
                && Objects.equals(remediation(), other.remediation())
                && Objects.equals(sourceLambdaLayerArn(), other.sourceLambdaLayerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VulnerablePackage").add("Name", name()).add("Version", version())
                .add("SourceLayerHash", sourceLayerHash()).add("Epoch", epoch()).add("Release", release()).add("Arch", arch())
                .add("PackageManager", packageManagerAsString()).add("FilePath", filePath())
                .add("FixedInVersion", fixedInVersion()).add("Remediation", remediation())
                .add("SourceLambdaLayerArn", sourceLambdaLayerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "sourceLayerHash":
            return Optional.ofNullable(clazz.cast(sourceLayerHash()));
        case "epoch":
            return Optional.ofNullable(clazz.cast(epoch()));
        case "release":
            return Optional.ofNullable(clazz.cast(release()));
        case "arch":
            return Optional.ofNullable(clazz.cast(arch()));
        case "packageManager":
            return Optional.ofNullable(clazz.cast(packageManagerAsString()));
        case "filePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "fixedInVersion":
            return Optional.ofNullable(clazz.cast(fixedInVersion()));
        case "remediation":
            return Optional.ofNullable(clazz.cast(remediation()));
        case "sourceLambdaLayerArn":
            return Optional.ofNullable(clazz.cast(sourceLambdaLayerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("sourceLayerHash", SOURCE_LAYER_HASH_FIELD);
        map.put("epoch", EPOCH_FIELD);
        map.put("release", RELEASE_FIELD);
        map.put("arch", ARCH_FIELD);
        map.put("packageManager", PACKAGE_MANAGER_FIELD);
        map.put("filePath", FILE_PATH_FIELD);
        map.put("fixedInVersion", FIXED_IN_VERSION_FIELD);
        map.put("remediation", REMEDIATION_FIELD);
        map.put("sourceLambdaLayerArn", SOURCE_LAMBDA_LAYER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VulnerablePackage, T> g) {
        return obj -> g.apply((VulnerablePackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VulnerablePackage> {
        /**
         * <p>
         * The name of the vulnerable package.
         * </p>
         * 
         * @param name
         *        The name of the vulnerable package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the vulnerable package.
         * </p>
         * 
         * @param version
         *        The version of the vulnerable package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The source layer hash of the vulnerable package.
         * </p>
         * 
         * @param sourceLayerHash
         *        The source layer hash of the vulnerable package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLayerHash(String sourceLayerHash);

        /**
         * <p>
         * The epoch of the vulnerable package.
         * </p>
         * 
         * @param epoch
         *        The epoch of the vulnerable package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder epoch(Integer epoch);

        /**
         * <p>
         * The release of the vulnerable package.
         * </p>
         * 
         * @param release
         *        The release of the vulnerable package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder release(String release);

        /**
         * <p>
         * The architecture of the vulnerable package.
         * </p>
         * 
         * @param arch
         *        The architecture of the vulnerable package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arch(String arch);

        /**
         * <p>
         * The package manager of the vulnerable package.
         * </p>
         * 
         * @param packageManager
         *        The package manager of the vulnerable package.
         * @see PackageManager
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageManager
         */
        Builder packageManager(String packageManager);

        /**
         * <p>
         * The package manager of the vulnerable package.
         * </p>
         * 
         * @param packageManager
         *        The package manager of the vulnerable package.
         * @see PackageManager
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageManager
         */
        Builder packageManager(PackageManager packageManager);

        /**
         * <p>
         * The file path of the vulnerable package.
         * </p>
         * 
         * @param filePath
         *        The file path of the vulnerable package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The version of the package that contains the vulnerability fix.
         * </p>
         * 
         * @param fixedInVersion
         *        The version of the package that contains the vulnerability fix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedInVersion(String fixedInVersion);

        /**
         * <p>
         * The code to run in your environment to update packages with a fix available.
         * </p>
         * 
         * @param remediation
         *        The code to run in your environment to update packages with a fix available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediation(String remediation);

        /**
         * <p>
         * The Amazon Resource Number (ARN) of the Amazon Web Services Lambda function affected by a finding.
         * </p>
         * 
         * @param sourceLambdaLayerArn
         *        The Amazon Resource Number (ARN) of the Amazon Web Services Lambda function affected by a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLambdaLayerArn(String sourceLambdaLayerArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String version;

        private String sourceLayerHash;

        private Integer epoch;

        private String release;

        private String arch;

        private String packageManager;

        private String filePath;

        private String fixedInVersion;

        private String remediation;

        private String sourceLambdaLayerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VulnerablePackage model) {
            name(model.name);
            version(model.version);
            sourceLayerHash(model.sourceLayerHash);
            epoch(model.epoch);
            release(model.release);
            arch(model.arch);
            packageManager(model.packageManager);
            filePath(model.filePath);
            fixedInVersion(model.fixedInVersion);
            remediation(model.remediation);
            sourceLambdaLayerArn(model.sourceLambdaLayerArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getSourceLayerHash() {
            return sourceLayerHash;
        }

        public final void setSourceLayerHash(String sourceLayerHash) {
            this.sourceLayerHash = sourceLayerHash;
        }

        @Override
        public final Builder sourceLayerHash(String sourceLayerHash) {
            this.sourceLayerHash = sourceLayerHash;
            return this;
        }

        public final Integer getEpoch() {
            return epoch;
        }

        public final void setEpoch(Integer epoch) {
            this.epoch = epoch;
        }

        @Override
        public final Builder epoch(Integer epoch) {
            this.epoch = epoch;
            return this;
        }

        public final String getRelease() {
            return release;
        }

        public final void setRelease(String release) {
            this.release = release;
        }

        @Override
        public final Builder release(String release) {
            this.release = release;
            return this;
        }

        public final String getArch() {
            return arch;
        }

        public final void setArch(String arch) {
            this.arch = arch;
        }

        @Override
        public final Builder arch(String arch) {
            this.arch = arch;
            return this;
        }

        public final String getPackageManager() {
            return packageManager;
        }

        public final void setPackageManager(String packageManager) {
            this.packageManager = packageManager;
        }

        @Override
        public final Builder packageManager(String packageManager) {
            this.packageManager = packageManager;
            return this;
        }

        @Override
        public final Builder packageManager(PackageManager packageManager) {
            this.packageManager(packageManager == null ? null : packageManager.toString());
            return this;
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final String getFixedInVersion() {
            return fixedInVersion;
        }

        public final void setFixedInVersion(String fixedInVersion) {
            this.fixedInVersion = fixedInVersion;
        }

        @Override
        public final Builder fixedInVersion(String fixedInVersion) {
            this.fixedInVersion = fixedInVersion;
            return this;
        }

        public final String getRemediation() {
            return remediation;
        }

        public final void setRemediation(String remediation) {
            this.remediation = remediation;
        }

        @Override
        public final Builder remediation(String remediation) {
            this.remediation = remediation;
            return this;
        }

        public final String getSourceLambdaLayerArn() {
            return sourceLambdaLayerArn;
        }

        public final void setSourceLambdaLayerArn(String sourceLambdaLayerArn) {
            this.sourceLambdaLayerArn = sourceLambdaLayerArn;
        }

        @Override
        public final Builder sourceLambdaLayerArn(String sourceLambdaLayerArn) {
            this.sourceLambdaLayerArn = sourceLambdaLayerArn;
            return this;
        }

        @Override
        public VulnerablePackage build() {
            return new VulnerablePackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
