/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details that define an aggregation based on Amazon machine images (AMIs).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmiAggregation implements SdkPojo, Serializable, ToCopyableBuilder<AmiAggregation.Builder, AmiAggregation> {
    private static final SdkField<List<StringFilter>> AMIS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("amis")
            .getter(getter(AmiAggregation::amis))
            .setter(setter(Builder::amis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amis").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(AmiAggregation::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(AmiAggregation::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMIS_FIELD, SORT_ORDER_FIELD,
            SORT_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<StringFilter> amis;

    private final String sortOrder;

    private final String sortBy;

    private AmiAggregation(BuilderImpl builder) {
        this.amis = builder.amis;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Amis property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAmis() {
        return amis != null && !(amis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of AMIs to aggregate findings for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAmis} method.
     * </p>
     * 
     * @return The IDs of AMIs to aggregate findings for.
     */
    public final List<StringFilter> amis() {
        return amis;
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link AmiSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see AmiSortBy
     */
    public final AmiSortBy sortBy() {
        return AmiSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The value to sort results by.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link AmiSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by.
     * @see AmiSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAmis() ? amis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiAggregation)) {
            return false;
        }
        AmiAggregation other = (AmiAggregation) obj;
        return hasAmis() == other.hasAmis() && Objects.equals(amis(), other.amis())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmiAggregation").add("Amis", hasAmis() ? amis() : null).add("SortOrder", sortOrderAsString())
                .add("SortBy", sortByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amis":
            return Optional.ofNullable(clazz.cast(amis()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("amis", AMIS_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmiAggregation, T> g) {
        return obj -> g.apply((AmiAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmiAggregation> {
        /**
         * <p>
         * The IDs of AMIs to aggregate findings for.
         * </p>
         * 
         * @param amis
         *        The IDs of AMIs to aggregate findings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amis(Collection<StringFilter> amis);

        /**
         * <p>
         * The IDs of AMIs to aggregate findings for.
         * </p>
         * 
         * @param amis
         *        The IDs of AMIs to aggregate findings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amis(StringFilter... amis);

        /**
         * <p>
         * The IDs of AMIs to aggregate findings for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #amis(List<StringFilter>)}.
         * 
         * @param amis
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amis(java.util.Collection<StringFilter>)
         */
        Builder amis(Consumer<StringFilter.Builder>... amis);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order to sort results by.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see AmiSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmiSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The value to sort results by.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by.
         * @see AmiSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmiSortBy
         */
        Builder sortBy(AmiSortBy sortBy);
    }

    static final class BuilderImpl implements Builder {
        private List<StringFilter> amis = DefaultSdkAutoConstructList.getInstance();

        private String sortOrder;

        private String sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AmiAggregation model) {
            amis(model.amis);
            sortOrder(model.sortOrder);
            sortBy(model.sortBy);
        }

        public final List<StringFilter.Builder> getAmis() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.amis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmis(Collection<StringFilter.BuilderImpl> amis) {
            this.amis = StringFilterListCopier.copyFromBuilder(amis);
        }

        @Override
        public final Builder amis(Collection<StringFilter> amis) {
            this.amis = StringFilterListCopier.copy(amis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(StringFilter... amis) {
            amis(Arrays.asList(amis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amis(Consumer<StringFilter.Builder>... amis) {
            amis(Stream.of(amis).map(c -> StringFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(AmiSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        @Override
        public AmiAggregation build() {
            return new AmiAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
