/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a request to associate a code repository with a scan configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateConfigurationRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociateConfigurationRequest.Builder, AssociateConfigurationRequest> {
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanConfigurationArn").getter(getter(AssociateConfigurationRequest::scanConfigurationArn))
            .setter(setter(Builder::scanConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build())
            .build();

    private static final SdkField<CodeSecurityResource> RESOURCE_FIELD = SdkField
            .<CodeSecurityResource> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(AssociateConfigurationRequest::resource)).setter(setter(Builder::resource))
            .constructor(CodeSecurityResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_CONFIGURATION_ARN_FIELD,
            RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scanConfigurationArn;

    private final CodeSecurityResource resource;

    private AssociateConfigurationRequest(BuilderImpl builder) {
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.resource = builder.resource;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the scan configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the scan configuration.
     */
    public final String scanConfigurationArn() {
        return scanConfigurationArn;
    }

    /**
     * Returns the value of the Resource property for this object.
     * 
     * @return The value of the Resource property for this object.
     */
    public final CodeSecurityResource resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateConfigurationRequest)) {
            return false;
        }
        AssociateConfigurationRequest other = (AssociateConfigurationRequest) obj;
        return Objects.equals(scanConfigurationArn(), other.scanConfigurationArn())
                && Objects.equals(resource(), other.resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateConfigurationRequest").add("ScanConfigurationArn", scanConfigurationArn())
                .add("Resource", resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanConfigurationArn":
            return Optional.ofNullable(clazz.cast(scanConfigurationArn()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("resource", RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateConfigurationRequest, T> g) {
        return obj -> g.apply((AssociateConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociateConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the scan configuration.
         * </p>
         * 
         * @param scanConfigurationArn
         *        The Amazon Resource Name (ARN) of the scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArn(String scanConfigurationArn);

        /**
         * Sets the value of the Resource property for this object.
         *
         * @param resource
         *        The new value for the Resource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(CodeSecurityResource resource);

        /**
         * Sets the value of the Resource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CodeSecurityResource.Builder} avoiding
         * the need to create one manually via {@link CodeSecurityResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeSecurityResource.Builder#build()} is called immediately and
         * its result is passed to {@link #resource(CodeSecurityResource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link CodeSecurityResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(CodeSecurityResource)
         */
        default Builder resource(Consumer<CodeSecurityResource.Builder> resource) {
            return resource(CodeSecurityResource.builder().applyMutation(resource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String scanConfigurationArn;

        private CodeSecurityResource resource;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateConfigurationRequest model) {
            scanConfigurationArn(model.scanConfigurationArn);
            resource(model.resource);
        }

        public final String getScanConfigurationArn() {
            return scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final CodeSecurityResource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(CodeSecurityResource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(CodeSecurityResource resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public AssociateConfigurationRequest build() {
            return new AssociateConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
