/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An aggregation of information about Amazon ECR containers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcrContainerAggregationResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcrContainerAggregationResponse.Builder, AwsEcrContainerAggregationResponse> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(AwsEcrContainerAggregationResponse::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> IMAGE_SHA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageSha").getter(getter(AwsEcrContainerAggregationResponse::imageSha))
            .setter(setter(Builder::imageSha))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSha").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(AwsEcrContainerAggregationResponse::repository))
            .setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("architecture").getter(getter(AwsEcrContainerAggregationResponse::architecture))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<List<String>> IMAGE_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("imageTags")
            .getter(getter(AwsEcrContainerAggregationResponse::imageTags))
            .setter(setter(Builder::imageTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AwsEcrContainerAggregationResponse::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<SeverityCounts> SEVERITY_COUNTS_FIELD = SdkField
            .<SeverityCounts> builder(MarshallingType.SDK_POJO).memberName("severityCounts")
            .getter(getter(AwsEcrContainerAggregationResponse::severityCounts)).setter(setter(Builder::severityCounts))
            .constructor(SeverityCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severityCounts").build()).build();

    private static final SdkField<Instant> LAST_IN_USE_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastInUseAt").getter(getter(AwsEcrContainerAggregationResponse::lastInUseAt))
            .setter(setter(Builder::lastInUseAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastInUseAt").build()).build();

    private static final SdkField<Long> IN_USE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("inUseCount").getter(getter(AwsEcrContainerAggregationResponse::inUseCount))
            .setter(setter(Builder::inUseCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inUseCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            IMAGE_SHA_FIELD, REPOSITORY_FIELD, ARCHITECTURE_FIELD, IMAGE_TAGS_FIELD, ACCOUNT_ID_FIELD, SEVERITY_COUNTS_FIELD,
            LAST_IN_USE_AT_FIELD, IN_USE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceId;

    private final String imageSha;

    private final String repository;

    private final String architecture;

    private final List<String> imageTags;

    private final String accountId;

    private final SeverityCounts severityCounts;

    private final Instant lastInUseAt;

    private final Long inUseCount;

    private AwsEcrContainerAggregationResponse(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.imageSha = builder.imageSha;
        this.repository = builder.repository;
        this.architecture = builder.architecture;
        this.imageTags = builder.imageTags;
        this.accountId = builder.accountId;
        this.severityCounts = builder.severityCounts;
        this.lastInUseAt = builder.lastInUseAt;
        this.inUseCount = builder.inUseCount;
    }

    /**
     * <p>
     * The resource ID of the container.
     * </p>
     * 
     * @return The resource ID of the container.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The SHA value of the container image.
     * </p>
     * 
     * @return The SHA value of the container image.
     */
    public final String imageSha() {
        return imageSha;
    }

    /**
     * <p>
     * The container repository.
     * </p>
     * 
     * @return The container repository.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * The architecture of the container.
     * </p>
     * 
     * @return The architecture of the container.
     */
    public final String architecture() {
        return architecture;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImageTags() {
        return imageTags != null && !(imageTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The container image stags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageTags} method.
     * </p>
     * 
     * @return The container image stags.
     */
    public final List<String> imageTags() {
        return imageTags;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the account that owns the container.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the account that owns the container.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The number of finding by severity.
     * </p>
     * 
     * @return The number of finding by severity.
     */
    public final SeverityCounts severityCounts() {
        return severityCounts;
    }

    /**
     * <p>
     * The last time an Amazon ECR image was used in an Amazon ECS task or Amazon EKS pod.
     * </p>
     * 
     * @return The last time an Amazon ECR image was used in an Amazon ECS task or Amazon EKS pod.
     */
    public final Instant lastInUseAt() {
        return lastInUseAt;
    }

    /**
     * <p>
     * The number of Amazon ECS tasks or Amazon EKS pods where the Amazon ECR container image is in use.
     * </p>
     * 
     * @return The number of Amazon ECS tasks or Amazon EKS pods where the Amazon ECR container image is in use.
     */
    public final Long inUseCount() {
        return inUseCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(imageSha());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(hasImageTags() ? imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(severityCounts());
        hashCode = 31 * hashCode + Objects.hashCode(lastInUseAt());
        hashCode = 31 * hashCode + Objects.hashCode(inUseCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcrContainerAggregationResponse)) {
            return false;
        }
        AwsEcrContainerAggregationResponse other = (AwsEcrContainerAggregationResponse) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(imageSha(), other.imageSha())
                && Objects.equals(repository(), other.repository()) && Objects.equals(architecture(), other.architecture())
                && hasImageTags() == other.hasImageTags() && Objects.equals(imageTags(), other.imageTags())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(severityCounts(), other.severityCounts())
                && Objects.equals(lastInUseAt(), other.lastInUseAt()) && Objects.equals(inUseCount(), other.inUseCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcrContainerAggregationResponse").add("ResourceId", resourceId()).add("ImageSha", imageSha())
                .add("Repository", repository()).add("Architecture", architecture())
                .add("ImageTags", hasImageTags() ? imageTags() : null).add("AccountId", accountId())
                .add("SeverityCounts", severityCounts()).add("LastInUseAt", lastInUseAt()).add("InUseCount", inUseCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "imageSha":
            return Optional.ofNullable(clazz.cast(imageSha()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architecture()));
        case "imageTags":
            return Optional.ofNullable(clazz.cast(imageTags()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "severityCounts":
            return Optional.ofNullable(clazz.cast(severityCounts()));
        case "lastInUseAt":
            return Optional.ofNullable(clazz.cast(lastInUseAt()));
        case "inUseCount":
            return Optional.ofNullable(clazz.cast(inUseCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("imageSha", IMAGE_SHA_FIELD);
        map.put("repository", REPOSITORY_FIELD);
        map.put("architecture", ARCHITECTURE_FIELD);
        map.put("imageTags", IMAGE_TAGS_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("severityCounts", SEVERITY_COUNTS_FIELD);
        map.put("lastInUseAt", LAST_IN_USE_AT_FIELD);
        map.put("inUseCount", IN_USE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcrContainerAggregationResponse, T> g) {
        return obj -> g.apply((AwsEcrContainerAggregationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcrContainerAggregationResponse> {
        /**
         * <p>
         * The resource ID of the container.
         * </p>
         * 
         * @param resourceId
         *        The resource ID of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The SHA value of the container image.
         * </p>
         * 
         * @param imageSha
         *        The SHA value of the container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageSha(String imageSha);

        /**
         * <p>
         * The container repository.
         * </p>
         * 
         * @param repository
         *        The container repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The architecture of the container.
         * </p>
         * 
         * @param architecture
         *        The architecture of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The container image stags.
         * </p>
         * 
         * @param imageTags
         *        The container image stags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTags(Collection<String> imageTags);

        /**
         * <p>
         * The container image stags.
         * </p>
         * 
         * @param imageTags
         *        The container image stags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTags(String... imageTags);

        /**
         * <p>
         * The Amazon Web Services account ID of the account that owns the container.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID of the account that owns the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The number of finding by severity.
         * </p>
         * 
         * @param severityCounts
         *        The number of finding by severity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityCounts(SeverityCounts severityCounts);

        /**
         * <p>
         * The number of finding by severity.
         * </p>
         * This is a convenience method that creates an instance of the {@link SeverityCounts.Builder} avoiding the need
         * to create one manually via {@link SeverityCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityCounts.Builder#build()} is called immediately and its
         * result is passed to {@link #severityCounts(SeverityCounts)}.
         * 
         * @param severityCounts
         *        a consumer that will call methods on {@link SeverityCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severityCounts(SeverityCounts)
         */
        default Builder severityCounts(Consumer<SeverityCounts.Builder> severityCounts) {
            return severityCounts(SeverityCounts.builder().applyMutation(severityCounts).build());
        }

        /**
         * <p>
         * The last time an Amazon ECR image was used in an Amazon ECS task or Amazon EKS pod.
         * </p>
         * 
         * @param lastInUseAt
         *        The last time an Amazon ECR image was used in an Amazon ECS task or Amazon EKS pod.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastInUseAt(Instant lastInUseAt);

        /**
         * <p>
         * The number of Amazon ECS tasks or Amazon EKS pods where the Amazon ECR container image is in use.
         * </p>
         * 
         * @param inUseCount
         *        The number of Amazon ECS tasks or Amazon EKS pods where the Amazon ECR container image is in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inUseCount(Long inUseCount);
    }

    static final class BuilderImpl implements Builder {
        private String resourceId;

        private String imageSha;

        private String repository;

        private String architecture;

        private List<String> imageTags = DefaultSdkAutoConstructList.getInstance();

        private String accountId;

        private SeverityCounts severityCounts;

        private Instant lastInUseAt;

        private Long inUseCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcrContainerAggregationResponse model) {
            resourceId(model.resourceId);
            imageSha(model.imageSha);
            repository(model.repository);
            architecture(model.architecture);
            imageTags(model.imageTags);
            accountId(model.accountId);
            severityCounts(model.severityCounts);
            lastInUseAt(model.lastInUseAt);
            inUseCount(model.inUseCount);
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getImageSha() {
            return imageSha;
        }

        public final void setImageSha(String imageSha) {
            this.imageSha = imageSha;
        }

        @Override
        public final Builder imageSha(String imageSha) {
            this.imageSha = imageSha;
            return this;
        }

        public final String getRepository() {
            return repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final Collection<String> getImageTags() {
            if (imageTags instanceof SdkAutoConstructList) {
                return null;
            }
            return imageTags;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = StringListCopier.copy(imageTags);
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = StringListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String... imageTags) {
            imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final SeverityCounts.Builder getSeverityCounts() {
            return severityCounts != null ? severityCounts.toBuilder() : null;
        }

        public final void setSeverityCounts(SeverityCounts.BuilderImpl severityCounts) {
            this.severityCounts = severityCounts != null ? severityCounts.build() : null;
        }

        @Override
        public final Builder severityCounts(SeverityCounts severityCounts) {
            this.severityCounts = severityCounts;
            return this;
        }

        public final Instant getLastInUseAt() {
            return lastInUseAt;
        }

        public final void setLastInUseAt(Instant lastInUseAt) {
            this.lastInUseAt = lastInUseAt;
        }

        @Override
        public final Builder lastInUseAt(Instant lastInUseAt) {
            this.lastInUseAt = lastInUseAt;
            return this;
        }

        public final Long getInUseCount() {
            return inUseCount;
        }

        public final void setInUseCount(Long inUseCount) {
            this.inUseCount = inUseCount;
        }

        @Override
        public final Builder inUseCount(Long inUseCount) {
            this.inUseCount = inUseCount;
            return this;
        }

        @Override
        public AwsEcrContainerAggregationResponse build() {
            return new AwsEcrContainerAggregationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
