/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata for an Amazon EKS pod where an Amazon ECR image is in use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEksMetadataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEksMetadataDetails.Builder, AwsEksMetadataDetails> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(AwsEksMetadataDetails::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<List<AwsEksWorkloadInfo>> WORKLOAD_INFO_LIST_FIELD = SdkField
            .<List<AwsEksWorkloadInfo>> builder(MarshallingType.LIST)
            .memberName("workloadInfoList")
            .getter(getter(AwsEksMetadataDetails::workloadInfoList))
            .setter(setter(Builder::workloadInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEksWorkloadInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEksWorkloadInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD,
            WORKLOAD_INFO_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String namespace;

    private final List<AwsEksWorkloadInfo> workloadInfoList;

    private AwsEksMetadataDetails(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.workloadInfoList = builder.workloadInfoList;
    }

    /**
     * <p>
     * The namespace for an Amazon EKS cluster.
     * </p>
     * 
     * @return The namespace for an Amazon EKS cluster.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkloadInfoList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkloadInfoList() {
        return workloadInfoList != null && !(workloadInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of workloads.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkloadInfoList} method.
     * </p>
     * 
     * @return The list of workloads.
     */
    public final List<AwsEksWorkloadInfo> workloadInfoList() {
        return workloadInfoList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkloadInfoList() ? workloadInfoList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEksMetadataDetails)) {
            return false;
        }
        AwsEksMetadataDetails other = (AwsEksMetadataDetails) obj;
        return Objects.equals(namespace(), other.namespace()) && hasWorkloadInfoList() == other.hasWorkloadInfoList()
                && Objects.equals(workloadInfoList(), other.workloadInfoList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEksMetadataDetails").add("Namespace", namespace())
                .add("WorkloadInfoList", hasWorkloadInfoList() ? workloadInfoList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "workloadInfoList":
            return Optional.ofNullable(clazz.cast(workloadInfoList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("namespace", NAMESPACE_FIELD);
        map.put("workloadInfoList", WORKLOAD_INFO_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEksMetadataDetails, T> g) {
        return obj -> g.apply((AwsEksMetadataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEksMetadataDetails> {
        /**
         * <p>
         * The namespace for an Amazon EKS cluster.
         * </p>
         * 
         * @param namespace
         *        The namespace for an Amazon EKS cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The list of workloads.
         * </p>
         * 
         * @param workloadInfoList
         *        The list of workloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadInfoList(Collection<AwsEksWorkloadInfo> workloadInfoList);

        /**
         * <p>
         * The list of workloads.
         * </p>
         * 
         * @param workloadInfoList
         *        The list of workloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadInfoList(AwsEksWorkloadInfo... workloadInfoList);

        /**
         * <p>
         * The list of workloads.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.AwsEksWorkloadInfo.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.inspector2.model.AwsEksWorkloadInfo#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.AwsEksWorkloadInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #workloadInfoList(List<AwsEksWorkloadInfo>)}.
         * 
         * @param workloadInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.AwsEksWorkloadInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workloadInfoList(java.util.Collection<AwsEksWorkloadInfo>)
         */
        Builder workloadInfoList(Consumer<AwsEksWorkloadInfo.Builder>... workloadInfoList);
    }

    static final class BuilderImpl implements Builder {
        private String namespace;

        private List<AwsEksWorkloadInfo> workloadInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEksMetadataDetails model) {
            namespace(model.namespace);
            workloadInfoList(model.workloadInfoList);
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final List<AwsEksWorkloadInfo.Builder> getWorkloadInfoList() {
            List<AwsEksWorkloadInfo.Builder> result = AwsEksWorkloadInfoListCopier.copyToBuilder(this.workloadInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkloadInfoList(Collection<AwsEksWorkloadInfo.BuilderImpl> workloadInfoList) {
            this.workloadInfoList = AwsEksWorkloadInfoListCopier.copyFromBuilder(workloadInfoList);
        }

        @Override
        public final Builder workloadInfoList(Collection<AwsEksWorkloadInfo> workloadInfoList) {
            this.workloadInfoList = AwsEksWorkloadInfoListCopier.copy(workloadInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadInfoList(AwsEksWorkloadInfo... workloadInfoList) {
            workloadInfoList(Arrays.asList(workloadInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadInfoList(Consumer<AwsEksWorkloadInfo.Builder>... workloadInfoList) {
            workloadInfoList(Stream.of(workloadInfoList).map(c -> AwsEksWorkloadInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsEksMetadataDetails build() {
            return new AwsEksMetadataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
