/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateCodeSecurityScanConfigurationRequest extends Inspector2Request
        implements
        ToCopyableBuilder<BatchAssociateCodeSecurityScanConfigurationRequest.Builder, BatchAssociateCodeSecurityScanConfigurationRequest> {
    private static final SdkField<List<AssociateConfigurationRequest>> ASSOCIATE_CONFIGURATION_REQUESTS_FIELD = SdkField
            .<List<AssociateConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("associateConfigurationRequests")
            .getter(getter(BatchAssociateCodeSecurityScanConfigurationRequest::associateConfigurationRequests))
            .setter(setter(Builder::associateConfigurationRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associateConfigurationRequests")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociateConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociateConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ASSOCIATE_CONFIGURATION_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AssociateConfigurationRequest> associateConfigurationRequests;

    private BatchAssociateCodeSecurityScanConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.associateConfigurationRequests = builder.associateConfigurationRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociateConfigurationRequests property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociateConfigurationRequests() {
        return associateConfigurationRequests != null && !(associateConfigurationRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of code repositories to associate with the specified scan configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociateConfigurationRequests} method.
     * </p>
     * 
     * @return A list of code repositories to associate with the specified scan configuration.
     */
    public final List<AssociateConfigurationRequest> associateConfigurationRequests() {
        return associateConfigurationRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAssociateConfigurationRequests() ? associateConfigurationRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateCodeSecurityScanConfigurationRequest)) {
            return false;
        }
        BatchAssociateCodeSecurityScanConfigurationRequest other = (BatchAssociateCodeSecurityScanConfigurationRequest) obj;
        return hasAssociateConfigurationRequests() == other.hasAssociateConfigurationRequests()
                && Objects.equals(associateConfigurationRequests(), other.associateConfigurationRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchAssociateCodeSecurityScanConfigurationRequest")
                .add("AssociateConfigurationRequests",
                        hasAssociateConfigurationRequests() ? associateConfigurationRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associateConfigurationRequests":
            return Optional.ofNullable(clazz.cast(associateConfigurationRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associateConfigurationRequests", ASSOCIATE_CONFIGURATION_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateCodeSecurityScanConfigurationRequest, T> g) {
        return obj -> g.apply((BatchAssociateCodeSecurityScanConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateCodeSecurityScanConfigurationRequest> {
        /**
         * <p>
         * A list of code repositories to associate with the specified scan configuration.
         * </p>
         * 
         * @param associateConfigurationRequests
         *        A list of code repositories to associate with the specified scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateConfigurationRequests(Collection<AssociateConfigurationRequest> associateConfigurationRequests);

        /**
         * <p>
         * A list of code repositories to associate with the specified scan configuration.
         * </p>
         * 
         * @param associateConfigurationRequests
         *        A list of code repositories to associate with the specified scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateConfigurationRequests(AssociateConfigurationRequest... associateConfigurationRequests);

        /**
         * <p>
         * A list of code repositories to associate with the specified scan configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.AssociateConfigurationRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.AssociateConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.AssociateConfigurationRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #associateConfigurationRequests(List<AssociateConfigurationRequest>)}.
         * 
         * @param associateConfigurationRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.AssociateConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associateConfigurationRequests(java.util.Collection<AssociateConfigurationRequest>)
         */
        Builder associateConfigurationRequests(Consumer<AssociateConfigurationRequest.Builder>... associateConfigurationRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private List<AssociateConfigurationRequest> associateConfigurationRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateCodeSecurityScanConfigurationRequest model) {
            super(model);
            associateConfigurationRequests(model.associateConfigurationRequests);
        }

        public final List<AssociateConfigurationRequest.Builder> getAssociateConfigurationRequests() {
            List<AssociateConfigurationRequest.Builder> result = AssociateConfigurationRequestListCopier
                    .copyToBuilder(this.associateConfigurationRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociateConfigurationRequests(
                Collection<AssociateConfigurationRequest.BuilderImpl> associateConfigurationRequests) {
            this.associateConfigurationRequests = AssociateConfigurationRequestListCopier
                    .copyFromBuilder(associateConfigurationRequests);
        }

        @Override
        public final Builder associateConfigurationRequests(
                Collection<AssociateConfigurationRequest> associateConfigurationRequests) {
            this.associateConfigurationRequests = AssociateConfigurationRequestListCopier.copy(associateConfigurationRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associateConfigurationRequests(AssociateConfigurationRequest... associateConfigurationRequests) {
            associateConfigurationRequests(Arrays.asList(associateConfigurationRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associateConfigurationRequests(
                Consumer<AssociateConfigurationRequest.Builder>... associateConfigurationRequests) {
            associateConfigurationRequests(Stream.of(associateConfigurationRequests)
                    .map(c -> AssociateConfigurationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateCodeSecurityScanConfigurationRequest build() {
            return new BatchAssociateCodeSecurityScanConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
