/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDisassociateCodeSecurityScanConfigurationRequest extends Inspector2Request
        implements
        ToCopyableBuilder<BatchDisassociateCodeSecurityScanConfigurationRequest.Builder, BatchDisassociateCodeSecurityScanConfigurationRequest> {
    private static final SdkField<List<DisassociateConfigurationRequest>> DISASSOCIATE_CONFIGURATION_REQUESTS_FIELD = SdkField
            .<List<DisassociateConfigurationRequest>> builder(MarshallingType.LIST)
            .memberName("disassociateConfigurationRequests")
            .getter(getter(BatchDisassociateCodeSecurityScanConfigurationRequest::disassociateConfigurationRequests))
            .setter(setter(Builder::disassociateConfigurationRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disassociateConfigurationRequests")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DisassociateConfigurationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisassociateConfigurationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DISASSOCIATE_CONFIGURATION_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DisassociateConfigurationRequest> disassociateConfigurationRequests;

    private BatchDisassociateCodeSecurityScanConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.disassociateConfigurationRequests = builder.disassociateConfigurationRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the DisassociateConfigurationRequests
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDisassociateConfigurationRequests() {
        return disassociateConfigurationRequests != null && !(disassociateConfigurationRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of code repositories to disassociate from the specified scan configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDisassociateConfigurationRequests}
     * method.
     * </p>
     * 
     * @return A list of code repositories to disassociate from the specified scan configuration.
     */
    public final List<DisassociateConfigurationRequest> disassociateConfigurationRequests() {
        return disassociateConfigurationRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDisassociateConfigurationRequests() ? disassociateConfigurationRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisassociateCodeSecurityScanConfigurationRequest)) {
            return false;
        }
        BatchDisassociateCodeSecurityScanConfigurationRequest other = (BatchDisassociateCodeSecurityScanConfigurationRequest) obj;
        return hasDisassociateConfigurationRequests() == other.hasDisassociateConfigurationRequests()
                && Objects.equals(disassociateConfigurationRequests(), other.disassociateConfigurationRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchDisassociateCodeSecurityScanConfigurationRequest")
                .add("DisassociateConfigurationRequests",
                        hasDisassociateConfigurationRequests() ? disassociateConfigurationRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "disassociateConfigurationRequests":
            return Optional.ofNullable(clazz.cast(disassociateConfigurationRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("disassociateConfigurationRequests", DISASSOCIATE_CONFIGURATION_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDisassociateCodeSecurityScanConfigurationRequest, T> g) {
        return obj -> g.apply((BatchDisassociateCodeSecurityScanConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Inspector2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDisassociateCodeSecurityScanConfigurationRequest> {
        /**
         * <p>
         * A list of code repositories to disassociate from the specified scan configuration.
         * </p>
         * 
         * @param disassociateConfigurationRequests
         *        A list of code repositories to disassociate from the specified scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociateConfigurationRequests(Collection<DisassociateConfigurationRequest> disassociateConfigurationRequests);

        /**
         * <p>
         * A list of code repositories to disassociate from the specified scan configuration.
         * </p>
         * 
         * @param disassociateConfigurationRequests
         *        A list of code repositories to disassociate from the specified scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociateConfigurationRequests(DisassociateConfigurationRequest... disassociateConfigurationRequests);

        /**
         * <p>
         * A list of code repositories to disassociate from the specified scan configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.DisassociateConfigurationRequest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.inspector2.model.DisassociateConfigurationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.DisassociateConfigurationRequest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #disassociateConfigurationRequests(List<DisassociateConfigurationRequest>)}.
         * 
         * @param disassociateConfigurationRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.DisassociateConfigurationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disassociateConfigurationRequests(java.util.Collection<DisassociateConfigurationRequest>)
         */
        Builder disassociateConfigurationRequests(
                Consumer<DisassociateConfigurationRequest.Builder>... disassociateConfigurationRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Inspector2Request.BuilderImpl implements Builder {
        private List<DisassociateConfigurationRequest> disassociateConfigurationRequests = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisassociateCodeSecurityScanConfigurationRequest model) {
            super(model);
            disassociateConfigurationRequests(model.disassociateConfigurationRequests);
        }

        public final List<DisassociateConfigurationRequest.Builder> getDisassociateConfigurationRequests() {
            List<DisassociateConfigurationRequest.Builder> result = DisassociateConfigurationRequestListCopier
                    .copyToBuilder(this.disassociateConfigurationRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDisassociateConfigurationRequests(
                Collection<DisassociateConfigurationRequest.BuilderImpl> disassociateConfigurationRequests) {
            this.disassociateConfigurationRequests = DisassociateConfigurationRequestListCopier
                    .copyFromBuilder(disassociateConfigurationRequests);
        }

        @Override
        public final Builder disassociateConfigurationRequests(
                Collection<DisassociateConfigurationRequest> disassociateConfigurationRequests) {
            this.disassociateConfigurationRequests = DisassociateConfigurationRequestListCopier
                    .copy(disassociateConfigurationRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disassociateConfigurationRequests(
                DisassociateConfigurationRequest... disassociateConfigurationRequests) {
            disassociateConfigurationRequests(Arrays.asList(disassociateConfigurationRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disassociateConfigurationRequests(
                Consumer<DisassociateConfigurationRequest.Builder>... disassociateConfigurationRequests) {
            disassociateConfigurationRequests(Stream.of(disassociateConfigurationRequests)
                    .map(c -> DisassociateConfigurationRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDisassociateCodeSecurityScanConfigurationRequest build() {
            return new BatchDisassociateCodeSecurityScanConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
