/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CIS scan configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CisScanConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CisScanConfiguration.Builder, CisScanConfiguration> {
    private static final SdkField<String> SCAN_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanConfigurationArn").getter(getter(CisScanConfiguration::scanConfigurationArn))
            .setter(setter(Builder::scanConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfigurationArn").build())
            .build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerId").getter(getter(CisScanConfiguration::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerId").build()).build();

    private static final SdkField<String> SCAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanName").getter(getter(CisScanConfiguration::scanName)).setter(setter(Builder::scanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanName").build()).build();

    private static final SdkField<String> SECURITY_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityLevel").getter(getter(CisScanConfiguration::securityLevelAsString))
            .setter(setter(Builder::securityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityLevel").build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(CisScanConfiguration::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<CisTargets> TARGETS_FIELD = SdkField.<CisTargets> builder(MarshallingType.SDK_POJO)
            .memberName("targets").getter(getter(CisScanConfiguration::targets)).setter(setter(Builder::targets))
            .constructor(CisTargets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CisScanConfiguration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_CONFIGURATION_ARN_FIELD,
            OWNER_ID_FIELD, SCAN_NAME_FIELD, SECURITY_LEVEL_FIELD, SCHEDULE_FIELD, TARGETS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scanConfigurationArn;

    private final String ownerId;

    private final String scanName;

    private final String securityLevel;

    private final Schedule schedule;

    private final CisTargets targets;

    private final Map<String, String> tags;

    private CisScanConfiguration(BuilderImpl builder) {
        this.scanConfigurationArn = builder.scanConfigurationArn;
        this.ownerId = builder.ownerId;
        this.scanName = builder.scanName;
        this.securityLevel = builder.securityLevel;
        this.schedule = builder.schedule;
        this.targets = builder.targets;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The CIS scan configuration's scan configuration ARN.
     * </p>
     * 
     * @return The CIS scan configuration's scan configuration ARN.
     */
    public final String scanConfigurationArn() {
        return scanConfigurationArn;
    }

    /**
     * <p>
     * The CIS scan configuration's owner ID.
     * </p>
     * 
     * @return The CIS scan configuration's owner ID.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The name of the CIS scan configuration.
     * </p>
     * 
     * @return The name of the CIS scan configuration.
     */
    public final String scanName() {
        return scanName;
    }

    /**
     * <p>
     * The CIS scan configuration's security level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityLevel}
     * will return {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityLevelAsString}.
     * </p>
     * 
     * @return The CIS scan configuration's security level.
     * @see CisSecurityLevel
     */
    public final CisSecurityLevel securityLevel() {
        return CisSecurityLevel.fromValue(securityLevel);
    }

    /**
     * <p>
     * The CIS scan configuration's security level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #securityLevel}
     * will return {@link CisSecurityLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #securityLevelAsString}.
     * </p>
     * 
     * @return The CIS scan configuration's security level.
     * @see CisSecurityLevel
     */
    public final String securityLevelAsString() {
        return securityLevel;
    }

    /**
     * <p>
     * The CIS scan configuration's schedule.
     * </p>
     * 
     * @return The CIS scan configuration's schedule.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The CIS scan configuration's targets.
     * </p>
     * 
     * @return The CIS scan configuration's targets.
     */
    public final CisTargets targets() {
        return targets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The CIS scan configuration's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The CIS scan configuration's tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(scanName());
        hashCode = 31 * hashCode + Objects.hashCode(securityLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CisScanConfiguration)) {
            return false;
        }
        CisScanConfiguration other = (CisScanConfiguration) obj;
        return Objects.equals(scanConfigurationArn(), other.scanConfigurationArn()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(scanName(), other.scanName())
                && Objects.equals(securityLevelAsString(), other.securityLevelAsString())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(targets(), other.targets())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CisScanConfiguration").add("ScanConfigurationArn", scanConfigurationArn())
                .add("OwnerId", ownerId()).add("ScanName", scanName()).add("SecurityLevel", securityLevelAsString())
                .add("Schedule", schedule()).add("Targets", targets()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanConfigurationArn":
            return Optional.ofNullable(clazz.cast(scanConfigurationArn()));
        case "ownerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "scanName":
            return Optional.ofNullable(clazz.cast(scanName()));
        case "securityLevel":
            return Optional.ofNullable(clazz.cast(securityLevelAsString()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanConfigurationArn", SCAN_CONFIGURATION_ARN_FIELD);
        map.put("ownerId", OWNER_ID_FIELD);
        map.put("scanName", SCAN_NAME_FIELD);
        map.put("securityLevel", SECURITY_LEVEL_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("targets", TARGETS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CisScanConfiguration, T> g) {
        return obj -> g.apply((CisScanConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CisScanConfiguration> {
        /**
         * <p>
         * The CIS scan configuration's scan configuration ARN.
         * </p>
         * 
         * @param scanConfigurationArn
         *        The CIS scan configuration's scan configuration ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfigurationArn(String scanConfigurationArn);

        /**
         * <p>
         * The CIS scan configuration's owner ID.
         * </p>
         * 
         * @param ownerId
         *        The CIS scan configuration's owner ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The name of the CIS scan configuration.
         * </p>
         * 
         * @param scanName
         *        The name of the CIS scan configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanName(String scanName);

        /**
         * <p>
         * The CIS scan configuration's security level.
         * </p>
         * 
         * @param securityLevel
         *        The CIS scan configuration's security level.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder securityLevel(String securityLevel);

        /**
         * <p>
         * The CIS scan configuration's security level.
         * </p>
         * 
         * @param securityLevel
         *        The CIS scan configuration's security level.
         * @see CisSecurityLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CisSecurityLevel
         */
        Builder securityLevel(CisSecurityLevel securityLevel);

        /**
         * <p>
         * The CIS scan configuration's schedule.
         * </p>
         * 
         * @param schedule
         *        The CIS scan configuration's schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The CIS scan configuration's schedule.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The CIS scan configuration's targets.
         * </p>
         * 
         * @param targets
         *        The CIS scan configuration's targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(CisTargets targets);

        /**
         * <p>
         * The CIS scan configuration's targets.
         * </p>
         * This is a convenience method that creates an instance of the {@link CisTargets.Builder} avoiding the need to
         * create one manually via {@link CisTargets#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CisTargets.Builder#build()} is called immediately and its result
         * is passed to {@link #targets(CisTargets)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link CisTargets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(CisTargets)
         */
        default Builder targets(Consumer<CisTargets.Builder> targets) {
            return targets(CisTargets.builder().applyMutation(targets).build());
        }

        /**
         * <p>
         * The CIS scan configuration's tags.
         * </p>
         * 
         * @param tags
         *        The CIS scan configuration's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String scanConfigurationArn;

        private String ownerId;

        private String scanName;

        private String securityLevel;

        private Schedule schedule;

        private CisTargets targets;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CisScanConfiguration model) {
            scanConfigurationArn(model.scanConfigurationArn);
            ownerId(model.ownerId);
            scanName(model.scanName);
            securityLevel(model.securityLevel);
            schedule(model.schedule);
            targets(model.targets);
            tags(model.tags);
        }

        public final String getScanConfigurationArn() {
            return scanConfigurationArn;
        }

        public final void setScanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
        }

        @Override
        public final Builder scanConfigurationArn(String scanConfigurationArn) {
            this.scanConfigurationArn = scanConfigurationArn;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getScanName() {
            return scanName;
        }

        public final void setScanName(String scanName) {
            this.scanName = scanName;
        }

        @Override
        public final Builder scanName(String scanName) {
            this.scanName = scanName;
            return this;
        }

        public final String getSecurityLevel() {
            return securityLevel;
        }

        public final void setSecurityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
        }

        @Override
        public final Builder securityLevel(String securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        @Override
        public final Builder securityLevel(CisSecurityLevel securityLevel) {
            this.securityLevel(securityLevel == null ? null : securityLevel.toString());
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final CisTargets.Builder getTargets() {
            return targets != null ? targets.toBuilder() : null;
        }

        public final void setTargets(CisTargets.BuilderImpl targets) {
            this.targets = targets != null ? targets.build() : null;
        }

        @Override
        public final Builder targets(CisTargets targets) {
            this.targets = targets;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = CisTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = CisTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CisScanConfiguration build() {
            return new CisScanConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
