/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the task or pod in the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterDetails implements SdkPojo, Serializable, ToCopyableBuilder<ClusterDetails.Builder, ClusterDetails> {
    private static final SdkField<Instant> LAST_IN_USE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastInUse").getter(getter(ClusterDetails::lastInUse)).setter(setter(Builder::lastInUse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastInUse").build()).build();

    private static final SdkField<Long> RUNNING_UNIT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("runningUnitCount").getter(getter(ClusterDetails::runningUnitCount))
            .setter(setter(Builder::runningUnitCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningUnitCount").build()).build();

    private static final SdkField<Long> STOPPED_UNIT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("stoppedUnitCount").getter(getter(ClusterDetails::stoppedUnitCount))
            .setter(setter(Builder::stoppedUnitCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppedUnitCount").build()).build();

    private static final SdkField<ClusterMetadata> CLUSTER_METADATA_FIELD = SdkField
            .<ClusterMetadata> builder(MarshallingType.SDK_POJO).memberName("clusterMetadata")
            .getter(getter(ClusterDetails::clusterMetadata)).setter(setter(Builder::clusterMetadata))
            .constructor(ClusterMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_IN_USE_FIELD,
            RUNNING_UNIT_COUNT_FIELD, STOPPED_UNIT_COUNT_FIELD, CLUSTER_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant lastInUse;

    private final Long runningUnitCount;

    private final Long stoppedUnitCount;

    private final ClusterMetadata clusterMetadata;

    private ClusterDetails(BuilderImpl builder) {
        this.lastInUse = builder.lastInUse;
        this.runningUnitCount = builder.runningUnitCount;
        this.stoppedUnitCount = builder.stoppedUnitCount;
        this.clusterMetadata = builder.clusterMetadata;
    }

    /**
     * <p>
     * The last timestamp when Amazon Inspector recorded the image in use in the task or pod in the cluster.
     * </p>
     * 
     * @return The last timestamp when Amazon Inspector recorded the image in use in the task or pod in the cluster.
     */
    public final Instant lastInUse() {
        return lastInUse;
    }

    /**
     * <p>
     * The number of tasks or pods where an image was running on the cluster.
     * </p>
     * 
     * @return The number of tasks or pods where an image was running on the cluster.
     */
    public final Long runningUnitCount() {
        return runningUnitCount;
    }

    /**
     * <p>
     * The number of tasks or pods where an image was stopped on the cluster in the last 24 hours.
     * </p>
     * 
     * @return The number of tasks or pods where an image was stopped on the cluster in the last 24 hours.
     */
    public final Long stoppedUnitCount() {
        return stoppedUnitCount;
    }

    /**
     * Returns the value of the ClusterMetadata property for this object.
     * 
     * @return The value of the ClusterMetadata property for this object.
     */
    public final ClusterMetadata clusterMetadata() {
        return clusterMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastInUse());
        hashCode = 31 * hashCode + Objects.hashCode(runningUnitCount());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedUnitCount());
        hashCode = 31 * hashCode + Objects.hashCode(clusterMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterDetails)) {
            return false;
        }
        ClusterDetails other = (ClusterDetails) obj;
        return Objects.equals(lastInUse(), other.lastInUse()) && Objects.equals(runningUnitCount(), other.runningUnitCount())
                && Objects.equals(stoppedUnitCount(), other.stoppedUnitCount())
                && Objects.equals(clusterMetadata(), other.clusterMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterDetails").add("LastInUse", lastInUse()).add("RunningUnitCount", runningUnitCount())
                .add("StoppedUnitCount", stoppedUnitCount()).add("ClusterMetadata", clusterMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastInUse":
            return Optional.ofNullable(clazz.cast(lastInUse()));
        case "runningUnitCount":
            return Optional.ofNullable(clazz.cast(runningUnitCount()));
        case "stoppedUnitCount":
            return Optional.ofNullable(clazz.cast(stoppedUnitCount()));
        case "clusterMetadata":
            return Optional.ofNullable(clazz.cast(clusterMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lastInUse", LAST_IN_USE_FIELD);
        map.put("runningUnitCount", RUNNING_UNIT_COUNT_FIELD);
        map.put("stoppedUnitCount", STOPPED_UNIT_COUNT_FIELD);
        map.put("clusterMetadata", CLUSTER_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterDetails, T> g) {
        return obj -> g.apply((ClusterDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterDetails> {
        /**
         * <p>
         * The last timestamp when Amazon Inspector recorded the image in use in the task or pod in the cluster.
         * </p>
         * 
         * @param lastInUse
         *        The last timestamp when Amazon Inspector recorded the image in use in the task or pod in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastInUse(Instant lastInUse);

        /**
         * <p>
         * The number of tasks or pods where an image was running on the cluster.
         * </p>
         * 
         * @param runningUnitCount
         *        The number of tasks or pods where an image was running on the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningUnitCount(Long runningUnitCount);

        /**
         * <p>
         * The number of tasks or pods where an image was stopped on the cluster in the last 24 hours.
         * </p>
         * 
         * @param stoppedUnitCount
         *        The number of tasks or pods where an image was stopped on the cluster in the last 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedUnitCount(Long stoppedUnitCount);

        /**
         * Sets the value of the ClusterMetadata property for this object.
         *
         * @param clusterMetadata
         *        The new value for the ClusterMetadata property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterMetadata(ClusterMetadata clusterMetadata);

        /**
         * Sets the value of the ClusterMetadata property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ClusterMetadata.Builder} avoiding the
         * need to create one manually via {@link ClusterMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #clusterMetadata(ClusterMetadata)}.
         * 
         * @param clusterMetadata
         *        a consumer that will call methods on {@link ClusterMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterMetadata(ClusterMetadata)
         */
        default Builder clusterMetadata(Consumer<ClusterMetadata.Builder> clusterMetadata) {
            return clusterMetadata(ClusterMetadata.builder().applyMutation(clusterMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant lastInUse;

        private Long runningUnitCount;

        private Long stoppedUnitCount;

        private ClusterMetadata clusterMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterDetails model) {
            lastInUse(model.lastInUse);
            runningUnitCount(model.runningUnitCount);
            stoppedUnitCount(model.stoppedUnitCount);
            clusterMetadata(model.clusterMetadata);
        }

        public final Instant getLastInUse() {
            return lastInUse;
        }

        public final void setLastInUse(Instant lastInUse) {
            this.lastInUse = lastInUse;
        }

        @Override
        public final Builder lastInUse(Instant lastInUse) {
            this.lastInUse = lastInUse;
            return this;
        }

        public final Long getRunningUnitCount() {
            return runningUnitCount;
        }

        public final void setRunningUnitCount(Long runningUnitCount) {
            this.runningUnitCount = runningUnitCount;
        }

        @Override
        public final Builder runningUnitCount(Long runningUnitCount) {
            this.runningUnitCount = runningUnitCount;
            return this;
        }

        public final Long getStoppedUnitCount() {
            return stoppedUnitCount;
        }

        public final void setStoppedUnitCount(Long stoppedUnitCount) {
            this.stoppedUnitCount = stoppedUnitCount;
        }

        @Override
        public final Builder stoppedUnitCount(Long stoppedUnitCount) {
            this.stoppedUnitCount = stoppedUnitCount;
            return this;
        }

        public final ClusterMetadata.Builder getClusterMetadata() {
            return clusterMetadata != null ? clusterMetadata.toBuilder() : null;
        }

        public final void setClusterMetadata(ClusterMetadata.BuilderImpl clusterMetadata) {
            this.clusterMetadata = clusterMetadata != null ? clusterMetadata.build() : null;
        }

        @Override
        public final Builder clusterMetadata(ClusterMetadata clusterMetadata) {
            this.clusterMetadata = clusterMetadata;
            return this;
        }

        @Override
        public ClusterDetails build() {
            return new ClusterDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
