/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details that define an aggregation based on code repositories.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeRepositoryAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeRepositoryAggregation.Builder, CodeRepositoryAggregation> {
    private static final SdkField<List<StringFilter>> PROJECT_NAMES_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("projectNames")
            .getter(getter(CodeRepositoryAggregation::projectNames))
            .setter(setter(Builder::projectNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StringFilter>> PROVIDER_TYPES_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("providerTypes")
            .getter(getter(CodeRepositoryAggregation::providerTypes))
            .setter(setter(Builder::providerTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(CodeRepositoryAggregation::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(CodeRepositoryAggregation::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<List<StringFilter>> RESOURCE_IDS_FIELD = SdkField
            .<List<StringFilter>> builder(MarshallingType.LIST)
            .memberName("resourceIds")
            .getter(getter(CodeRepositoryAggregation::resourceIds))
            .setter(setter(Builder::resourceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAMES_FIELD,
            PROVIDER_TYPES_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD, RESOURCE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<StringFilter> projectNames;

    private final List<StringFilter> providerTypes;

    private final String sortOrder;

    private final String sortBy;

    private final List<StringFilter> resourceIds;

    private CodeRepositoryAggregation(BuilderImpl builder) {
        this.projectNames = builder.projectNames;
        this.providerTypes = builder.providerTypes;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.resourceIds = builder.resourceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProjectNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProjectNames() {
        return projectNames != null && !(projectNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The project names to include in the aggregation results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjectNames} method.
     * </p>
     * 
     * @return The project names to include in the aggregation results.
     */
    public final List<StringFilter> projectNames() {
        return projectNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProviderTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProviderTypes() {
        return providerTypes != null && !(providerTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The repository provider types to include in the aggregation results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProviderTypes} method.
     * </p>
     * 
     * @return The repository provider types to include in the aggregation results.
     */
    public final List<StringFilter> providerTypes() {
        return providerTypes;
    }

    /**
     * <p>
     * The order to sort results by (ascending or descending) in the code repository aggregation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by (ascending or descending) in the code repository aggregation.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order to sort results by (ascending or descending) in the code repository aggregation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort results by (ascending or descending) in the code repository aggregation.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The value to sort results by in the code repository aggregation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link CodeRepositorySortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by in the code repository aggregation.
     * @see CodeRepositorySortBy
     */
    public final CodeRepositorySortBy sortBy() {
        return CodeRepositorySortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The value to sort results by in the code repository aggregation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link CodeRepositorySortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return The value to sort results by in the code repository aggregation.
     * @see CodeRepositorySortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIds() {
        return resourceIds != null && !(resourceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource IDs to include in the aggregation results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIds} method.
     * </p>
     * 
     * @return The resource IDs to include in the aggregation results.
     */
    public final List<StringFilter> resourceIds() {
        return resourceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectNames() ? projectNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProviderTypes() ? providerTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIds() ? resourceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositoryAggregation)) {
            return false;
        }
        CodeRepositoryAggregation other = (CodeRepositoryAggregation) obj;
        return hasProjectNames() == other.hasProjectNames() && Objects.equals(projectNames(), other.projectNames())
                && hasProviderTypes() == other.hasProviderTypes() && Objects.equals(providerTypes(), other.providerTypes())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString()) && hasResourceIds() == other.hasResourceIds()
                && Objects.equals(resourceIds(), other.resourceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeRepositoryAggregation").add("ProjectNames", hasProjectNames() ? projectNames() : null)
                .add("ProviderTypes", hasProviderTypes() ? providerTypes() : null).add("SortOrder", sortOrderAsString())
                .add("SortBy", sortByAsString()).add("ResourceIds", hasResourceIds() ? resourceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectNames":
            return Optional.ofNullable(clazz.cast(projectNames()));
        case "providerTypes":
            return Optional.ofNullable(clazz.cast(providerTypes()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "resourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectNames", PROJECT_NAMES_FIELD);
        map.put("providerTypes", PROVIDER_TYPES_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("resourceIds", RESOURCE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositoryAggregation, T> g) {
        return obj -> g.apply((CodeRepositoryAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeRepositoryAggregation> {
        /**
         * <p>
         * The project names to include in the aggregation results.
         * </p>
         * 
         * @param projectNames
         *        The project names to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectNames(Collection<StringFilter> projectNames);

        /**
         * <p>
         * The project names to include in the aggregation results.
         * </p>
         * 
         * @param projectNames
         *        The project names to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectNames(StringFilter... projectNames);

        /**
         * <p>
         * The project names to include in the aggregation results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #projectNames(List<StringFilter>)}.
         * 
         * @param projectNames
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectNames(java.util.Collection<StringFilter>)
         */
        Builder projectNames(Consumer<StringFilter.Builder>... projectNames);

        /**
         * <p>
         * The repository provider types to include in the aggregation results.
         * </p>
         * 
         * @param providerTypes
         *        The repository provider types to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTypes(Collection<StringFilter> providerTypes);

        /**
         * <p>
         * The repository provider types to include in the aggregation results.
         * </p>
         * 
         * @param providerTypes
         *        The repository provider types to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTypes(StringFilter... providerTypes);

        /**
         * <p>
         * The repository provider types to include in the aggregation results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #providerTypes(List<StringFilter>)}.
         * 
         * @param providerTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerTypes(java.util.Collection<StringFilter>)
         */
        Builder providerTypes(Consumer<StringFilter.Builder>... providerTypes);

        /**
         * <p>
         * The order to sort results by (ascending or descending) in the code repository aggregation.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by (ascending or descending) in the code repository aggregation.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order to sort results by (ascending or descending) in the code repository aggregation.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort results by (ascending or descending) in the code repository aggregation.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The value to sort results by in the code repository aggregation.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by in the code repository aggregation.
         * @see CodeRepositorySortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeRepositorySortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The value to sort results by in the code repository aggregation.
         * </p>
         * 
         * @param sortBy
         *        The value to sort results by in the code repository aggregation.
         * @see CodeRepositorySortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeRepositorySortBy
         */
        Builder sortBy(CodeRepositorySortBy sortBy);

        /**
         * <p>
         * The resource IDs to include in the aggregation results.
         * </p>
         * 
         * @param resourceIds
         *        The resource IDs to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<StringFilter> resourceIds);

        /**
         * <p>
         * The resource IDs to include in the aggregation results.
         * </p>
         * 
         * @param resourceIds
         *        The resource IDs to include in the aggregation results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(StringFilter... resourceIds);

        /**
         * <p>
         * The resource IDs to include in the aggregation results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.inspector2.model.StringFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceIds(List<StringFilter>)}.
         * 
         * @param resourceIds
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.inspector2.model.StringFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIds(java.util.Collection<StringFilter>)
         */
        Builder resourceIds(Consumer<StringFilter.Builder>... resourceIds);
    }

    static final class BuilderImpl implements Builder {
        private List<StringFilter> projectNames = DefaultSdkAutoConstructList.getInstance();

        private List<StringFilter> providerTypes = DefaultSdkAutoConstructList.getInstance();

        private String sortOrder;

        private String sortBy;

        private List<StringFilter> resourceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositoryAggregation model) {
            projectNames(model.projectNames);
            providerTypes(model.providerTypes);
            sortOrder(model.sortOrder);
            sortBy(model.sortBy);
            resourceIds(model.resourceIds);
        }

        public final List<StringFilter.Builder> getProjectNames() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.projectNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectNames(Collection<StringFilter.BuilderImpl> projectNames) {
            this.projectNames = StringFilterListCopier.copyFromBuilder(projectNames);
        }

        @Override
        public final Builder projectNames(Collection<StringFilter> projectNames) {
            this.projectNames = StringFilterListCopier.copy(projectNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectNames(StringFilter... projectNames) {
            projectNames(Arrays.asList(projectNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectNames(Consumer<StringFilter.Builder>... projectNames) {
            projectNames(Stream.of(projectNames).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StringFilter.Builder> getProviderTypes() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.providerTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProviderTypes(Collection<StringFilter.BuilderImpl> providerTypes) {
            this.providerTypes = StringFilterListCopier.copyFromBuilder(providerTypes);
        }

        @Override
        public final Builder providerTypes(Collection<StringFilter> providerTypes) {
            this.providerTypes = StringFilterListCopier.copy(providerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypes(StringFilter... providerTypes) {
            providerTypes(Arrays.asList(providerTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerTypes(Consumer<StringFilter.Builder>... providerTypes) {
            providerTypes(Stream.of(providerTypes).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(CodeRepositorySortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final List<StringFilter.Builder> getResourceIds() {
            List<StringFilter.Builder> result = StringFilterListCopier.copyToBuilder(this.resourceIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIds(Collection<StringFilter.BuilderImpl> resourceIds) {
            this.resourceIds = StringFilterListCopier.copyFromBuilder(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<StringFilter> resourceIds) {
            this.resourceIds = StringFilterListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(StringFilter... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(Consumer<StringFilter.Builder>... resourceIds) {
            resourceIds(Stream.of(resourceIds).map(c -> StringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CodeRepositoryAggregation build() {
            return new CodeRepositoryAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
