/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.inspector2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata information about a code repository that is being scanned by Amazon Inspector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeRepositoryMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeRepositoryMetadata.Builder, CodeRepositoryMetadata> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(CodeRepositoryMetadata::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationArn").getter(getter(CodeRepositoryMetadata::integrationArn))
            .setter(setter(Builder::integrationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationArn").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerType").getter(getter(CodeRepositoryMetadata::providerType))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerType").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerTypeVisibility").getter(getter(CodeRepositoryMetadata::providerTypeVisibility))
            .setter(setter(Builder::providerTypeVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerTypeVisibility").build())
            .build();

    private static final SdkField<String> LAST_SCANNED_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastScannedCommitId").getter(getter(CodeRepositoryMetadata::lastScannedCommitId))
            .setter(setter(Builder::lastScannedCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastScannedCommitId").build())
            .build();

    private static final SdkField<ProjectCodeSecurityScanConfiguration> SCAN_CONFIGURATION_FIELD = SdkField
            .<ProjectCodeSecurityScanConfiguration> builder(MarshallingType.SDK_POJO).memberName("scanConfiguration")
            .getter(getter(CodeRepositoryMetadata::scanConfiguration)).setter(setter(Builder::scanConfiguration))
            .constructor(ProjectCodeSecurityScanConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfiguration").build()).build();

    private static final SdkField<CodeRepositoryOnDemandScan> ON_DEMAND_SCAN_FIELD = SdkField
            .<CodeRepositoryOnDemandScan> builder(MarshallingType.SDK_POJO).memberName("onDemandScan")
            .getter(getter(CodeRepositoryMetadata::onDemandScan)).setter(setter(Builder::onDemandScan))
            .constructor(CodeRepositoryOnDemandScan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onDemandScan").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            INTEGRATION_ARN_FIELD, PROVIDER_TYPE_FIELD, PROVIDER_TYPE_VISIBILITY_FIELD, LAST_SCANNED_COMMIT_ID_FIELD,
            SCAN_CONFIGURATION_FIELD, ON_DEMAND_SCAN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String projectName;

    private final String integrationArn;

    private final String providerType;

    private final String providerTypeVisibility;

    private final String lastScannedCommitId;

    private final ProjectCodeSecurityScanConfiguration scanConfiguration;

    private final CodeRepositoryOnDemandScan onDemandScan;

    private CodeRepositoryMetadata(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.integrationArn = builder.integrationArn;
        this.providerType = builder.providerType;
        this.providerTypeVisibility = builder.providerTypeVisibility;
        this.lastScannedCommitId = builder.lastScannedCommitId;
        this.scanConfiguration = builder.scanConfiguration;
        this.onDemandScan = builder.onDemandScan;
    }

    /**
     * <p>
     * The name of the project in the code repository.
     * </p>
     * 
     * @return The name of the project in the code repository.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the code security integration associated with the repository.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the code security integration associated with the repository.
     */
    public final String integrationArn() {
        return integrationArn;
    }

    /**
     * <p>
     * The type of repository provider (such as GitHub, GitLab, etc.).
     * </p>
     * 
     * @return The type of repository provider (such as GitHub, GitLab, etc.).
     */
    public final String providerType() {
        return providerType;
    }

    /**
     * <p>
     * The visibility setting of the repository (public or private).
     * </p>
     * 
     * @return The visibility setting of the repository (public or private).
     */
    public final String providerTypeVisibility() {
        return providerTypeVisibility;
    }

    /**
     * <p>
     * The ID of the last commit that was scanned in the repository.
     * </p>
     * 
     * @return The ID of the last commit that was scanned in the repository.
     */
    public final String lastScannedCommitId() {
        return lastScannedCommitId;
    }

    /**
     * <p>
     * The scan configuration settings applied to the code repository.
     * </p>
     * 
     * @return The scan configuration settings applied to the code repository.
     */
    public final ProjectCodeSecurityScanConfiguration scanConfiguration() {
        return scanConfiguration;
    }

    /**
     * <p>
     * Information about on-demand scans performed on the repository.
     * </p>
     * 
     * @return Information about on-demand scans performed on the repository.
     */
    public final CodeRepositoryOnDemandScan onDemandScan() {
        return onDemandScan;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(providerType());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeVisibility());
        hashCode = 31 * hashCode + Objects.hashCode(lastScannedCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(scanConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandScan());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepositoryMetadata)) {
            return false;
        }
        CodeRepositoryMetadata other = (CodeRepositoryMetadata) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(integrationArn(), other.integrationArn())
                && Objects.equals(providerType(), other.providerType())
                && Objects.equals(providerTypeVisibility(), other.providerTypeVisibility())
                && Objects.equals(lastScannedCommitId(), other.lastScannedCommitId())
                && Objects.equals(scanConfiguration(), other.scanConfiguration())
                && Objects.equals(onDemandScan(), other.onDemandScan());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeRepositoryMetadata").add("ProjectName", projectName())
                .add("IntegrationArn", integrationArn()).add("ProviderType", providerType())
                .add("ProviderTypeVisibility", providerTypeVisibility()).add("LastScannedCommitId", lastScannedCommitId())
                .add("ScanConfiguration", scanConfiguration()).add("OnDemandScan", onDemandScan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "integrationArn":
            return Optional.ofNullable(clazz.cast(integrationArn()));
        case "providerType":
            return Optional.ofNullable(clazz.cast(providerType()));
        case "providerTypeVisibility":
            return Optional.ofNullable(clazz.cast(providerTypeVisibility()));
        case "lastScannedCommitId":
            return Optional.ofNullable(clazz.cast(lastScannedCommitId()));
        case "scanConfiguration":
            return Optional.ofNullable(clazz.cast(scanConfiguration()));
        case "onDemandScan":
            return Optional.ofNullable(clazz.cast(onDemandScan()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("integrationArn", INTEGRATION_ARN_FIELD);
        map.put("providerType", PROVIDER_TYPE_FIELD);
        map.put("providerTypeVisibility", PROVIDER_TYPE_VISIBILITY_FIELD);
        map.put("lastScannedCommitId", LAST_SCANNED_COMMIT_ID_FIELD);
        map.put("scanConfiguration", SCAN_CONFIGURATION_FIELD);
        map.put("onDemandScan", ON_DEMAND_SCAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepositoryMetadata, T> g) {
        return obj -> g.apply((CodeRepositoryMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeRepositoryMetadata> {
        /**
         * <p>
         * The name of the project in the code repository.
         * </p>
         * 
         * @param projectName
         *        The name of the project in the code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the code security integration associated with the repository.
         * </p>
         * 
         * @param integrationArn
         *        The Amazon Resource Name (ARN) of the code security integration associated with the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationArn(String integrationArn);

        /**
         * <p>
         * The type of repository provider (such as GitHub, GitLab, etc.).
         * </p>
         * 
         * @param providerType
         *        The type of repository provider (such as GitHub, GitLab, etc.).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The visibility setting of the repository (public or private).
         * </p>
         * 
         * @param providerTypeVisibility
         *        The visibility setting of the repository (public or private).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerTypeVisibility(String providerTypeVisibility);

        /**
         * <p>
         * The ID of the last commit that was scanned in the repository.
         * </p>
         * 
         * @param lastScannedCommitId
         *        The ID of the last commit that was scanned in the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastScannedCommitId(String lastScannedCommitId);

        /**
         * <p>
         * The scan configuration settings applied to the code repository.
         * </p>
         * 
         * @param scanConfiguration
         *        The scan configuration settings applied to the code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanConfiguration(ProjectCodeSecurityScanConfiguration scanConfiguration);

        /**
         * <p>
         * The scan configuration settings applied to the code repository.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProjectCodeSecurityScanConfiguration.Builder} avoiding the need to create one manually via
         * {@link ProjectCodeSecurityScanConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectCodeSecurityScanConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #scanConfiguration(ProjectCodeSecurityScanConfiguration)}.
         * 
         * @param scanConfiguration
         *        a consumer that will call methods on {@link ProjectCodeSecurityScanConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scanConfiguration(ProjectCodeSecurityScanConfiguration)
         */
        default Builder scanConfiguration(Consumer<ProjectCodeSecurityScanConfiguration.Builder> scanConfiguration) {
            return scanConfiguration(ProjectCodeSecurityScanConfiguration.builder().applyMutation(scanConfiguration).build());
        }

        /**
         * <p>
         * Information about on-demand scans performed on the repository.
         * </p>
         * 
         * @param onDemandScan
         *        Information about on-demand scans performed on the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandScan(CodeRepositoryOnDemandScan onDemandScan);

        /**
         * <p>
         * Information about on-demand scans performed on the repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeRepositoryOnDemandScan.Builder}
         * avoiding the need to create one manually via {@link CodeRepositoryOnDemandScan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeRepositoryOnDemandScan.Builder#build()} is called immediately
         * and its result is passed to {@link #onDemandScan(CodeRepositoryOnDemandScan)}.
         * 
         * @param onDemandScan
         *        a consumer that will call methods on {@link CodeRepositoryOnDemandScan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDemandScan(CodeRepositoryOnDemandScan)
         */
        default Builder onDemandScan(Consumer<CodeRepositoryOnDemandScan.Builder> onDemandScan) {
            return onDemandScan(CodeRepositoryOnDemandScan.builder().applyMutation(onDemandScan).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String projectName;

        private String integrationArn;

        private String providerType;

        private String providerTypeVisibility;

        private String lastScannedCommitId;

        private ProjectCodeSecurityScanConfiguration scanConfiguration;

        private CodeRepositoryOnDemandScan onDemandScan;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepositoryMetadata model) {
            projectName(model.projectName);
            integrationArn(model.integrationArn);
            providerType(model.providerType);
            providerTypeVisibility(model.providerTypeVisibility);
            lastScannedCommitId(model.lastScannedCommitId);
            scanConfiguration(model.scanConfiguration);
            onDemandScan(model.onDemandScan);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getIntegrationArn() {
            return integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        public final String getProviderTypeVisibility() {
            return providerTypeVisibility;
        }

        public final void setProviderTypeVisibility(String providerTypeVisibility) {
            this.providerTypeVisibility = providerTypeVisibility;
        }

        @Override
        public final Builder providerTypeVisibility(String providerTypeVisibility) {
            this.providerTypeVisibility = providerTypeVisibility;
            return this;
        }

        public final String getLastScannedCommitId() {
            return lastScannedCommitId;
        }

        public final void setLastScannedCommitId(String lastScannedCommitId) {
            this.lastScannedCommitId = lastScannedCommitId;
        }

        @Override
        public final Builder lastScannedCommitId(String lastScannedCommitId) {
            this.lastScannedCommitId = lastScannedCommitId;
            return this;
        }

        public final ProjectCodeSecurityScanConfiguration.Builder getScanConfiguration() {
            return scanConfiguration != null ? scanConfiguration.toBuilder() : null;
        }

        public final void setScanConfiguration(ProjectCodeSecurityScanConfiguration.BuilderImpl scanConfiguration) {
            this.scanConfiguration = scanConfiguration != null ? scanConfiguration.build() : null;
        }

        @Override
        public final Builder scanConfiguration(ProjectCodeSecurityScanConfiguration scanConfiguration) {
            this.scanConfiguration = scanConfiguration;
            return this;
        }

        public final CodeRepositoryOnDemandScan.Builder getOnDemandScan() {
            return onDemandScan != null ? onDemandScan.toBuilder() : null;
        }

        public final void setOnDemandScan(CodeRepositoryOnDemandScan.BuilderImpl onDemandScan) {
            this.onDemandScan = onDemandScan != null ? onDemandScan.build() : null;
        }

        @Override
        public final Builder onDemandScan(CodeRepositoryOnDemandScan onDemandScan) {
            this.onDemandScan = onDemandScan;
            return this;
        }

        @Override
        public CodeRepositoryMetadata build() {
            return new CodeRepositoryMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
